/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.files.remote.tasks;

import com.owc.tools.files.remote.RemoteFileSystemCheck;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;

public class NotExistsRemoteFolderAndFileCheck
extends RemoteFileSystemCheck {
    public NotExistsRemoteFolderAndFileCheck(FileSystemManager manager, String fileName) {
        super(manager, "toolkit.remote_file_exists", fileName);
    }

    @Override
    public void performRemoteCheck(Operator op, long delayMillis, int numberOfRetries, FileObject remoteFile) throws RemoteFileSystemTaskFailedException, UserError {
        this.manager.getFilesCache().clear(remoteFile.getFileSystem());
        try {
            if (remoteFile.exists()) {
                if (remoteFile.isFolder()) {
                    throw new RemoteFileSystemTaskFailedException(new UserError(op, "toolkit.remote_files.folder_already_exists"));
                }
                throw new RemoteFileSystemTaskFailedException(new UserError(op, "toolkit.remote_files.file_already_exists"));
            }
        }
        catch (FileSystemException e) {
            throw new RemoteFileSystemTaskFailedException(new UserError(op, (Throwable)e, "toolkit.remote_file.check.existance.fail.unknown", new Object[]{remoteFile.getName().getBaseName()}));
        }
    }
}

