/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.monitor;

import com.owc.tools.ExampleSetCreator;
import com.rapidminer.Process;
import com.rapidminer.ProcessListener;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.processeditor.ExtendedProcessEditor;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ResultObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ProcessMonitor
implements ExtendedProcessEditor,
ProcessListener {
    private int counter = 1;
    private boolean wasStarted = false;
    private Process process;
    private Operator currentOperator = null;
    private long currentOperatorStartTime = 0L;
    private LinkedList<Operator> operatorStack = new LinkedList();
    private Map<String, Long> operatorRuntimes = new TreeMap<String, Long>();
    private Map<String, Integer> operatorExecutions = new TreeMap<String, Integer>();

    public void register() {
        RapidMinerGUI.getMainFrame().addExtendedProcessEditor((ExtendedProcessEditor)this);
        RapidMinerGUI.getMainFrame().getProcess().getRootOperator().addProcessListener((ProcessListener)this);
    }

    public void unregister() {
        RapidMinerGUI.getMainFrame().removeExtendedProcessEditor((ExtendedProcessEditor)this);
        RapidMinerGUI.getMainFrame().getProcess().getRootOperator().removeProcessListener((ProcessListener)this);
        this.wasStarted = false;
    }

    public void processChanged(Process process) {
        if (this.process != process) {
            if (this.process != null) {
                this.process.getRootOperator().removeProcessListener((ProcessListener)this);
            }
            this.process = process;
            if (process != null) {
                process.getRootOperator().addProcessListener((ProcessListener)this);
            }
        }
    }

    public void setSelection(List<Operator> selection) {
    }

    public void processUpdated(Process process) {
    }

    public void processViewChanged(Process process) {
    }

    public void processStarts(Process process) {
        this.currentOperator = null;
        this.operatorStack.clear();
        this.operatorRuntimes.clear();
        this.operatorExecutions.clear();
        this.wasStarted = true;
    }

    public void processStartedOperator(Process process, Operator op) {
        if (this.wasStarted) {
            Integer totalExecutions = this.operatorExecutions.get(op.getName());
            if (totalExecutions == null) {
                totalExecutions = 0;
            }
            this.operatorExecutions.put(op.getName(), totalExecutions + 1);
            long currentTimeMillis = System.currentTimeMillis();
            if (this.currentOperator != null) {
                Long totalRuntime = this.operatorRuntimes.get(this.currentOperator.getName());
                if (totalRuntime == null) {
                    totalRuntime = 0L;
                }
                totalRuntime = totalRuntime + currentTimeMillis - this.currentOperatorStartTime;
                this.operatorRuntimes.put(this.currentOperator.getName(), totalRuntime);
                this.operatorStack.push(this.currentOperator);
            }
            this.currentOperator = op;
            this.currentOperatorStartTime = currentTimeMillis;
        }
    }

    public void processFinishedOperator(Process process, Operator op) {
        if (this.wasStarted) {
            long currentTimeMillis = System.currentTimeMillis();
            Long totalRuntime = this.operatorRuntimes.get(op.getName());
            if (totalRuntime == null) {
                totalRuntime = 0L;
            }
            totalRuntime = totalRuntime + currentTimeMillis - this.currentOperatorStartTime;
            this.operatorRuntimes.put(op.getName(), totalRuntime);
            if (this.operatorStack.size() > 0) {
                this.currentOperator = this.operatorStack.pop();
                this.currentOperatorStartTime = currentTimeMillis;
            } else {
                this.currentOperator = null;
            }
        }
    }

    public void processEnded(Process process) {
        ExampleSet results = this.getResults();
        RapidMinerGUI.getMainFrame().getResultDisplay().showResult((ResultObject)results);
    }

    public boolean hasResults() {
        return !this.operatorRuntimes.isEmpty() && this.wasStarted;
    }

    public ExampleSet getResults() {
        ExampleSetCreator creator = new ExampleSetCreator(new String[]{"OperatorName", "Executions", "TotalRuntime", "AverageRuntime"}, new int[]{7, 3, 3, 4});
        for (Map.Entry<String, Long> entry : this.operatorRuntimes.entrySet()) {
            creator.setValue("OperatorName", entry.getKey());
            Integer executionCount = this.operatorExecutions.get(entry.getKey());
            creator.setValue("Executions", executionCount.intValue());
            Long runtime = entry.getValue();
            creator.setValue("TotalRuntime", runtime.longValue());
            creator.setValue("AverageRuntime", (double)runtime.longValue() / (double)executionCount.intValue());
            creator.commit();
        }
        ExampleSet resultSet = creator.finish();
        resultSet.setSource("Process Execution Performance Data (" + this.counter++ + ")");
        return resultSet;
    }
}

