/*
 * Decompiled with CFR 0.152.
 */
package com.owc.vfs2.impl;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.impl.VirtualFileName;
import org.apache.commons.vfs2.impl.VirtualFileSystem;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.AbstractVfsContainer;

public class VirtualFileProvider
extends AbstractVfsContainer {
    public FileObject createFileSystem(FileObject rootFile) throws FileSystemException {
        AbstractFileName rootName = (AbstractFileName)this.getContext().getFileSystemManager().resolveName(rootFile.getName(), "/");
        VirtualFileSystem fs = new VirtualFileSystem(rootName, rootFile.getFileSystem().getFileSystemOptions());
        this.addComponent(fs);
        fs.addJunction("/", rootFile);
        return fs.getRoot();
    }

    public FileObject createFileSystem(String rootUri) throws FileSystemException {
        VirtualFileName rootName = new VirtualFileName(rootUri, "/", FileType.FOLDER);
        VirtualFileSystem fs = new VirtualFileSystem(rootName, null);
        this.addComponent(fs);
        return fs.getRoot();
    }

    void closeFileSystem(FileSystem filesystem) {
        AbstractFileSystem fs = (AbstractFileSystem)filesystem;
        this.removeComponent(fs);
        fs.close();
    }
}

