/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.LockSupport;
import org.mapdb.Atomic;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.Bind;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.Engine;
import org.mapdb.Fun;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.Serializer;
import org.mapdb.SerializerBase;
import org.mapdb.Store;
import org.mapdb.TxEngine;

public class BTreeMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentNavigableMap<K, V>,
Bind.MapWithModificationListener<K, V>,
Closeable,
Serializable {
    protected final long rootRecidRef;
    protected final BTreeKeySerializer keySerializer;
    protected final Serializer<V> valueSerializer;
    protected final Serializer valueNodeSerializer;
    protected final LongConcurrentHashMap<Thread> nodeLocks = new LongConcurrentHashMap();
    protected final int maxNodeSize;
    protected final Engine engine;
    protected final boolean hasValues;
    protected final boolean valsOutsideNodes;
    protected final List<Long> leftEdges;
    private final KeySet keySet;
    private final EntrySet entrySet;
    private final Values values = new Values(this);
    private final ConcurrentNavigableMap<K, V> descendingMap = new DescendingMap(this, null, true, null, false);
    protected final Atomic.Long counter;
    protected final int numberOfNodeMetas;
    protected final boolean closeEngine;
    protected static final Serializer<ValRef> VALREF_SERIALIZER = new Serializer.EightByteSerializer<ValRef>(){

        @Override
        public void serialize(DataOutput out, ValRef value) throws IOException {
            DataIO.packLong(out, value.recid);
        }

        @Override
        public ValRef deserialize(DataInput in, int available) throws IOException {
            return new ValRef(DataIO.unpackLong(in));
        }

        @Override
        public int fixedSize() {
            return -1;
        }

        @Override
        public boolean equals(ValRef a1, ValRef a2) {
            throw new IllegalAccessError();
        }

        @Override
        public int hashCode(ValRef valRef, int seed) {
            throw new IllegalAccessError();
        }

        @Override
        protected ValRef unpack(long l) {
            return new ValRef(l);
        }

        @Override
        protected long pack(ValRef l) {
            return l.recid;
        }

        @Override
        public void valueArraySerialize(DataOutput out, Object vals) throws IOException {
            for (long o : (long[])vals) {
                DataIO.packLong(out, o);
            }
        }

        @Override
        public Object valueArrayDeserialize(DataInput in, int size) throws IOException {
            long[] ret = new long[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = DataIO.unpackLong(in);
            }
            return ret;
        }
    };
    protected static final Serializer<Boolean> BOOLEAN_PACKED = new Serializer.BooleanSer(){

        @Override
        public void valueArraySerialize(DataOutput out, Object vals) throws IOException {
            SerializerBase.writeBooleanArray(out, (boolean[])vals);
        }

        @Override
        public Object valueArrayDeserialize(DataInput in, int size) throws IOException {
            return SerializerBase.readBooleanArray(size, in);
        }
    };
    protected final Serializer<BNode> nodeSerializer;
    protected final Object modListenersLock = new Object();
    protected Bind.MapListener<K, V>[] modListeners = new Bind.MapListener[0];
    protected final Object modAfterListenersLock = new Object();
    protected Bind.MapListener<K, V>[] modAfterListeners = new Bind.MapListener[0];

    protected static SortedMap<String, Object> preinitCatalog(DB db) {
        Serializer valser;
        Long rootRef = db.getEngine().get(1L, Serializer.RECID);
        if (rootRef == null) {
            if (db.getEngine().isReadOnly()) {
                return Collections.unmodifiableSortedMap(new TreeMap());
            }
            NodeSerializer rootSerializer = new NodeSerializer(false, BTreeKeySerializer.STRING, db.getDefaultSerializer(), 0);
            LeafNode root = new LeafNode(BTreeKeySerializer.STRING.emptyKeys(), true, true, false, new Object[0], 0L);
            rootRef = db.getEngine().put(root, rootSerializer);
            db.getEngine().update(1L, rootRef, Serializer.RECID);
            db.getEngine().commit();
        }
        if ((valser = db.getDefaultSerializer()) == null) {
            throw new AssertionError();
        }
        return new BTreeMap<String, Object>(db.engine, false, 1L, 32, false, 0L, BTreeKeySerializer.STRING, valser, 0);
    }

    public BTreeMap(Engine engine, boolean closeEngine, long rootRecidRef, int maxNodeSize, boolean valsOutsideNodes, long counterRecid, BTreeKeySerializer keySerializer, Serializer<V> valueSerializer, int numberOfNodeMetas) {
        this.closeEngine = closeEngine;
        if (maxNodeSize % 2 != 0) {
            throw new IllegalArgumentException("maxNodeSize must be dividable by 2");
        }
        if (maxNodeSize < 6) {
            throw new IllegalArgumentException("maxNodeSize too low");
        }
        if ((maxNodeSize & 0x1FFF) != maxNodeSize) {
            throw new IllegalArgumentException("maxNodeSize too high");
        }
        if (rootRecidRef <= 0L || counterRecid < 0L || numberOfNodeMetas < 0) {
            throw new IllegalArgumentException();
        }
        if (keySerializer == null) {
            throw new NullPointerException();
        }
        this.rootRecidRef = rootRecidRef;
        this.hasValues = valueSerializer != null;
        this.valsOutsideNodes = valsOutsideNodes;
        this.engine = engine;
        this.maxNodeSize = maxNodeSize;
        this.numberOfNodeMetas = numberOfNodeMetas;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer != null ? valueSerializer : BOOLEAN_PACKED;
        this.valueNodeSerializer = valsOutsideNodes ? VALREF_SERIALIZER : this.valueSerializer;
        this.entrySet = new EntrySet(this, this.valueSerializer);
        this.nodeSerializer = new NodeSerializer(valsOutsideNodes, keySerializer, this.valueNodeSerializer, numberOfNodeMetas);
        this.keySet = new KeySet(this, this.hasValues);
        if (counterRecid != 0L) {
            this.counter = new Atomic.Long(engine, counterRecid);
            Bind.size(this, this.counter);
        } else {
            this.counter = null;
        }
        ArrayList<Long> leftEdges2 = new ArrayList<Long>();
        long r = engine.get(rootRecidRef, Serializer.RECID);
        while (true) {
            if (r <= 0L) {
                throw new DBException.DataCorruption("wrong recid");
            }
            BNode n = engine.get(r, this.nodeSerializer);
            leftEdges2.add(r);
            if (n.isLeaf()) break;
            r = n.child(0);
        }
        Collections.reverse(leftEdges2);
        this.leftEdges = Collections.synchronizedList(leftEdges2);
    }

    protected static long createRootRef(Engine engine, BTreeKeySerializer keySer, Serializer valueSer, boolean valuesOutsideNodes, int numberOfNodeMetas) {
        if (valuesOutsideNodes) {
            valueSer = VALREF_SERIALIZER;
        } else if (valueSer == null) {
            valueSer = BOOLEAN_PACKED;
        }
        Object emptyArray = valueSer.valueArrayEmpty();
        LeafNode emptyRoot = new LeafNode(keySer.emptyKeys(), true, true, false, emptyArray, 0L);
        long rootRecidVal = engine.put(emptyRoot, new NodeSerializer(false, keySer, valueSer, numberOfNodeMetas));
        return engine.put(rootRecidVal, Serializer.RECID);
    }

    @Override
    public V get(Object key) {
        return (V)this.get(key, true);
    }

    protected Object get(Object key, boolean expandValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        Object v = key;
        long current = this.engine.get(this.rootRecidRef, Serializer.RECID);
        BNode A = this.engine.get(current, this.nodeSerializer);
        while (!A.isLeaf()) {
            current = this.nextDir((DirNode)A, v);
            A = this.engine.get(current, this.nodeSerializer);
        }
        while (true) {
            int pos;
            if ((pos = this.keySerializer.findChildren2(A, key)) > 0 && pos != A.keysLen(this.keySerializer) - 1) {
                Object val = A.val(pos - 1, this.valueNodeSerializer);
                if (expandValue) {
                    val = this.valExpand(val);
                }
                return val;
            }
            if (pos > 0 || -pos <= A.keysLen(this.keySerializer)) break;
            current = A.next();
            if (current == 0L) {
                return null;
            }
            A = this.engine.get(current, this.nodeSerializer);
        }
        return null;
    }

    protected V valExpand(Object ret) {
        if (this.valsOutsideNodes && ret != null) {
            long recid = ((ValRef)ret).recid;
            ret = this.engine.get(recid, this.valueSerializer);
        }
        return (V)ret;
    }

    protected final long nextDir(DirNode d, Object key) {
        int pos = this.keySerializer.findChildren(d, key) - 1;
        if (pos < 0) {
            pos = 0;
        }
        return d.child(pos);
    }

    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.put2(key, value, false);
    }

    protected V put2(K key, V value2, boolean putOnlyIfAbsent) {
        long rootRecid;
        Object v = key;
        int stackPos = -1;
        long[] stackVals = new long[4];
        long current = rootRecid = this.engine.get(this.rootRecidRef, Serializer.RECID).longValue();
        BNode A = this.engine.get(current, this.nodeSerializer);
        while (!A.isLeaf()) {
            long t = current;
            current = this.nextDir((DirNode)A, v);
            if (current <= 0L) {
                throw new DBException.DataCorruption("wrong recid");
            }
            if (current != A.next()) {
                if (stackVals.length == ++stackPos) {
                    stackVals = Arrays.copyOf(stackVals, stackVals.length * 2);
                }
                stackVals[stackPos] = t;
            }
            A = this.engine.get(current, this.nodeSerializer);
        }
        int level = 0;
        long p = 0L;
        try {
            Object[] objectArray;
            long q;
            block22: {
                while (true) {
                    int pos;
                    BTreeMap.lock(this.nodeLocks, current);
                    boolean found = true;
                    A = this.engine.get(current, this.nodeSerializer);
                    int pos2 = this.keySerializer.findChildren(A, v);
                    if (pos2 < A.keysLen(this.keySerializer) - 1 && v != null && A.key(this.keySerializer, pos2) != null && 0 == A.compare(this.keySerializer, pos2, v)) {
                        Object oldVal = A.val(pos2 - 1, this.valueNodeSerializer);
                        if (putOnlyIfAbsent) {
                            BTreeMap.unlock(this.nodeLocks, current);
                            BTreeMap.assertNoLocks(this.nodeLocks);
                            return this.valExpand(oldVal);
                        }
                        if (this.valsOutsideNodes) {
                            long recid = ((ValRef)oldVal).recid;
                            oldVal = this.valExpand(oldVal);
                            this.engine.update(recid, value2, this.valueSerializer);
                        } else {
                            A = ((LeafNode)A).copyChangeValue(this.valueNodeSerializer, pos2, value2);
                            this.engine.update(current, A, this.nodeSerializer);
                        }
                        if (this.nodeLocks.get(current) != Thread.currentThread()) {
                            throw new AssertionError();
                        }
                        this.notify(key, oldVal, value2);
                        BTreeMap.unlock(this.nodeLocks, current);
                        this.notifyAfter(key, oldVal, value2);
                        BTreeMap.assertNoLocks(this.nodeLocks);
                        return (V)oldVal;
                    }
                    if (!A.isRightEdge() && A.compare(this.keySerializer, A.keysLen(this.keySerializer) - 1, v) < 0) {
                        long next;
                        BTreeMap.unlock(this.nodeLocks, current);
                        found = false;
                        int pos22 = this.keySerializer.findChildren(A, v);
                        while (A != null && pos22 == A.keysLen(this.keySerializer) && (next = A.next()) != 0L) {
                            current = next;
                            A = this.engine.get(current, this.nodeSerializer);
                            pos22 = this.keySerializer.findChildren(A, v);
                        }
                    }
                    if (!found) continue;
                    Object value = value2;
                    if (this.valsOutsideNodes) {
                        long recid = this.engine.put(value2, this.valueSerializer);
                        value = new ValRef(recid);
                    }
                    if ((A = A.copyAddKey(this.keySerializer, this.valueNodeSerializer, pos = this.keySerializer.findChildren(A, v), v, p, value)).keysLen(this.keySerializer) - (A.isLeaf() ? 1 : 0) < this.maxNodeSize) {
                        if (this.nodeLocks.get(current) != Thread.currentThread()) {
                            throw new AssertionError();
                        }
                        this.engine.update(current, A, this.nodeSerializer);
                        this.notify(key, null, value2);
                        BTreeMap.unlock(this.nodeLocks, current);
                        this.notifyAfter(key, null, value2);
                        BTreeMap.assertNoLocks(this.nodeLocks);
                        return null;
                    }
                    int splitPos = A.keysLen(this.keySerializer) / 2;
                    BNode B = A.copySplitRight(this.keySerializer, this.valueNodeSerializer, splitPos);
                    q = this.engine.put(B, this.nodeSerializer);
                    A = A.copySplitLeft(this.keySerializer, this.valueNodeSerializer, splitPos, q);
                    if (this.nodeLocks.get(current) != Thread.currentThread()) {
                        throw new AssertionError();
                    }
                    this.engine.update(current, A, this.nodeSerializer);
                    if (current == rootRecid) break block22;
                    BTreeMap.unlock(this.nodeLocks, current);
                    p = q;
                    v = A.highKey(this.keySerializer);
                    current = stackPos != -1 ? stackVals[stackPos--] : this.leftEdges.get(++level - 1);
                    if (current <= 0L) break;
                }
                throw new DBException.DataCorruption("wrong recid");
            }
            if (current < Integer.MAX_VALUE && q < Integer.MAX_VALUE) {
                int[] nArray = new int[3];
                nArray[0] = (int)current;
                nArray[1] = (int)q;
                objectArray = nArray;
                nArray[2] = 0;
            } else {
                long[] lArray = new long[3];
                lArray[0] = current;
                lArray[1] = q;
                objectArray = lArray;
                lArray[2] = 0L;
            }
            long[] rootChild = objectArray;
            DirNode R = new DirNode(this.keySerializer.arrayToKeys(new Object[]{A.highKey(this.keySerializer)}), true, true, false, rootChild);
            BTreeMap.unlock(this.nodeLocks, current);
            BTreeMap.lock(this.nodeLocks, this.rootRecidRef);
            long newRootRecid = this.engine.put(R, this.nodeSerializer);
            if (this.nodeLocks.get(this.rootRecidRef) != Thread.currentThread()) {
                throw new AssertionError();
            }
            this.leftEdges.add(newRootRecid);
            this.engine.update(this.rootRecidRef, newRootRecid, Serializer.RECID);
            this.notify(key, null, value2);
            BTreeMap.unlock(this.nodeLocks, this.rootRecidRef);
            this.notifyAfter(key, null, value2);
            BTreeMap.assertNoLocks(this.nodeLocks);
            return null;
        }
        catch (RuntimeException e) {
            BTreeMap.unlockAll(this.nodeLocks);
            throw e;
        }
        catch (Exception e) {
            BTreeMap.unlockAll(this.nodeLocks);
            throw new RuntimeException(e);
        }
    }

    @Override
    public V remove(Object key) {
        return this.removeOrReplace(key, null, null);
    }

    private V removeOrReplace(Object key, Object value, Object putNewValue) {
        if (key == null) {
            throw new NullPointerException("null key");
        }
        long current = this.engine.get(this.rootRecidRef, Serializer.RECID);
        BNode A = this.engine.get(current, this.nodeSerializer);
        while (!A.isLeaf()) {
            current = this.nextDir((DirNode)A, key);
            A = this.engine.get(current, this.nodeSerializer);
        }
        long old = 0L;
        try {
            do {
                if (old != 0L) {
                    BTreeMap.unlock(this.nodeLocks, old);
                }
                BTreeMap.lock(this.nodeLocks, current);
                A = this.engine.get(current, this.nodeSerializer);
                int pos = this.keySerializer.findChildren2(A, key);
                if (pos > 0 && pos != A.keysLen(this.keySerializer) - 1) {
                    Object oldValNotExpanded = A.val(pos - 1, this.valueNodeSerializer);
                    V oldVal = this.valExpand(oldValNotExpanded);
                    if (value != null && this.valueSerializer != null && !this.valueSerializer.equals(value, oldVal)) {
                        BTreeMap.unlock(this.nodeLocks, current);
                        return null;
                    }
                    if (this.valsOutsideNodes) {
                        long recid = ((ValRef)oldValNotExpanded).recid;
                        this.engine.update(recid, putNewValue, this.valueSerializer);
                    }
                    if (putNewValue == null || !this.valsOutsideNodes) {
                        A = putNewValue != null ? ((LeafNode)A).copyChangeValue(this.valueNodeSerializer, pos, putNewValue) : ((LeafNode)A).copyRemoveKey(this.keySerializer, this.valueNodeSerializer, pos);
                        this.engine.update(current, A, this.nodeSerializer);
                    }
                    if (this.nodeLocks.get(current) != Thread.currentThread()) {
                        throw new AssertionError();
                    }
                    this.notify(key, oldVal, putNewValue);
                    BTreeMap.unlock(this.nodeLocks, current);
                    this.notifyAfter(key, oldVal, putNewValue);
                    return oldVal;
                }
                if (pos <= 0 && -pos - 1 != A.keysLen(this.keySerializer) - 1) {
                    BTreeMap.unlock(this.nodeLocks, current);
                    return null;
                }
                old = current;
            } while ((current = A.next()) != 0L);
            BTreeMap.unlock(this.nodeLocks, old);
            return null;
        }
        catch (RuntimeException e) {
            BTreeMap.unlockAll(this.nodeLocks);
            throw e;
        }
        catch (Exception e) {
            BTreeMap.unlockAll(this.nodeLocks);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() {
        boolean hasListeners = this.modListeners.length > 0;
        long current = this.engine.get(this.rootRecidRef, Serializer.RECID);
        BNode A = this.engine.get(current, this.nodeSerializer);
        while (!A.isLeaf()) {
            current = A.child(0);
            A = this.engine.get(current, this.nodeSerializer);
        }
        long old = 0L;
        try {
            while (true) {
                BTreeMap.lock(this.nodeLocks, current);
                if (old != 0L) {
                    BTreeMap.unlock(this.nodeLocks, old);
                }
                int size = A.keysLen(this.keySerializer) - 1;
                if (hasListeners) {
                    for (int i = 1; i < size; ++i) {
                        Object val = A.val(i - 1, this.valueNodeSerializer);
                        val = this.valExpand(val);
                        this.notify(A.key(this.keySerializer, i), val, null);
                    }
                }
                A = ((LeafNode)A).copyClear(this.keySerializer, this.valueNodeSerializer);
                this.engine.update(current, A, this.nodeSerializer);
                old = current;
                current = A.next();
                if (current == 0L) {
                    BTreeMap.unlock(this.nodeLocks, old);
                    return;
                }
                A = this.engine.get(current, this.nodeSerializer);
            }
        }
        catch (RuntimeException e) {
            BTreeMap.unlockAll(this.nodeLocks);
            throw e;
        }
        catch (Exception e) {
            BTreeMap.unlockAll(this.nodeLocks);
            throw new RuntimeException(e);
        }
    }

    protected Map.Entry<K, V> makeEntry(Object key, Object value) {
        if (value instanceof ValRef) {
            throw new AssertionError();
        }
        return new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value);
    }

    @Override
    public boolean isEmpty() {
        return !this.keyIterator().hasNext();
    }

    @Override
    public int size() {
        return (int)Math.min(this.sizeLong(), Integer.MAX_VALUE);
    }

    @Override
    public long sizeLong() {
        if (this.counter != null) {
            return this.counter.get();
        }
        long size = 0L;
        BTreeIterator iter = new BTreeIterator(this);
        while (iter.hasNext()) {
            iter.advance();
            ++size;
        }
        return size;
    }

    public long mappingCount() {
        return this.sizeLong();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.put2(key, value, true);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        return value != null && this.removeOrReplace(key, value, null) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        return this.removeOrReplace(key, oldValue, newValue) != null;
    }

    @Override
    public V replace(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.removeOrReplace(key, null, value);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.keySerializer.comparator();
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        long rootRecid = this.engine.get(this.rootRecidRef, Serializer.RECID);
        BNode n = this.engine.get(rootRecid, this.nodeSerializer);
        while (!n.isLeaf()) {
            n = this.engine.get(n.child(0), this.nodeSerializer);
        }
        LeafNode l = (LeafNode)n;
        while (l.keysLen(this.keySerializer) == 2) {
            if (l.next == 0L) {
                return null;
            }
            l = (LeafNode)this.engine.get(l.next, this.nodeSerializer);
        }
        return this.makeEntry(l.key(this.keySerializer, 1), this.valExpand(l.val(0, this.valueNodeSerializer)));
    }

    @Override
    public K firstKey() {
        long rootRecid = this.engine.get(this.rootRecidRef, Serializer.RECID);
        BNode n = this.engine.get(rootRecid, this.nodeSerializer);
        while (!n.isLeaf()) {
            n = this.engine.get(n.child(0), this.nodeSerializer);
        }
        LeafNode l = (LeafNode)n;
        while (l.keysLen(this.keySerializer) == 2) {
            if (l.next == 0L) {
                throw new NoSuchElementException();
            }
            l = (LeafNode)this.engine.get(l.next, this.nodeSerializer);
        }
        return (K)l.key(this.keySerializer, 1);
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Map.Entry<K, V> e;
        while ((e = this.firstEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
        }
        return e;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Map.Entry<K, V> e;
        while ((e = this.lastEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
        }
        return e;
    }

    protected Map.Entry<K, V> findSmaller(K key, boolean inclusive) {
        if (key == null) {
            throw new NullPointerException();
        }
        long rootRecid = this.engine.get(this.rootRecidRef, Serializer.RECID);
        BNode n = this.engine.get(rootRecid, this.nodeSerializer);
        Map.Entry<K, V> k = this.findSmallerRecur(n, key, inclusive);
        if (k == null || k.getValue() == null) {
            return null;
        }
        return k;
    }

    private Map.Entry<K, V> findSmallerRecur(BNode n, K key, boolean inclusive) {
        boolean leaf = n.isLeaf();
        int start = leaf ? n.keysLen(this.keySerializer) - 2 : n.keysLen(this.keySerializer) - 1;
        int end = leaf ? 1 : 0;
        int res = inclusive && leaf ? 1 : 0;
        for (int i = start; i >= end; --i) {
            Map.Entry<K, V> ret;
            BNode n2;
            int comp;
            Object key2 = n.key(this.keySerializer, i);
            int n3 = comp = key2 == null ? -1 : this.keySerializer.comparator().compare(key2, key);
            if (comp >= res) continue;
            if (leaf) {
                return key2 == null ? null : this.makeEntry(key2, this.valExpand(n.val(i - 1, this.valueNodeSerializer)));
            }
            long recid = n.child(i);
            if (recid == 0L || (n2 = this.engine.get(recid, this.nodeSerializer)).isLeaf() && n2.keysLen(this.keySerializer) > 2 && this.keySerializer.comparator().compare(n2.key(this.keySerializer, 1), key) >= (inclusive ? 1 : 0) || (ret = this.findSmallerRecur(n2, key, inclusive)) == null) continue;
            return ret;
        }
        return null;
    }

    protected Fun.Pair<Integer, BNode> findSmallerNode(K key, boolean inclusive) {
        if (key == null) {
            throw new NullPointerException();
        }
        long rootRecid = this.engine.get(this.rootRecidRef, Serializer.RECID);
        BNode n = this.engine.get(rootRecid, this.nodeSerializer);
        return this.findSmallerNodeRecur(n, key, inclusive);
    }

    protected Fun.Pair<Integer, BNode> findSmallerNodeRecur(BNode n, K key, boolean inclusive) {
        boolean leaf = n.isLeaf();
        int start = leaf ? n.keysLen(this.keySerializer) - 2 : n.keysLen(this.keySerializer) - 1;
        int end = leaf ? 1 : 0;
        int res = inclusive && leaf ? 1 : 0;
        for (int i = start; i >= end; --i) {
            BNode n2;
            int comp;
            Object key2 = n.key(this.keySerializer, i);
            int n3 = comp = key2 == null ? -1 : this.keySerializer.comparator().compare(key2, key);
            if (comp >= res) continue;
            if (leaf) {
                return key2 == null ? null : new Fun.Pair<Integer, BNode>(i, n);
            }
            long recid = n.child(i);
            if (recid == 0L || (n2 = this.engine.get(recid, this.nodeSerializer)).isLeaf() && n2.keysLen(this.keySerializer) > 2 && this.keySerializer.comparator().compare(n2.key(this.keySerializer, 1), key) >= (inclusive ? 1 : 0)) continue;
            return this.findSmallerNodeRecur(n2, key, inclusive);
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        long rootRecid = this.engine.get(this.rootRecidRef, Serializer.RECID);
        BNode n = this.engine.get(rootRecid, this.nodeSerializer);
        Map.Entry<K, V> e = this.lastEntryRecur(n);
        if (e != null && e.getValue() == null) {
            return null;
        }
        return e;
    }

    private Map.Entry<K, V> lastEntryRecur(BNode n) {
        if (n.isLeaf()) {
            BNode n2;
            Map.Entry<K, V> ret;
            if (n.next() != 0L && (ret = this.lastEntryRecur(n2 = this.engine.get(n.next(), this.nodeSerializer))) != null) {
                return ret;
            }
            for (int i = n.keysLen(this.keySerializer) - 2; i > 0; --i) {
                V val;
                Object k = n.key(this.keySerializer, i);
                if (k == null || n.valSize(this.valueNodeSerializer) <= 0 || (val = this.valExpand(n.val(i - 1, this.valueNodeSerializer))) == null) continue;
                return this.makeEntry(k, val);
            }
        } else {
            for (int i = n.childArrayLength() - 1; i >= 0; --i) {
                BNode n2;
                Map.Entry<K, V> ret;
                long childRecid = n.child(i);
                if (childRecid == 0L || (ret = this.lastEntryRecur(n2 = this.engine.get(childRecid, this.nodeSerializer))) == null) continue;
                return ret;
            }
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.findSmaller(key, false);
    }

    @Override
    public K lowerKey(K key) {
        Map.Entry<K, V> n = this.lowerEntry(key);
        return n == null ? null : (K)n.getKey();
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.findSmaller(key, true);
    }

    @Override
    public K floorKey(K key) {
        Map.Entry<K, V> n = this.floorEntry(key);
        return n == null ? null : (K)n.getKey();
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.findLarger(key, true);
    }

    protected Map.Entry<K, V> findLarger(K key, boolean inclusive) {
        if (key == null) {
            return null;
        }
        long current = this.engine.get(this.rootRecidRef, Serializer.RECID);
        BNode A = this.engine.get(current, this.nodeSerializer);
        while (!A.isLeaf()) {
            current = this.nextDir((DirNode)A, key);
            A = this.engine.get(current, this.nodeSerializer);
        }
        LeafNode leaf = (LeafNode)A;
        int comp = inclusive ? 1 : 0;
        while (true) {
            for (int i = 1; i < leaf.keysLen(this.keySerializer) - 1; ++i) {
                if (leaf.key(this.keySerializer, i) == null || -leaf.compare(this.keySerializer, i, key) >= comp) continue;
                return this.makeEntry(leaf.key(this.keySerializer, i), this.valExpand(leaf.val(i - 1, this.valueNodeSerializer)));
            }
            if (leaf.next == 0L) {
                return null;
            }
            leaf = (LeafNode)this.engine.get(leaf.next, this.nodeSerializer);
        }
    }

    protected Fun.Pair<Integer, LeafNode> findLargerNode(K key, boolean inclusive) {
        if (key == null) {
            return null;
        }
        long current = this.engine.get(this.rootRecidRef, Serializer.RECID);
        BNode A = this.engine.get(current, this.nodeSerializer);
        while (!A.isLeaf()) {
            current = this.nextDir((DirNode)A, key);
            A = this.engine.get(current, this.nodeSerializer);
        }
        LeafNode leaf = (LeafNode)A;
        int comp = inclusive ? 1 : 0;
        while (true) {
            for (int i = 1; i < leaf.keysLen(this.keySerializer) - 1; ++i) {
                if (leaf.key(this.keySerializer, i) == null || -leaf.compare(this.keySerializer, i, key) >= comp) continue;
                return new Fun.Pair<Integer, LeafNode>(i, leaf);
            }
            if (leaf.next == 0L) {
                return null;
            }
            leaf = (LeafNode)this.engine.get(leaf.next, this.nodeSerializer);
        }
    }

    @Override
    public K ceilingKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map.Entry<K, V> n = this.ceilingEntry(key);
        return n == null ? null : (K)n.getKey();
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.findLarger(key, false);
    }

    @Override
    public K higherKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map.Entry<K, V> n = this.higherEntry(key);
        return n == null ? null : (K)n.getKey();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.get(key, false) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Iterator<V> valueIter = this.valueIterator();
        while (valueIter.hasNext()) {
            if (!this.valueSerializer.equals(value, valueIter.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public K lastKey() {
        Map.Entry<K, V> e = this.lastEntry();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.getKey();
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        if (fromKey == null || toKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        if (toKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, null, false, toKey, inclusive);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        if (fromKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, fromKey, inclusive, null, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap((Object)fromKey, true, (Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey) {
        return this.headMap((Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey) {
        return this.tailMap((Object)fromKey, true);
    }

    Iterator<K> keyIterator() {
        return new BTreeKeyIterator(this);
    }

    Iterator<V> valueIterator() {
        return new BTreeValueIterator(this, null, false, null, false);
    }

    Iterator<Map.Entry<K, V>> entryIterator() {
        return new BTreeEntryIterator(this);
    }

    @Override
    public NavigableSet<K> keySet() {
        return this.keySet;
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public ConcurrentNavigableMap<K, V> descendingMap() {
        return this.descendingMap;
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap.keySet();
    }

    static <E> List<E> toList(Collection<E> c) {
        ArrayList<E> list = new ArrayList<E>();
        for (E e : c) {
            list.add(e);
        }
        return list;
    }

    public NavigableMap<K, V> snapshot() {
        Engine snapshot = TxEngine.createSnapshotFor(this.engine);
        return new BTreeMap<K, V>(snapshot, this.closeEngine, this.rootRecidRef, this.maxNodeSize, this.valsOutsideNodes, this.counter == null ? 0L : this.counter.recid, this.keySerializer, this.valueSerializer, this.numberOfNodeMetas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modificationListenerAdd(Bind.MapListener<K, V> listener) {
        Object object = this.modListenersLock;
        synchronized (object) {
            Bind.MapListener<K, V>[] modListeners2 = Arrays.copyOf(this.modListeners, this.modListeners.length + 1);
            modListeners2[modListeners2.length - 1] = listener;
            this.modListeners = modListeners2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modificationListenerRemove(Bind.MapListener<K, V> listener) {
        Object object = this.modListenersLock;
        synchronized (object) {
            for (int i = 0; i < this.modListeners.length; ++i) {
                if (this.modListeners[i] != listener) continue;
                this.modListeners[i] = null;
            }
        }
    }

    protected void notify(K key, V oldValue, V newValue) {
        Bind.MapListener<K, V>[] modListeners2;
        if (oldValue instanceof ValRef) {
            throw new AssertionError();
        }
        if (newValue instanceof ValRef) {
            throw new AssertionError();
        }
        for (Bind.MapListener<K, V> listener : modListeners2 = this.modListeners) {
            if (listener == null) continue;
            listener.update(key, oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modificationListenerAfterAdd(Bind.MapListener<K, V> listener) {
        Object object = this.modAfterListenersLock;
        synchronized (object) {
            Bind.MapListener<K, V>[] modListeners2 = Arrays.copyOf(this.modAfterListeners, this.modAfterListeners.length + 1);
            modListeners2[modListeners2.length - 1] = listener;
            this.modAfterListeners = modListeners2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modificationListenerAfterRemove(Bind.MapListener<K, V> listener) {
        Object object = this.modAfterListenersLock;
        synchronized (object) {
            for (int i = 0; i < this.modAfterListeners.length; ++i) {
                if (this.modAfterListeners[i] != listener) continue;
                this.modAfterListeners[i] = null;
            }
        }
    }

    protected void notifyAfter(K key, V oldValue, V newValue) {
        Bind.MapListener<K, V>[] modListeners2;
        if (oldValue instanceof ValRef) {
            throw new AssertionError();
        }
        if (newValue instanceof ValRef) {
            throw new AssertionError();
        }
        for (Bind.MapListener<K, V> listener : modListeners2 = this.modAfterListeners) {
            if (listener == null) continue;
            listener.update(key, oldValue, newValue);
        }
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void printTreeStructure() {
        long rootRecid = this.engine.get(this.rootRecidRef, Serializer.RECID);
        BTreeMap.printRecur(this, rootRecid, "");
    }

    private static void printRecur(BTreeMap m, long recid, String s) {
        BNode n = m.engine.get(recid, m.nodeSerializer);
        System.out.println(s + recid + "-" + n);
        if (!n.isLeaf()) {
            int childArrayLen = n.childArrayLength() - 1;
            for (int i = 0; i < childArrayLen; ++i) {
                long recid2 = n.child(i);
                if (recid2 == 0L) continue;
                BTreeMap.printRecur(m, recid2, s + "  ");
            }
        }
    }

    protected static Object[] arrayPut(Object[] array, int pos, Object value) {
        Object[] ret = Arrays.copyOf(array, array.length + 1);
        if (pos < array.length) {
            System.arraycopy(array, pos, ret, pos + 1, array.length - pos);
        }
        ret[pos] = value;
        return ret;
    }

    protected static void assertNoLocks(LongConcurrentHashMap<Thread> locks) {
        LongConcurrentHashMap.LongMapIterator<Thread> i = locks.longMapIterator();
        Thread t = null;
        while (i.moveToNext()) {
            if (t == null) {
                t = Thread.currentThread();
            }
            if (i.value() == t) {
                throw new AssertionError((Object)("Node " + i.key() + " is still locked"));
            }
        }
    }

    protected static void unlock(LongConcurrentHashMap<Thread> locks, long recid) {
        Thread t = locks.remove(recid);
        if (t != Thread.currentThread()) {
            throw new AssertionError((Object)"unlocked wrong thread");
        }
    }

    protected static void unlockAll(LongConcurrentHashMap<Thread> locks) {
        Thread t = Thread.currentThread();
        LongConcurrentHashMap.LongMapIterator<Thread> iter = locks.longMapIterator();
        while (iter.moveToNext()) {
            if (iter.value() != t) continue;
            iter.remove();
        }
    }

    protected static void lock(LongConcurrentHashMap<Thread> locks, long recid) {
        Thread currentThread = Thread.currentThread();
        if (locks.get(recid) == currentThread) {
            throw new AssertionError((Object)("node already locked by current thread: " + recid));
        }
        while (locks.putIfAbsent(recid, currentThread) != null) {
            LockSupport.parkNanos(10L);
        }
    }

    public void checkStructure() {
        Store.LongObjectMap recids = new Store.LongObjectMap();
        long recid = this.engine.get(this.rootRecidRef, Serializer.RECID);
        this.checkNodeRecur(recid, recids);
    }

    private void checkNodeRecur(long rootRecid, Store.LongObjectMap recids) {
        BNode n = this.engine.get(rootRecid, this.nodeSerializer);
        n.checkStructure(this.keySerializer, this.valueNodeSerializer);
        if (recids.get(rootRecid) != null) {
            throw new DBException.DataCorruption("Duplicate recid: " + rootRecid);
        }
        recids.put(rootRecid, this);
        if (n.next() != 0L && recids.get(n.next()) == null) {
            throw new DBException.DataCorruption("Next link was not found: " + n);
        }
        if (n.next() == rootRecid) {
            throw new DBException.DataCorruption("Recursive next: " + n);
        }
        if (!n.isLeaf()) {
            for (int i = n.childArrayLength() - 1; i >= 0; --i) {
                long recid = n.child(i);
                if (recid == rootRecid) {
                    throw new DBException.DataCorruption("Recursive recid: " + n);
                }
                if (recid == 0L || recid == n.next()) continue;
                this.checkNodeRecur(recid, recids);
            }
        }
    }

    @Override
    public void close() {
        if (this.closeEngine) {
            this.engine.close();
        }
    }

    void compactLevel(int level) {
        int k = this.maxNodeSize * 3 / 4;
        long current = this.leftEdges.get(level + 1);
        long one = 0L;
        while (current != 0L) {
            BTreeMap.lock(this.nodeLocks, current);
            BNode F = this.engine.get(current, this.nodeSerializer);
            int pos = F.childIndexOf(one);
            long olddone = one;
            if (one == 0L || pos > -1 && F.keysLen(this.keySerializer) > pos) {
                one = one == 0L ? F.child(0) : F.child(pos + 1);
                BTreeMap.lock(this.nodeLocks, one);
                BNode A = this.engine.get(one, this.nodeSerializer);
                long two = A.next();
                if (two == 0L) {
                    return;
                }
                BTreeMap.lock(this.nodeLocks, two);
                BNode B = this.engine.get(two, this.nodeSerializer);
                if (F.childIndexOf(two) > -1) {
                    if (k <= A.keysLen(this.keySerializer) && k <= B.keysLen(this.keySerializer)) continue;
                    this.engine.update(one, A, this.nodeSerializer);
                    BTreeMap.unlock(this.nodeLocks, one);
                    this.engine.update(current, F, this.nodeSerializer);
                    BTreeMap.unlock(this.nodeLocks, current);
                    this.engine.update(two, B, this.nodeSerializer);
                    BTreeMap.unlock(this.nodeLocks, two);
                    continue;
                }
                BTreeMap.unlock(this.nodeLocks, current);
                BTreeMap.unlock(this.nodeLocks, one);
                BTreeMap.unlock(this.nodeLocks, two);
                if (this.keySerializer.comparator().compare(B.highKey(this.keySerializer), F.highKey(this.keySerializer)) > 0) {
                    current = F.next();
                    one = 0L;
                    continue;
                }
                if (k <= A.keysLen(this.keySerializer) && k <= B.keysLen(this.keySerializer)) continue;
                one = olddone;
                continue;
            }
            BTreeMap.unlock(this.nodeLocks, current);
            current = F.next();
            one = 0L;
        }
    }

    Object writeReplace() throws ObjectStreamException {
        ConcurrentSkipListMap<K, V> ret = new ConcurrentSkipListMap<K, V>();
        for (Map.Entry<K, V> e : this.entrySet()) {
            ret.put(e.getKey(), e.getValue());
        }
        return ret;
    }

    protected static class DescendingMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentNavigableMap<K, V> {
        protected final BTreeMap<K, V> m;
        protected final K lo;
        protected final boolean loInclusive;
        protected final K hi;
        protected final boolean hiInclusive;

        public DescendingMap(BTreeMap<K, V> m, K lo, boolean loInclusive, K hi, boolean hiInclusive) {
            this.m = m;
            this.lo = lo;
            this.loInclusive = loInclusive;
            this.hi = hi;
            this.hiInclusive = hiInclusive;
            if (lo != null && hi != null && m.keySerializer.comparator().compare(lo, hi) > 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return this.inBounds(k) && this.m.containsKey(k);
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.get(k);
        }

        @Override
        public V put(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.put(key, value);
        }

        @Override
        public V remove(Object key) {
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.remove(k);
        }

        @Override
        public int size() {
            if (this.hi == null && this.lo == null) {
                return this.m.size();
            }
            Iterator<K> i = this.keyIterator();
            long counter = 0L;
            while (i.hasNext()) {
                ++counter;
                i.next();
            }
            return (int)Math.min(counter, Integer.MAX_VALUE);
        }

        @Override
        public boolean isEmpty() {
            return !this.keyIterator().hasNext();
        }

        @Override
        public boolean containsValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Iterator<V> i = this.valueIterator();
            while (i.hasNext()) {
                if (!this.m.valueSerializer.equals(value, i.next())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            Iterator<K> i = this.keyIterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            Object k = key;
            return this.inBounds(k) && this.m.remove(k, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            this.checkKeyBounds(key);
            return this.m.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.replace(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.firstEntry();
            }
            Map.Entry<K, V> r = this.m.lowerEntry(key);
            return r != null && !this.tooLow(r.getKey()) ? r : null;
        }

        @Override
        public K lowerKey(K key) {
            Map.Entry<K, V> n = this.lowerEntry(key);
            return n == null ? null : (K)n.getKey();
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.firstEntry();
            }
            Map.Entry<K, V> ret = this.m.floorEntry(key);
            if (ret != null && this.tooLow(ret.getKey())) {
                return null;
            }
            return ret;
        }

        @Override
        public K floorKey(K key) {
            Map.Entry<K, V> n = this.floorEntry(key);
            return n == null ? null : (K)n.getKey();
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooHigh(key)) {
                return null;
            }
            if (this.tooLow(key)) {
                return this.lastEntry();
            }
            Map.Entry<K, V> ret = this.m.ceilingEntry(key);
            if (ret != null && this.tooHigh(ret.getKey())) {
                return null;
            }
            return ret;
        }

        @Override
        public K ceilingKey(K key) {
            Map.Entry<K, V> k = this.ceilingEntry(key);
            return k != null ? (K)k.getKey() : null;
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            Map.Entry<K, V> r = this.m.higherEntry(key);
            return r != null && this.inBounds(r.getKey()) ? r : null;
        }

        @Override
        public K higherKey(K key) {
            Map.Entry<K, V> k = this.higherEntry(key);
            return k != null ? (K)k.getKey() : null;
        }

        @Override
        public K firstKey() {
            Map.Entry<K, V> e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        @Override
        public K lastKey() {
            Map.Entry<K, V> e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            Map.Entry<K, V> k = this.lo == null ? this.m.firstEntry() : this.m.findLarger(this.lo, this.loInclusive);
            return k != null && this.inBounds(k.getKey()) ? k : null;
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Map.Entry<K, V> k = this.hi == null ? this.m.lastEntry() : this.m.findSmaller(this.hi, this.hiInclusive);
            return k != null && this.inBounds(k.getKey()) ? k : null;
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Map.Entry<K, V> e;
            while ((e = this.firstEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
            }
            return e;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Map.Entry<K, V> e;
            while ((e = this.lastEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
            }
            return e;
        }

        private DescendingMap<K, V> newSubMap(K toKey, boolean toInclusive, K fromKey, boolean fromInclusive) {
            int c;
            if (this.lo != null) {
                if (fromKey == null) {
                    fromKey = this.lo;
                    fromInclusive = this.loInclusive;
                } else {
                    c = this.m.keySerializer.comparator().compare(fromKey, this.lo);
                    if (c < 0 || c == 0 && !this.loInclusive && fromInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            if (this.hi != null) {
                if (toKey == null) {
                    toKey = this.hi;
                    toInclusive = this.hiInclusive;
                } else {
                    c = this.m.keySerializer.comparator().compare(toKey, this.hi);
                    if (c > 0 || c == 0 && !this.hiInclusive && toInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            return new DescendingMap<K, V>(this.m, fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public DescendingMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (fromKey == null || toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public DescendingMap<K, V> headMap(K toKey, boolean inclusive) {
            if (toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(null, false, toKey, inclusive);
        }

        @Override
        public DescendingMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (fromKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, inclusive, null, false);
        }

        @Override
        public DescendingMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap((Object)fromKey, true, (Object)toKey, false);
        }

        @Override
        public DescendingMap<K, V> headMap(K toKey) {
            return this.headMap((Object)toKey, false);
        }

        @Override
        public DescendingMap<K, V> tailMap(K fromKey) {
            return this.tailMap((Object)fromKey, true);
        }

        @Override
        public ConcurrentNavigableMap<K, V> descendingMap() {
            if (this.lo == null && this.hi == null) {
                return this.m;
            }
            return this.m.subMap((Object)this.lo, this.loInclusive, (Object)this.hi, this.hiInclusive);
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return new KeySet(this, this.m.hasValues);
        }

        private boolean tooLow(K key) {
            int c;
            return this.lo != null && ((c = this.m.keySerializer.comparator().compare(key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        private boolean tooHigh(K key) {
            int c;
            return this.hi != null && ((c = this.m.keySerializer.comparator().compare(key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        private boolean inBounds(K key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        private void checkKeyBounds(K key) throws IllegalArgumentException {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.inBounds(key)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        @Override
        public NavigableSet<K> keySet() {
            return new KeySet(this, this.m.hasValues);
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return new KeySet(this.descendingMap(), this.m.hasValues);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet(this, this.m.valueSerializer);
        }

        Iterator<K> keyIterator() {
            return new BTreeDescendingKeyIterator(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }

        Iterator<V> valueIterator() {
            return new BTreeDescendingValueIterator(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }

        Iterator<Map.Entry<K, V>> entryIterator() {
            return new BTreeDescendingEntryIterator(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }
    }

    protected static class SubMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentNavigableMap<K, V> {
        protected final BTreeMap<K, V> m;
        protected final K lo;
        protected final boolean loInclusive;
        protected final K hi;
        protected final boolean hiInclusive;

        public SubMap(BTreeMap<K, V> m, K lo, boolean loInclusive, K hi, boolean hiInclusive) {
            this.m = m;
            this.lo = lo;
            this.loInclusive = loInclusive;
            this.hi = hi;
            this.hiInclusive = hiInclusive;
            if (lo != null && hi != null && m.keySerializer.comparator().compare(lo, hi) > 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return this.inBounds(k) && this.m.containsKey(k);
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.get(k);
        }

        @Override
        public V put(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.put(key, value);
        }

        @Override
        public V remove(Object key) {
            if (key == null) {
                throw new NullPointerException("key null");
            }
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.remove(k);
        }

        @Override
        public int size() {
            return (int)Math.min(this.sizeLong(), Integer.MAX_VALUE);
        }

        public long sizeLong() {
            if (this.hi == null && this.lo == null) {
                return this.m.sizeLong();
            }
            Iterator<K> i = this.keyIterator();
            long counter = 0L;
            while (i.hasNext()) {
                ++counter;
                i.next();
            }
            return counter;
        }

        @Override
        public boolean isEmpty() {
            return !this.keyIterator().hasNext();
        }

        @Override
        public boolean containsValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Iterator<V> i = this.valueIterator();
            while (i.hasNext()) {
                if (!this.m.valueSerializer.equals(value, i.next())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            Iterator<K> i = this.keyIterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            Object k = key;
            return this.inBounds(k) && this.m.remove(k, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            this.checkKeyBounds(key);
            return this.m.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.replace(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.lastEntry();
            }
            Map.Entry<K, V> r = this.m.lowerEntry(key);
            return r != null && !this.tooLow(r.getKey()) ? r : null;
        }

        @Override
        public K lowerKey(K key) {
            Map.Entry<K, V> n = this.lowerEntry(key);
            return n == null ? null : (K)n.getKey();
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.lastEntry();
            }
            Map.Entry<K, V> ret = this.m.floorEntry(key);
            if (ret != null && this.tooLow(ret.getKey())) {
                return null;
            }
            return ret;
        }

        @Override
        public K floorKey(K key) {
            Map.Entry<K, V> n = this.floorEntry(key);
            return n == null ? null : (K)n.getKey();
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooHigh(key)) {
                return null;
            }
            if (this.tooLow(key)) {
                return this.firstEntry();
            }
            Map.Entry<K, V> ret = this.m.ceilingEntry(key);
            if (ret != null && this.tooHigh(ret.getKey())) {
                return null;
            }
            return ret;
        }

        @Override
        public K ceilingKey(K key) {
            Map.Entry<K, V> k = this.ceilingEntry(key);
            return k != null ? (K)k.getKey() : null;
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            Map.Entry<K, V> r = this.m.higherEntry(key);
            return r != null && this.inBounds(r.getKey()) ? r : null;
        }

        @Override
        public K higherKey(K key) {
            Map.Entry<K, V> k = this.higherEntry(key);
            return k != null ? (K)k.getKey() : null;
        }

        @Override
        public K firstKey() {
            Map.Entry<K, V> e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        @Override
        public K lastKey() {
            Map.Entry<K, V> e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Map.Entry<K, V> k = this.lo == null ? this.m.firstEntry() : this.m.findLarger(this.lo, this.loInclusive);
            return k != null && this.inBounds(k.getKey()) ? k : null;
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            Map.Entry<K, V> k = this.hi == null ? this.m.lastEntry() : this.m.findSmaller(this.hi, this.hiInclusive);
            return k != null && this.inBounds(k.getKey()) ? k : null;
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Map.Entry<K, V> e;
            while ((e = this.firstEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
            }
            return e;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Map.Entry<K, V> e;
            while ((e = this.lastEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
            }
            return e;
        }

        private SubMap<K, V> newSubMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            int c;
            if (this.lo != null) {
                if (fromKey == null) {
                    fromKey = this.lo;
                    fromInclusive = this.loInclusive;
                } else {
                    c = this.m.keySerializer.comparator().compare(fromKey, this.lo);
                    if (c < 0 || c == 0 && !this.loInclusive && fromInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            if (this.hi != null) {
                if (toKey == null) {
                    toKey = this.hi;
                    toInclusive = this.hiInclusive;
                } else {
                    c = this.m.keySerializer.comparator().compare(toKey, this.hi);
                    if (c > 0 || c == 0 && !this.hiInclusive && toInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            return new SubMap<K, V>(this.m, fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public SubMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (fromKey == null || toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public SubMap<K, V> headMap(K toKey, boolean inclusive) {
            if (toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(null, false, toKey, inclusive);
        }

        @Override
        public SubMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (fromKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, inclusive, null, false);
        }

        @Override
        public SubMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap((Object)fromKey, true, (Object)toKey, false);
        }

        @Override
        public SubMap<K, V> headMap(K toKey) {
            return this.headMap((Object)toKey, false);
        }

        @Override
        public SubMap<K, V> tailMap(K fromKey) {
            return this.tailMap((Object)fromKey, true);
        }

        @Override
        public ConcurrentNavigableMap<K, V> descendingMap() {
            return new DescendingMap<K, V>(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return new KeySet(this, this.m.hasValues);
        }

        private boolean tooLow(K key) {
            int c;
            return this.lo != null && ((c = this.m.keySerializer.comparator().compare(key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        private boolean tooHigh(K key) {
            int c;
            return this.hi != null && ((c = this.m.keySerializer.comparator().compare(key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        private boolean inBounds(K key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        private void checkKeyBounds(K key) throws IllegalArgumentException {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.inBounds(key)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        @Override
        public NavigableSet<K> keySet() {
            return new KeySet(this, this.m.hasValues);
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return new DescendingMap<K, V>(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive).keySet();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet(this, this.m.valueSerializer);
        }

        Iterator<K> keyIterator() {
            return new BTreeKeyIterator(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }

        Iterator<V> valueIterator() {
            return new BTreeValueIterator(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }

        Iterator<Map.Entry<K, V>> entryIterator() {
            return new BTreeEntryIterator(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }
    }

    static final class EntrySet<K1, V1>
    extends AbstractSet<Map.Entry<K1, V1>> {
        private final ConcurrentNavigableMap<K1, V1> m;
        private final Serializer valueSerializer;

        EntrySet(ConcurrentNavigableMap<K1, V1> map, Serializer valueSerializer) {
            this.m = map;
            this.valueSerializer = valueSerializer;
        }

        @Override
        public Iterator<Map.Entry<K1, V1>> iterator() {
            if (this.m instanceof BTreeMap) {
                return ((BTreeMap)this.m).entryIterator();
            }
            if (this.m instanceof SubMap) {
                return ((SubMap)this.m).entryIterator();
            }
            return ((DescendingMap)this.m).entryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            Object v = this.m.get(key);
            return v != null && this.valueSerializer.equals(v, e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            return this.m.remove(key, e.getValue());
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            try {
                return this.containsAll(c) && c.containsAll(this);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return BTreeMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return BTreeMap.toList(this).toArray(a);
        }
    }

    static final class Values<E>
    extends AbstractCollection<E> {
        private final ConcurrentNavigableMap<Object, E> m;

        Values(ConcurrentNavigableMap<Object, E> map) {
            this.m = map;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof BTreeMap) {
                return ((BTreeMap)this.m).valueIterator();
            }
            return ((SubMap)this.m).valueIterator();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsValue(o);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Object[] toArray() {
            return BTreeMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return BTreeMap.toList(this).toArray(a);
        }
    }

    public static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E>,
    Closeable,
    Serializable {
        protected final ConcurrentNavigableMap<E, Object> m;
        private final boolean hasValues;

        KeySet(ConcurrentNavigableMap<E, Object> map, boolean hasValues) {
            this.m = map;
            this.hasValues = hasValues;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        public long sizeLong() {
            if (this.m instanceof BTreeMap) {
                return ((BTreeMap)this.m).sizeLong();
            }
            return ((SubMap)this.m).sizeLong();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.m.remove(o) != null;
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public E lower(E e) {
            return this.m.lowerKey(e);
        }

        @Override
        public E floor(E e) {
            return this.m.floorKey(e);
        }

        @Override
        public E ceiling(E e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public E higher(E e) {
            return this.m.higherKey(e);
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public E pollFirst() {
            Map.Entry e = this.m.pollFirstEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry e = this.m.pollLastEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof BTreeMap) {
                return ((BTreeMap)this.m).keyIterator();
            }
            if (this.m instanceof SubMap) {
                return ((SubMap)this.m).keyIterator();
            }
            return ((DescendingMap)this.m).keyIterator();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            try {
                return this.containsAll(c) && c.containsAll(this);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return BTreeMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return BTreeMap.toList(this).toArray(a);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return new KeySet<E>(this.m.subMap((Object)fromElement, fromInclusive, (Object)toElement, toInclusive), this.hasValues);
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            return new KeySet<E>(this.m.headMap((Object)toElement, inclusive), this.hasValues);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            return new KeySet<E>(this.m.tailMap((Object)fromElement, inclusive), this.hasValues);
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, E toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public NavigableSet<E> headSet(E toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement) {
            return this.tailSet(fromElement, true);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new KeySet<E>(this.m.descendingMap(), this.hasValues);
        }

        @Override
        public boolean add(E k) {
            if (this.hasValues) {
                throw new UnsupportedOperationException();
            }
            return this.m.put(k, Boolean.TRUE) == null;
        }

        @Override
        public void close() {
            if (this.m instanceof BTreeMap) {
                ((BTreeMap)this.m).close();
            }
        }

        Object writeReplace() throws ObjectStreamException {
            ConcurrentSkipListSet<E> ret = new ConcurrentSkipListSet<E>();
            for (E e : this) {
                ret.add(e);
            }
            return ret;
        }
    }

    static class BTreeDescendingEntryIterator<K, V>
    extends BTreeDescendingIterator
    implements Iterator<Map.Entry<K, V>> {
        BTreeDescendingEntryIterator(BTreeMap m, Object lo, boolean loInclusive, Object hi, boolean hiInclusive) {
            super(m, lo, loInclusive, hi, hiInclusive);
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.currentLeaf == null) {
                throw new NoSuchElementException();
            }
            Object ret = this.currentLeaf.key(this.m.keySerializer, this.currentPos);
            Object val = this.currentLeaf.val(this.currentPos - 1, this.m.valueNodeSerializer);
            this.advance();
            return this.m.makeEntry(ret, this.m.valExpand(val));
        }
    }

    static class BTreeDescendingValueIterator<V>
    extends BTreeDescendingIterator
    implements Iterator<V> {
        BTreeDescendingValueIterator(BTreeMap m, Object lo, boolean loInclusive, Object hi, boolean hiInclusive) {
            super(m, lo, loInclusive, hi, hiInclusive);
        }

        @Override
        public V next() {
            if (this.currentLeaf == null) {
                throw new NoSuchElementException();
            }
            Object ret = this.currentLeaf.val(this.currentPos - 1, this.m.valueNodeSerializer);
            this.advance();
            return this.m.valExpand(ret);
        }
    }

    static class BTreeDescendingKeyIterator<K>
    extends BTreeDescendingIterator
    implements Iterator<K> {
        BTreeDescendingKeyIterator(BTreeMap m, Object lo, boolean loInclusive, Object hi, boolean hiInclusive) {
            super(m, lo, loInclusive, hi, hiInclusive);
        }

        @Override
        public K next() {
            if (this.currentLeaf == null) {
                throw new NoSuchElementException();
            }
            Object ret = this.currentLeaf.key(this.m.keySerializer, this.currentPos);
            this.advance();
            return (K)ret;
        }
    }

    static class BTreeEntryIterator<K, V>
    extends BTreeIterator
    implements Iterator<Map.Entry<K, V>> {
        BTreeEntryIterator(BTreeMap m) {
            super(m);
        }

        BTreeEntryIterator(BTreeMap m, Object lo, boolean loInclusive, Object hi, boolean hiInclusive) {
            super(m, lo, loInclusive, hi, hiInclusive);
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.currentLeaf == null) {
                throw new NoSuchElementException();
            }
            Object ret = this.currentLeaf.key(this.m.keySerializer, this.currentPos);
            Object val = this.currentLeaf.val(this.currentPos - 1, this.m.valueNodeSerializer);
            this.advance();
            return this.m.makeEntry(ret, this.m.valExpand(val));
        }
    }

    static class BTreeValueIterator<V>
    extends BTreeIterator
    implements Iterator<V> {
        BTreeValueIterator(BTreeMap m, Object lo, boolean loInclusive, Object hi, boolean hiInclusive) {
            super(m, lo, loInclusive, hi, hiInclusive);
        }

        @Override
        public V next() {
            if (this.currentLeaf == null) {
                throw new NoSuchElementException();
            }
            Object ret = this.currentLeaf.val(this.currentPos - 1, this.m.valueNodeSerializer);
            this.advance();
            return this.m.valExpand(ret);
        }
    }

    static class BTreeKeyIterator<K>
    extends BTreeIterator
    implements Iterator<K> {
        BTreeKeyIterator(BTreeMap m) {
            super(m);
        }

        BTreeKeyIterator(BTreeMap m, Object lo, boolean loInclusive, Object hi, boolean hiInclusive) {
            super(m, lo, loInclusive, hi, hiInclusive);
        }

        @Override
        public K next() {
            if (this.currentLeaf == null) {
                throw new NoSuchElementException();
            }
            Object ret = this.currentLeaf.key(this.m.keySerializer, this.currentPos);
            this.advance();
            return (K)ret;
        }
    }

    protected static class BTreeDescendingIterator {
        final BTreeMap m;
        LeafNode currentLeaf;
        Object lastReturnedKey;
        int currentPos;
        final Object lo;
        final boolean loInclusive;

        BTreeDescendingIterator(BTreeMap m) {
            this.m = m;
            this.lo = null;
            this.loInclusive = false;
            this.pointToStart();
        }

        BTreeDescendingIterator(BTreeMap m, Object lo, boolean loInclusive, Object hi, boolean hiInclusive) {
            int c;
            this.m = m;
            if (hi == null) {
                this.pointToStart();
            } else {
                Fun.Pair<Integer, BNode> l = m.findSmallerNode(hi, hiInclusive);
                this.currentPos = l != null ? (Integer)l.a : -1;
                this.currentLeaf = l != null ? (LeafNode)l.b : null;
            }
            this.lo = lo;
            this.loInclusive = loInclusive;
            if (lo != null && this.currentLeaf != null && ((c = -this.currentLeaf.compare(m.keySerializer, this.currentPos, lo)) > 0 || c == 0 && !loInclusive)) {
                this.currentLeaf = null;
                this.currentPos = -1;
            }
        }

        private void pointToStart() {
            long rootRecid = this.m.engine.get(this.m.rootRecidRef, Serializer.RECID);
            BNode node = this.m.engine.get(rootRecid, this.m.nodeSerializer);
            while (true) {
                long next;
                if ((next = node.next()) == 0L) {
                    if (node.isLeaf()) {
                        this.currentLeaf = (LeafNode)node;
                        int len = this.currentLeaf.keysLen(this.m.keySerializer);
                        if (len == 2) {
                            this.currentLeaf = null;
                            this.currentPos = -1;
                        } else {
                            this.currentPos = len - 2;
                        }
                        return;
                    }
                    Object children = node.childArray();
                    next = children instanceof int[] ? (long)((int[])children)[((int[])children).length - 2] : ((long[])children)[((long[])children).length - 2];
                }
                node = this.m.engine.get(next, this.m.nodeSerializer);
            }
        }

        public boolean hasNext() {
            return this.currentLeaf != null;
        }

        public void remove() {
            if (this.lastReturnedKey == null) {
                throw new IllegalStateException();
            }
            this.m.remove(this.lastReturnedKey);
            this.lastReturnedKey = null;
        }

        protected void advance() {
            int c;
            if (this.currentLeaf == null) {
                return;
            }
            this.lastReturnedKey = this.currentLeaf.key(this.m.keySerializer, this.currentPos);
            --this.currentPos;
            if (this.currentPos == 0) {
                Fun.Pair<Integer, BNode> prevPair;
                Object nextKey = this.currentLeaf.key(this.m.keySerializer, 0);
                Fun.Pair<Integer, BNode> pair = prevPair = nextKey == null ? null : this.m.findSmallerNode(nextKey, false);
                if (prevPair == null) {
                    this.currentLeaf = null;
                    this.currentPos = -1;
                    return;
                }
                this.currentLeaf = (LeafNode)prevPair.b;
                this.currentPos = this.currentLeaf.keysLen(this.m.keySerializer) - 2;
                while (this.currentLeaf.keysLen(this.m.keySerializer) == 2) {
                    if (this.currentLeaf.next == 0L) {
                        this.currentLeaf = null;
                        this.currentPos = -1;
                        return;
                    }
                    this.currentLeaf = (LeafNode)this.m.engine.get(this.currentLeaf.next, this.m.nodeSerializer);
                }
            }
            if (this.lo != null && this.currentLeaf != null && ((c = -this.currentLeaf.compare(this.m.keySerializer, this.currentPos, this.lo)) > 0 || c == 0 && !this.loInclusive)) {
                this.currentLeaf = null;
                this.currentPos = -1;
            }
        }
    }

    protected static class BTreeIterator {
        final BTreeMap m;
        LeafNode currentLeaf;
        Object lastReturnedKey;
        int currentPos;
        final Object hi;
        final boolean hiInclusive;

        BTreeIterator(BTreeMap m) {
            this.m = m;
            this.hi = null;
            this.hiInclusive = false;
            this.pointToStart();
        }

        BTreeIterator(BTreeMap m, Object lo, boolean loInclusive, Object hi, boolean hiInclusive) {
            int c;
            this.m = m;
            if (lo == null) {
                this.pointToStart();
            } else {
                Fun.Pair<Integer, LeafNode> l = m.findLargerNode(lo, loInclusive);
                this.currentPos = l != null ? (Integer)l.a : -1;
                this.currentLeaf = l != null ? (LeafNode)l.b : null;
            }
            this.hi = hi;
            this.hiInclusive = hiInclusive;
            if (hi != null && this.currentLeaf != null && ((c = this.currentLeaf.compare(m.keySerializer, this.currentPos, hi)) > 0 || c == 0 && !hiInclusive)) {
                this.currentLeaf = null;
                this.currentPos = -1;
            }
        }

        private void pointToStart() {
            long rootRecid = this.m.engine.get(this.m.rootRecidRef, Serializer.RECID);
            BNode node = this.m.engine.get(rootRecid, this.m.nodeSerializer);
            while (!node.isLeaf()) {
                node = this.m.engine.get(node.child(0), this.m.nodeSerializer);
            }
            this.currentLeaf = (LeafNode)node;
            this.currentPos = 1;
            while (this.currentLeaf.keysLen(this.m.keySerializer) == 2) {
                if (this.currentLeaf.next == 0L) {
                    this.currentLeaf = null;
                    return;
                }
                this.currentLeaf = (LeafNode)this.m.engine.get(this.currentLeaf.next, this.m.nodeSerializer);
            }
        }

        public boolean hasNext() {
            return this.currentLeaf != null;
        }

        public void remove() {
            if (this.lastReturnedKey == null) {
                throw new IllegalStateException();
            }
            this.m.remove(this.lastReturnedKey);
            this.lastReturnedKey = null;
        }

        protected void advance() {
            int c;
            if (this.currentLeaf == null) {
                return;
            }
            this.lastReturnedKey = this.currentLeaf.key(this.m.keySerializer, this.currentPos);
            ++this.currentPos;
            if (this.currentPos == this.currentLeaf.keysLen(this.m.keySerializer) - 1) {
                if (this.currentLeaf.next == 0L) {
                    this.currentLeaf = null;
                    this.currentPos = -1;
                    return;
                }
                this.currentPos = 1;
                this.currentLeaf = (LeafNode)this.m.engine.get(this.currentLeaf.next, this.m.nodeSerializer);
                while (this.currentLeaf.keysLen(this.m.keySerializer) == 2) {
                    if (this.currentLeaf.next == 0L) {
                        this.currentLeaf = null;
                        this.currentPos = -1;
                        return;
                    }
                    this.currentLeaf = (LeafNode)this.m.engine.get(this.currentLeaf.next, this.m.nodeSerializer);
                }
            }
            if (this.hi != null && this.currentLeaf != null && ((c = this.currentLeaf.compare(this.m.keySerializer, this.currentPos, this.hi)) > 0 || c == 0 && !this.hiInclusive)) {
                this.currentLeaf = null;
                this.currentPos = -1;
            }
        }
    }

    protected static final class NodeSerializer<A, B>
    extends Serializer<BNode> {
        protected static final int LEAF_MASK = 32768;
        protected static final int LEFT_SHIFT = 14;
        protected static final int LEFT_MASK = 16384;
        protected static final int RIGHT_SHIFT = 13;
        protected static final int RIGHT_MASK = 8192;
        protected static final int SIZE_MASK = 8191;
        protected final boolean hasValues;
        protected final boolean valsOutsideNodes;
        protected final BTreeKeySerializer keySerializer;
        protected final Serializer<Object> valueSerializer;
        protected final int numberOfNodeMetas;

        public NodeSerializer(boolean valsOutsideNodes, BTreeKeySerializer keySerializer, Serializer valueSerializer, int numberOfNodeMetas) {
            if (keySerializer == null) {
                throw new NullPointerException("keySerializer not set");
            }
            this.hasValues = valueSerializer != null;
            this.valsOutsideNodes = valsOutsideNodes;
            this.keySerializer = keySerializer;
            this.valueSerializer = this.hasValues ? (valsOutsideNodes ? VALREF_SERIALIZER : valueSerializer) : BOOLEAN_PACKED;
            this.numberOfNodeMetas = numberOfNodeMetas;
        }

        @Override
        public void serialize(DataOutput out, BNode value) throws IOException {
            boolean isLeaf = value.isLeaf();
            int header = (isLeaf ? 32768 : 0) | (value.isLeftEdge() ? 16384 : 0) | (value.isRightEdge() ? 8192 : 0) | value.keysLen(this.keySerializer);
            out.writeShort(header);
            for (int i = 0; i < this.numberOfNodeMetas; ++i) {
                DataIO.packLong(out, 0L);
            }
            if (isLeaf) {
                DataIO.packLong(out, ((LeafNode)value).next);
            } else {
                this.serializeChildArray(out, value.childArray());
            }
            if (this.keySerializer.length(value.keys) > 0) {
                this.keySerializer.serialize(out, value.keys);
            }
            if (isLeaf) {
                this.valueSerializer.valueArraySerialize(out, ((LeafNode)value).vals);
            }
        }

        protected void serializeChildArray(DataOutput out, Object childArray) throws IOException {
            if (childArray instanceof int[]) {
                int[] cc = (int[])childArray;
                DataIO.packLong(out, (long)cc[0] << 1 | 1L);
                for (int i = 1; i < cc.length; ++i) {
                    DataIO.packInt(out, cc[i]);
                }
            } else {
                long[] cc = (long[])childArray;
                DataIO.packLong(out, cc[0] << 1 | 0L);
                for (int i = 1; i < cc.length; ++i) {
                    DataIO.packLong(out, cc[i]);
                }
            }
        }

        @Override
        public BNode deserialize(DataInput in, int available) throws IOException {
            int header = in.readUnsignedShort();
            int size = header & 0x1FFF;
            for (int i = 0; i < this.numberOfNodeMetas; ++i) {
                DataIO.unpackLong(in);
            }
            boolean isLeaf = (header & 0x8000) != 0;
            int left = (header & 0x4000) >> 14;
            int right = (header & 0x2000) >> 13;
            DataIO.DataInputInternal in2 = (DataIO.DataInputInternal)in;
            BNode node = isLeaf ? this.deserializeLeaf(in2, size, left, right) : this.deserializeDir(in2, size, left, right);
            return node;
        }

        private BNode deserializeDir(DataIO.DataInputInternal in, int size, int left, int right) throws IOException {
            Object[] child;
            Object[] child_;
            long firstChild = in.unpackLong();
            if ((firstChild & 1L) == 0L) {
                child = child_ = new long[size];
                child_[0] = firstChild >>> 1;
                in.unpackLongArray((long[])child_, 1, size);
            } else {
                child = child_ = (Object[])new int[size];
                child_[0] = (int)(firstChild >>> 1);
                in.unpackIntArray((int[])child_, 1, size);
            }
            int keysize = size - left - right;
            Object keys = keysize == 0 ? this.keySerializer.emptyKeys() : this.keySerializer.deserialize(in, keysize);
            return new DirNode(keys, left != 0, right != 0, false, child);
        }

        private BNode deserializeLeaf(DataIO.DataInputInternal in, int size, int left, int right) throws IOException {
            long next = in.unpackLong();
            int keysize = size - left - right;
            Object keys = keysize == 0 ? this.keySerializer.emptyKeys() : this.keySerializer.deserialize(in, keysize);
            Object vals = this.valueSerializer.valueArrayDeserialize(in, size - 2);
            return new LeafNode(keys, left != 0, right != 0, false, vals, next);
        }

        @Override
        public boolean isTrusted() {
            return this.keySerializer.isTrusted() && this.valueSerializer.isTrusted();
        }
    }

    public static final class LeafNode
    extends BNode {
        final Object vals;
        final long next;

        LeafNode(Object keys, boolean leftEdge, boolean rightEdge, boolean tooLarge, Object vals, long next) {
            super(keys, leftEdge, rightEdge, tooLarge);
            this.vals = vals;
            this.next = next;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Object val(int pos, Serializer valueSerializer) {
            return valueSerializer.valueArrayGet(this.vals, pos);
        }

        public byte[] childArray() {
            return null;
        }

        @Override
        public long child(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long next() {
            return this.next;
        }

        public String toString() {
            String valsStr = Fun.toString(this.vals);
            return "Leaf(" + this.leftEdgeInc() + "-" + this.rightEdgeInc() + "-" + "K" + Fun.toString(this.keys) + ", V" + valsStr + ", L=" + this.next + ")";
        }

        @Override
        public void checkStructure(BTreeKeySerializer keyser, Serializer valser) {
            super.checkStructure(keyser, valser);
            if (this.next == 0L != this.isRightEdge()) {
                throw new DBException.DataCorruption("Next link inconsistent: " + this);
            }
            if (valser == null) {
                return;
            }
            int valsSize = valser.valueArraySize(this.vals);
            if (keyser != null && this.keysLen(keyser) != valsSize + 2) {
                throw new DBException.DataCorruption("Inconsistent vals size: " + this);
            }
            for (int i = 0; i < valsSize; ++i) {
                Object val = valser.valueArrayGet(this.vals, i);
                if (val != null) continue;
                throw new DBException.DataCorruption("Val is null: " + this);
            }
        }

        @Override
        public LeafNode copyAddKey(BTreeKeySerializer keyser, Serializer valser, int pos, Object newKey, long newChild, Object newValue) {
            Object keys2 = keyser.putKey(this.keys, pos - this.leftEdgeInc(), newKey);
            Object vals2 = valser.valueArrayPut(this.vals, pos - 1, newValue);
            return new LeafNode(keys2, this.isLeftEdge(), this.isRightEdge(), false, vals2, this.next);
        }

        @Override
        public LeafNode copySplitRight(BTreeKeySerializer keyser, Serializer valser, int splitPos) {
            int keylen = keyser.length(this.keys);
            Object keys2 = keyser.copyOfRange(this.keys, splitPos - this.leftEdgeInc(), keylen);
            Object vals2 = valser.valueArrayCopyOfRange(this.vals, splitPos, valser.valueArraySize(this.vals));
            return new LeafNode(keys2, false, this.isRightEdge(), false, vals2, this.next);
        }

        @Override
        public LeafNode copySplitLeft(BTreeKeySerializer keyser, Serializer valser, int splitPos, long newNext) {
            int keypos = splitPos + 1 - this.leftEdgeInc();
            Object keys2 = keyser.copyOfRange(this.keys, 0, keypos);
            Object endkey = keyser.getKey(keys2, keypos - 1);
            keys2 = keyser.putKey(keys2, keypos, endkey);
            Object vals2 = valser.valueArrayCopyOfRange(this.vals, 0, splitPos);
            return new LeafNode(keys2, this.isLeftEdge(), false, false, vals2, newNext);
        }

        @Override
        public int valSize(Serializer valueSerializer) {
            return valueSerializer.valueArraySize(this.vals);
        }

        @Override
        public int childArrayLength() {
            return -1;
        }

        public LeafNode copyChangeValue(Serializer valser, int pos, Object value) {
            Object vals2 = valser.valueArrayUpdateVal(this.vals, pos - 1, value);
            return new LeafNode(this.keys, this.isLeftEdge(), this.isRightEdge(), false, vals2, this.next);
        }

        public LeafNode copyRemoveKey(BTreeKeySerializer keyser, Serializer valser, int pos) {
            int keyPos = pos - this.leftEdgeInc();
            Object keys2 = keyser.deleteKey(this.keys, keyPos);
            Object vals2 = valser.valueArrayDeleteValue(this.vals, pos);
            return new LeafNode(keys2, this.isLeftEdge(), this.isRightEdge(), false, vals2, this.next);
        }

        public LeafNode copyClear(BTreeKeySerializer keyser, Serializer valser) {
            Object[] keys2 = new Object[2 - this.leftEdgeInc() - this.rightEdgeInc()];
            if (!this.isLeftEdge()) {
                keys2[0] = this.key(keyser, 0);
            }
            if (!this.isRightEdge()) {
                keys2[1 - this.leftEdgeInc()] = this.highKey(keyser);
            }
            return new LeafNode(keyser.arrayToKeys(keys2), this.isLeftEdge(), this.isRightEdge(), false, valser.valueArrayEmpty(), this.next);
        }
    }

    public static final class DirNode
    extends BNode {
        final Object child;

        DirNode(Object keys, boolean leftEdge, boolean rightEdge, boolean tooLarge, Object child) {
            super(keys, leftEdge, rightEdge, tooLarge);
            this.child = child;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public Object val(int pos, Serializer valueSerializer) {
            return null;
        }

        @Override
        public Object childArray() {
            return this.child;
        }

        @Override
        public long child(int pos) {
            Object c = this.child;
            return c instanceof int[] ? (long)((int[])c)[pos] : ((long[])c)[pos];
        }

        @Override
        public int childArrayLength() {
            return this.child instanceof int[] ? ((int[])this.child).length : ((long[])this.child).length;
        }

        @Override
        public long next() {
            Object c = this.child;
            if (c instanceof int[]) {
                int[] cc = (int[])c;
                return cc[cc.length - 1];
            }
            long[] cc = (long[])c;
            return cc[cc.length - 1];
        }

        public String toString() {
            return "Dir(" + this.leftEdgeInc() + "-" + this.rightEdgeInc() + "-K" + Fun.toString(this.keys) + ", C" + Fun.toString(this.child) + ")";
        }

        @Override
        public void checkStructure(BTreeKeySerializer keyser, Serializer valser) {
            int childLen;
            super.checkStructure(keyser, valser);
            int n = childLen = this.child instanceof int[] ? ((int[])this.child).length : ((long[])this.child).length;
            if (keyser != null && childLen != this.keysLen(keyser)) {
                throw new DBException.DataCorruption("bnode has inconsistent lengths");
            }
            if (this.isRightEdge() != (this.next() == 0L)) {
                throw new DBException.DataCorruption("bnode right edge inconsistent with link");
            }
        }

        @Override
        public DirNode copyAddKey(BTreeKeySerializer keyser, Serializer valser, int pos, Object newKey, long newChild, Object newValue) {
            Object[] child2;
            Object keys2 = keyser.putKey(this.keys, pos - this.leftEdgeInc(), newKey);
            if (this.child instanceof int[]) {
                int[] child_ = (int[])this.child;
                if (newChild < Integer.MAX_VALUE) {
                    int[] child2_ = Arrays.copyOf(child_, child_.length + 1);
                    child2 = child2_;
                    if (pos < child_.length) {
                        System.arraycopy(child_, pos, child2_, pos + 1, child_.length - pos);
                    }
                    child2_[pos] = (int)newChild;
                } else {
                    int i;
                    long[] child2_ = new long[child_.length + 1];
                    child2 = child2_;
                    for (i = 0; i < pos; ++i) {
                        child2_[i] = child_[i];
                    }
                    child2_[pos] = newChild;
                    for (i = pos + 1; i < child2_.length; ++i) {
                        child2_[i] = child_[pos - 1];
                    }
                }
            } else {
                long[] child2_;
                long[] child_ = (long[])this.child;
                child2 = child2_ = Arrays.copyOf(child_, child_.length + 1);
                if (pos < child_.length) {
                    System.arraycopy(child_, pos, child2_, pos + 1, child_.length - pos);
                }
                child2_[pos] = (int)newChild;
            }
            return new DirNode(keys2, this.isLeftEdge(), this.isRightEdge(), false, child2);
        }

        @Override
        public DirNode copySplitRight(BTreeKeySerializer keyser, Serializer valser, int splitPos) {
            Object[] child2;
            int keylen = keyser.length(this.keys);
            Object keys2 = keyser.copyOfRange(this.keys, splitPos - this.leftEdgeInc(), keylen);
            if (this.child instanceof int[]) {
                int[] child_ = (int[])this.child;
                child2 = Arrays.copyOfRange(child_, splitPos, child_.length);
            } else {
                long[] child_ = (long[])this.child;
                child2 = Arrays.copyOfRange(child_, splitPos, child_.length);
            }
            return new DirNode(keys2, false, this.isRightEdge(), false, child2);
        }

        @Override
        public DirNode copySplitLeft(BTreeKeySerializer keyser, Serializer valser, int splitPos, long newNext) {
            Object[] child2;
            Object keys2 = keyser.copyOfRange(this.keys, 0, splitPos + 1 - this.leftEdgeInc());
            boolean intArrayInstance = this.child instanceof int[];
            if (intArrayInstance) {
                int[] child_ = (int[])this.child;
                if (newNext < Integer.MAX_VALUE) {
                    int[] child2_ = Arrays.copyOf(child_, splitPos + 1);
                    child2_[splitPos] = (int)newNext;
                    child2 = child2_;
                } else {
                    long[] child2_ = new long[splitPos + 1];
                    for (int i = 0; i <= splitPos; ++i) {
                        child2_[i] = child_[i];
                    }
                    child2_[splitPos] = newNext;
                    child2 = child2_;
                }
            } else {
                long[] child2_ = Arrays.copyOf((long[])this.child, splitPos + 1);
                child2_[splitPos] = (int)newNext;
                child2 = child2_;
            }
            return new DirNode(keys2, this.isLeftEdge(), false, false, child2);
        }

        @Override
        public int valSize(Serializer valueSerializer) {
            throw new UnsupportedOperationException("dirnode");
        }
    }

    public static abstract class BNode {
        static final int LEFT_MASK = 1;
        static final int RIGHT_MASK = 2;
        static final int TOO_LARGE_MASK = 4;
        final Object keys;
        final byte flags;

        public BNode(Object keys, boolean leftEdge, boolean rightEdge, boolean tooLarge) {
            this.keys = keys;
            this.flags = (byte)((leftEdge ? 1 : 0) | (rightEdge ? 2 : 0) | (tooLarge ? 4 : 0));
        }

        public final Object key(BTreeKeySerializer keyser, int pos) {
            if (this.isLeftEdge() && pos-- == 0) {
                return null;
            }
            if (pos == keyser.length(this.keys) && this.isRightEdge()) {
                return null;
            }
            return keyser.getKey(this.keys, pos);
        }

        public final int keysLen(BTreeKeySerializer keyser) {
            return keyser.length(this.keys) + this.leftEdgeInc() + this.rightEdgeInc();
        }

        public final boolean isLeftEdge() {
            return (this.flags & 1) != 0;
        }

        public final boolean isRightEdge() {
            return (this.flags & 2) != 0;
        }

        public final int leftEdgeInc() {
            return this.flags & 1;
        }

        public final int rightEdgeInc() {
            return (this.flags & 2) >>> 1;
        }

        public final boolean isTooLarge() {
            return (this.flags & 4) != 0;
        }

        public abstract boolean isLeaf();

        public abstract Object val(int var1, Serializer var2);

        public final Object highKey(BTreeKeySerializer keyser) {
            if (this.isRightEdge()) {
                return null;
            }
            return keyser.getKey(this.keys, keyser.length(this.keys) - 1);
        }

        public abstract Object childArray();

        public abstract long child(int var1);

        public abstract long next();

        public final int compare(BTreeKeySerializer keyser, int pos1, int pos2) {
            if (pos1 == pos2) {
                return 0;
            }
            if (this.isLeftEdge()) {
                if (pos1-- == 0) {
                    return -1;
                }
                if (pos2-- == 0) {
                    return 1;
                }
            }
            if (this.isRightEdge()) {
                int keysLen = keyser.length(this.keys);
                if (pos1 == keysLen) {
                    return 1;
                }
                if (pos2 == keysLen) {
                    return -1;
                }
            }
            return keyser.compare(this.keys, pos1, pos2);
        }

        public final int compare(BTreeKeySerializer keyser, int pos, Object second) {
            if (this.isLeftEdge() && pos-- == 0) {
                return -1;
            }
            if (this.isRightEdge() && pos == keyser.length(this.keys)) {
                return 1;
            }
            return keyser.compare(this.keys, pos, second);
        }

        public void checkStructure(BTreeKeySerializer keyser, Serializer valser) {
            if (keyser == null) {
                return;
            }
            int keylen = keyser.length(this.keys);
            int end = keylen - 2 + this.rightEdgeInc();
            if (end > 1) {
                for (int i = 1; i <= end; ++i) {
                    if (keyser.compare(this.keys, i - 1, i) < 0) continue;
                    throw new DBException.DataCorruption("keys are not sorted: " + Arrays.toString(keyser.keysToArray(this.keys)));
                }
            }
            if (!this.isRightEdge() && keylen > 2 && keyser.compare(this.keys, keylen - 2, keylen - 1) > 0) {
                throw new DBException.DataCorruption("Last key is not sorted: " + Arrays.toString(keyser.keysToArray(this.keys)));
            }
        }

        public abstract BNode copyAddKey(BTreeKeySerializer var1, Serializer var2, int var3, Object var4, long var5, Object var7);

        public abstract BNode copySplitRight(BTreeKeySerializer var1, Serializer var2, int var3);

        public abstract BNode copySplitLeft(BTreeKeySerializer var1, Serializer var2, int var3, long var4);

        public abstract int valSize(Serializer var1);

        public abstract int childArrayLength();

        public int childIndexOf(long child) {
            for (int i = 0; i < this.childArrayLength(); ++i) {
                if (this.child(i) != child) continue;
                return i;
            }
            return -1;
        }
    }

    protected static final class ValRef {
        final long recid;

        public ValRef(long recid) {
            this.recid = recid;
        }

        public boolean equals(Object obj) {
            throw new IllegalAccessError();
        }

        public int hashCode() {
            throw new IllegalAccessError();
        }

        public String toString() {
            return "BTreeMap-ValRef[" + this.recid + "]";
        }
    }
}

