/*
 * Decompiled with CFR 0.152.
 */
package com.owc.cache;

import com.rapidminer.MacroHandler;
import com.rapidminer.operator.Operator;
import com.rapidminer.repository.RepositoryLocation;
import java.io.Serializable;
import java.util.Arrays;

public class CacheEntryKey
implements Serializable {
    private static final long serialVersionUID = -52218268145199258L;
    public final String processLocation;
    public final String cacheName;
    public final String[] macroNames;
    public final String[] macroValues;
    private int hashCode;

    public CacheEntryKey(String processLocation, String cacheName, String[] macroNames, String[] macroValues) {
        this.processLocation = processLocation;
        this.cacheName = cacheName;
        this.macroNames = macroNames;
        this.macroValues = macroValues;
        this.hashCode = this.computeHashCode();
    }

    public CacheEntryKey(RepositoryLocation processLocation, MacroHandler handler, String cacheName, String[] macroDependencies) {
        this.processLocation = processLocation == null ? "" : processLocation.getAbsoluteLocation();
        this.cacheName = cacheName;
        this.macroNames = macroDependencies;
        this.macroValues = new String[this.macroNames.length];
        int i = 0;
        for (String macroName : this.macroNames) {
            this.macroValues[i] = handler.getMacro(macroName);
            ++i;
        }
        this.hashCode = this.computeHashCode();
    }

    public CacheEntryKey(Operator operator, String cacheName, String[] macroDependencies) {
        RepositoryLocation processLocation = operator.getProcess().getRepositoryLocation();
        this.processLocation = processLocation == null ? "" : processLocation.getAbsoluteLocation();
        this.cacheName = cacheName;
        this.macroNames = macroDependencies;
        this.macroValues = new String[this.macroNames.length];
        int i = 0;
        for (String macroName : this.macroNames) {
            this.macroValues[i] = operator.getProcess().getMacroHandler().getMacro(macroName);
            ++i;
        }
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheName == null ? 0 : this.cacheName.hashCode());
        result = 31 * result + Arrays.hashCode(this.macroNames);
        result = 31 * result + Arrays.hashCode(this.macroValues);
        result = 31 * result + (this.processLocation == null ? 0 : this.processLocation.hashCode());
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheEntryKey other = (CacheEntryKey)obj;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        if (this.cacheName == null ? other.cacheName != null : !this.cacheName.equals(other.cacheName)) {
            return false;
        }
        if (!Arrays.equals(this.macroNames, other.macroNames)) {
            return false;
        }
        if (!Arrays.equals(this.macroValues, other.macroValues)) {
            return false;
        }
        return !(this.processLocation == null ? other.processLocation != null : !this.processLocation.equals(other.processLocation));
    }
}

