/*
 * Decompiled with CFR 0.152.
 */
package com.owc.data.exampleset;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import java.util.Comparator;
import org.bouncycastle.util.Arrays;

public class ExampleComparator
implements Comparator<Example> {
    private int[] invertSpecificAttributeIndex;
    private boolean enableLexicographicComparing;
    private final Attribute[] selectedLeftComparingAttributes;
    private final Attribute[] selectedRightComparingAttributes;

    public ExampleComparator(int[] invertSpecificAttributeIndex, boolean enableLexicographicComparing, Attribute[] selectedLeftComparingAttributes, Attribute[] selectedRightComparingAttributes) {
        this.invertSpecificAttributeIndex = invertSpecificAttributeIndex;
        this.enableLexicographicComparing = enableLexicographicComparing;
        this.selectedLeftComparingAttributes = selectedLeftComparingAttributes;
        this.selectedRightComparingAttributes = selectedRightComparingAttributes;
    }

    @Override
    public int compare(Example left, Example right) {
        for (int i = 0; i < this.selectedLeftComparingAttributes.length; ++i) {
            Attribute currentLeftAttribute = this.selectedLeftComparingAttributes[i];
            Attribute currentRightAttribute = this.selectedRightComparingAttributes[i];
            double leftValue = left.getValue(currentLeftAttribute);
            double rightValue = right.getValue(currentRightAttribute);
            int sortResult = 0;
            if (currentLeftAttribute.isNominal() && this.enableLexicographicComparing && !Double.isNaN(leftValue) && !Double.isNaN(rightValue)) {
                String o1String = left.getNominalValue(currentLeftAttribute);
                String o2String = right.getNominalValue(currentRightAttribute);
                sortResult = o1String.compareTo(o2String);
            } else {
                sortResult = Double.compare(leftValue, rightValue);
            }
            if (sortResult == 0) continue;
            return sortResult *= this.invertSpecificAttributeIndex[i];
        }
        return 0;
    }

    public static final boolean isEqual(Example currentSubtrahendExample, Example selectedExample, Attribute[] subtrahendAttributes, Attribute[] selectedExampleAttributes) {
        if (currentSubtrahendExample == null && selectedExample == null) {
            return true;
        }
        if (currentSubtrahendExample == null || selectedExample == null) {
            return false;
        }
        if (subtrahendAttributes == null && selectedExampleAttributes == null || subtrahendAttributes.length == 0 && selectedExampleAttributes.length == 0) {
            return true;
        }
        int[] noninverting = new int[subtrahendAttributes.length];
        Arrays.fill((int[])noninverting, (int)1);
        ExampleComparator exampleComparator = new ExampleComparator(noninverting, true, subtrahendAttributes, selectedExampleAttributes);
        return exampleComparator.compare(currentSubtrahendExample, selectedExample) == 0;
    }

    public static final boolean isSmaller(Example currentSubtrahendExample, Example selectedExample, Attribute[] subtrahendAttributes, Attribute[] selectedExampleAttributes) {
        if (currentSubtrahendExample == null && selectedExample == null) {
            return true;
        }
        if (subtrahendAttributes == null && selectedExampleAttributes == null || subtrahendAttributes.length == 0 && selectedExampleAttributes.length == 0) {
            return true;
        }
        int[] noninverting = new int[subtrahendAttributes.length];
        Arrays.fill((int[])noninverting, (int)1);
        ExampleComparator exampleComparator = new ExampleComparator(noninverting, true, subtrahendAttributes, selectedExampleAttributes);
        return exampleComparator.compare(currentSubtrahendExample, selectedExample) < 0;
    }
}

