/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.actions;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.flow.processrendering.annotations.model.WorkflowAnnotation;
import com.rapidminer.gui.flow.processrendering.annotations.model.WorkflowAnnotations;
import com.rapidminer.gui.flow.processrendering.model.ProcessRendererModel;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;

public class ShiftOperatorsAction
extends ResourceAction {
    private static final long serialVersionUID = -6393968843333727115L;

    public ShiftOperatorsAction() {
        super(false, "toolkit.shift_operators", new Object[0]);
    }

    public void actionPerformed(ActionEvent e) {
        ProcessRendererModel model = RapidMinerGUI.getMainFrame().getProcessPanel().getProcessRenderer().getModel();
        List selectedOperators = model.getSelectedOperators();
        double minX = 2.147483647E9;
        double maxX = 0.0;
        ExecutionUnit unit = null;
        for (Operator operator : selectedOperators) {
            Rectangle2D operatorRect = model.getOperatorRect(operator);
            minX = Math.min(minX, operatorRect.getMinX());
            maxX = Math.max(maxX, operatorRect.getMaxX());
            unit = operator.getExecutionUnit();
        }
        double shift = maxX - minX + 45.0;
        if (unit != null) {
            List operators = unit.getOperators();
            LinkedList<Operator> movedOperators = new LinkedList<Operator>();
            for (Operator operator : operators) {
                Rectangle2D operatorRect;
                if (selectedOperators.contains(operator) || !((operatorRect = model.getOperatorRect(operator)).getMinX() >= minX)) continue;
                model.setOperatorRect(operator, (Rectangle2D)new Rectangle2D.Double(operatorRect.getMinX() + shift, operatorRect.getMinY(), operatorRect.getWidth(), operatorRect.getHeight()));
                movedOperators.add(operator);
            }
            model.fireOperatorsMoved(movedOperators);
            WorkflowAnnotations annotations = model.getProcessAnnotations(unit);
            if (annotations != null) {
                for (WorkflowAnnotation annotation : annotations.getAnnotationsDrawOrder()) {
                    Rectangle2D location = annotation.getLocation();
                    if (!(location.getMinX() > minX)) continue;
                    annotation.setLocation((Rectangle2D)new Rectangle2D.Double(location.getMinX() + shift, location.getMinY(), location.getWidth(), location.getHeight()));
                }
            }
        }
    }
}

