/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.renderer;

import com.owc.gui.actions.RowSelectionEventListener;
import com.owc.gui.viewer.ModelGroupDataViewer;
import com.owc.objects.indexed.IndexedIOObject;
import com.owc.objects.indexed.IndexedModel;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.look.Colors;
import com.rapidminer.gui.processeditor.results.ResultDisplayTools;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.report.Reportable;
import com.rapidminer.tools.container.Pair;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class IndexedModelRenderer
extends AbstractRenderer
implements Reportable {
    private static HashMap<Integer, Integer> COLUMN_DIVIDER_MAP = new HashMap();

    public String getName() {
        return "Indexed Model";
    }

    public Reportable createReportable(Object renderable, IOContainer ioContainer, int desiredWidth, int desiredHeight) {
        return this;
    }

    public Component getVisualizationComponent(Object renderable, final IOContainer ioContainer) {
        final ExtendedJScrollPane rightView = new ExtendedJScrollPane();
        rightView.setBackground((Color)Colors.WHITE);
        rightView.getViewport().setBackground(Colors.WHITE);
        rightView.setOpaque(true);
        final JSplitPane splitView = new JSplitPane();
        if (!(renderable instanceof IndexedModel)) {
            return new JPanel();
        }
        IndexedModel indexedPredictionModel = (IndexedModel)renderable;
        List<Pair<IndexedIOObject.IndexedIOObjectKey, Model>> all = indexedPredictionModel.getAll();
        final Model[] models = new Model[all.size()];
        Object[] attributeNames = indexedPredictionModel.getIndexColumnNames();
        int[] attributeTypes = indexedPredictionModel.getIndexColumnTypes();
        final int dividerHash = Arrays.hashCode(attributeNames) ^ Arrays.hashCode(attributeTypes);
        ExampleSetCreator creator = new ExampleSetCreator((String[])attributeNames, attributeTypes, false);
        int modelsIndex = 0;
        for (Pair<IndexedIOObject.IndexedIOObjectKey, Model> pair : all) {
            IndexedIOObject.IndexedIOObjectKey key = (IndexedIOObject.IndexedIOObjectKey)pair.getFirst();
            int i = 0;
            for (Object groupAttribute : attributeNames) {
                if (key.nominalValues[i] == null) {
                    creator.setValue((String)groupAttribute, key.numericalValues[i]);
                } else {
                    creator.setValue((String)groupAttribute, key.nominalValues[i]);
                }
                ++i;
            }
            creator.commit();
            models[modelsIndex++] = (Model)pair.getSecond();
        }
        ExampleSet indexSet = creator.finish();
        if (indexSet.size() <= 0) {
            return new JPanel();
        }
        final ModelGroupDataViewer groupView = new ModelGroupDataViewer();
        groupView.registerRowSelectedListener(new RowSelectionEventListener(){

            @Override
            public void rowSelected(final int rowNumber) {
                final int translatedRowNumber = groupView.getModelIndex(rowNumber);
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        if (!splitView.isShowing()) return;
                        int dividerLocation = splitView.getDividerLocation();
                        rightView.removeAll();
                        Model[] modelArray = models;
                        synchronized (models) {
                            splitView.setRightComponent(ResultDisplayTools.createVisualizationComponent((IOObject)models[translatedRowNumber], (IOContainer)ioContainer, (String)("result for row " + rowNumber + ":"), (boolean)false));
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            rightView.revalidate();
                            rightView.repaint();
                            splitView.setDividerLocation(dividerLocation);
                            return;
                        }
                    }
                });
            }
        });
        groupView.getTableHeader().setReorderingAllowed(true);
        groupView.setSortable(false);
        groupView.setBackground(Colors.WHITE);
        groupView.setOpaque(true);
        groupView.setExampleSet(indexSet);
        groupView.setSelectionMode(0);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    groupView.unpack();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException key) {
            // empty catch block
        }
        ExtendedJScrollPane leftView = new ExtendedJScrollPane((Component)((Object)groupView));
        leftView.setBackground((Color)Colors.WHITE);
        leftView.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        leftView.getViewport().setBackground(Colors.WHITE);
        leftView.setOpaque(true);
        splitView.setLeftComponent((Component)leftView);
        splitView.setRightComponent((Component)rightView);
        splitView.setBackground(Colors.WHITE);
        splitView.setOpaque(true);
        if (COLUMN_DIVIDER_MAP.containsKey(dividerHash)) {
            splitView.setDividerLocation(COLUMN_DIVIDER_MAP.get(dividerHash));
        }
        splitView.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent changeEvent) {
                JSplitPane sourceSplitPane = (JSplitPane)changeEvent.getSource();
                String propertyName = changeEvent.getPropertyName();
                if (propertyName.equals("dividerLocation")) {
                    COLUMN_DIVIDER_MAP.put(dividerHash, sourceSplitPane.getDividerLocation());
                }
            }
        });
        return splitView;
    }
}

