/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.renderer.actions;

import com.owc.gui.tools.I18nActionResult;
import com.owc.tools.files.remote.configuration.RemoteFileConnectionConfigurable;
import com.owc.vfs2.impl.AdvancedVFS;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.config.TestConfigurableAction;
import com.rapidminer.tools.config.actions.ActionResult;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;

public class RemoteFileConnectionTestAction
extends TestConfigurableAction {
    String url;
    FileSystemOptions options;
    RemoteFileConnectionConfigurable config;

    public RemoteFileConnectionTestAction(RemoteFileConnectionConfigurable config) {
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionResult doWork() {
        FileSystemManager manager;
        try {
            this.url = this.config.getVfsUri();
            this.options = this.config.getVfsOptions();
        }
        catch (UserError e1) {
            return new I18nActionResult("action.toolkit.test_connection.file_not_found", ActionResult.Result.FAILURE, this.url);
        }
        try {
            manager = AdvancedVFS.getManager();
        }
        catch (FileSystemException e1) {
            return new I18nActionResult("action.toolkit.test_connection.resolve_file", ActionResult.Result.FAILURE, this.url);
        }
        try (FileObject file = manager.resolveFile(this.url, this.options);){
            if (file.exists()) {
                I18nActionResult i18nActionResult2 = new I18nActionResult("action.toolkit.test_connection.connection_successful", ActionResult.Result.SUCCESS, new Object[0]);
                return i18nActionResult2;
            }
            I18nActionResult i18nActionResult = new I18nActionResult("action.toolkit.test_connection.file_not_found", ActionResult.Result.FAILURE, this.url);
            return i18nActionResult;
        }
        catch (FileSystemException e) {
            return new I18nActionResult("action.toolkit.test_connection.resolve_file", ActionResult.Result.FAILURE, this.url);
        }
    }
}

