/*
 * Decompiled with CFR 0.152.
 */
package com.owc.metadata;

import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.MetaDataChangeListener;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.MetaDataProvider;
import java.util.List;

public class PortExtenderMetaDataProvider
implements MetaDataProvider {
    private InputPortExtender extender;
    private boolean intersect;

    public PortExtenderMetaDataProvider(InputPortExtender extender, boolean intersect) {
        this.extender = extender;
        this.intersect = intersect;
    }

    public MetaData getMetaData() {
        if (this.extender != null) {
            List metaDatas = this.extender.getMetaData(true);
            ExampleSetMetaData emdReferenceSet = new ExampleSetMetaData();
            boolean isExampleSet = false;
            for (MetaData metaData : metaDatas) {
                if (!(metaData instanceof ExampleSetMetaData)) continue;
                ExampleSetMetaData emdNewSet = (ExampleSetMetaData)metaData;
                if (!isExampleSet || !this.intersect) {
                    emdReferenceSet.addAllAttributes(emdNewSet.getAllAttributes());
                    continue;
                }
                ExampleSetMetaData emdIntersectedSet = new ExampleSetMetaData();
                for (AttributeMetaData amd : emdNewSet.getAllAttributes()) {
                    AttributeMetaData amdReferenceSet = emdReferenceSet.getAttributeByName(amd.getName());
                    if (amdReferenceSet == null) continue;
                    emdIntersectedSet.addAttribute(amdReferenceSet);
                }
                emdNewSet = emdIntersectedSet;
            }
            if (isExampleSet) {
                return emdReferenceSet;
            }
            if (metaDatas.isEmpty()) {
                return null;
            }
            return (MetaData)metaDatas.get(0);
        }
        return null;
    }

    public void addMetaDataChangeListener(MetaDataChangeListener l) {
        for (InputPort inputPort : this.extender.getManagedPorts()) {
            inputPort.registerMetaDataChangeListener(l);
        }
    }

    public void removeMetaDataChangeListener(MetaDataChangeListener l) {
        for (InputPort inputPort : this.extender.getManagedPorts()) {
            inputPort.removeMetaDataChangeListener(l);
        }
    }
}

