/*
 * Decompiled with CFR 0.152.
 */
package com.owc.objects;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.example.table.PolynominalMapping;
import com.rapidminer.example.table.ViewAttribute;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.OperatorProgress;
import com.rapidminer.operator.ViewModel;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import java.text.NumberFormat;
import java.util.Arrays;

public class DiscretizationModel
extends PreprocessingModel {
    private static final long serialVersionUID = 8238561093115224050L;
    private double[][] rangeLimits;
    private RangeNameSchema rangeNameSchema;
    private boolean includeUpperLimit;
    private String[] attributeNames;
    private String rangeNamePrefix;
    private NumberFormat numberFormat;

    public DiscretizationModel(ExampleSet exampleSet, double[][] rangeLimits, RangeNameSchema rangeNameSchema, NumberFormat numberFormat, boolean includeUpperLimit, String[] attributeNames, String rangeNamePrefix) {
        super(exampleSet);
        this.rangeLimits = rangeLimits;
        this.rangeNameSchema = rangeNameSchema;
        this.includeUpperLimit = includeUpperLimit;
        this.attributeNames = attributeNames;
        this.rangeNamePrefix = rangeNamePrefix;
        this.numberFormat = numberFormat;
    }

    public ExampleSet applyOnData(ExampleSet exampleSet) throws OperatorException {
        OperatorProgress progress = null;
        if (this.getShowProgress() && this.getOperator() != null && this.getOperator().getProgress() != null) {
            progress = this.getOperator().getProgress();
            progress.setTotal((int)((double)exampleSet.size() * 1.2));
            progress.setCompleted(0);
        }
        int numberOfAttributes = this.attributeNames.length;
        Attribute[] oldAttributes = new Attribute[numberOfAttributes];
        Attribute[] newAttributes = new Attribute[numberOfAttributes];
        boolean[] ignoreAttribute = new boolean[numberOfAttributes];
        String[] attributeRole = new String[numberOfAttributes];
        ExampleTable table = exampleSet.getExampleTable();
        Attributes attributes = exampleSet.getAttributes();
        int i = 0;
        for (String attributeName : this.attributeNames) {
            Attribute attribute = attributes.get(attributeName);
            if (attribute != null && attribute.isNumerical()) {
                Attribute newAttribute = AttributeFactory.createAttribute((int)1);
                table.addAttribute(newAttribute);
                attributes.addRegular(newAttribute);
                oldAttributes[i] = attribute;
                newAttributes[i] = newAttribute;
                attributeRole[i] = attributes.getRole(attribute).getSpecialName();
            } else {
                ignoreAttribute[i] = true;
            }
            ++i;
        }
        int[][] rangeNameValueIndices = new int[numberOfAttributes][];
        for (i = 0; i < numberOfAttributes; ++i) {
            if (!ignoreAttribute[i]) {
                rangeNameValueIndices[i] = new int[this.rangeLimits[i].length + 1];
                for (int j = 0; j < this.rangeLimits[i].length - 1; ++j) {
                    rangeNameValueIndices[i][j] = newAttributes[i].getMapping().mapString(this.rangeNameSchema.getRangeName(this.rangeNamePrefix, this.numberFormat, j + 1, this.rangeLimits[i][j], this.rangeLimits[i][j + 1], this.includeUpperLimit));
                }
            }
            progress.setCompleted((int)((double)i / (double)numberOfAttributes * 0.2 * (double)exampleSet.size()));
        }
        double progressBase = 0.2 * (double)exampleSet.size();
        int z = 0;
        for (Example example : exampleSet) {
            for (i = 0; i < numberOfAttributes; ++i) {
                if (ignoreAttribute[i]) continue;
                double value = example.getValue(oldAttributes[i]);
                int rangeNameIndex = Arrays.binarySearch(this.rangeLimits[i], value);
                if (rangeNameIndex < 0) {
                    if ((rangeNameIndex = -(rangeNameIndex + 1)) == 0 || rangeNameIndex == this.rangeLimits[i].length) {
                        example.setValue(newAttributes[i], Double.NaN);
                        continue;
                    }
                    example.setValue(newAttributes[i], (double)rangeNameValueIndices[i][rangeNameIndex - 1]);
                    continue;
                }
                if (this.includeUpperLimit) {
                    --rangeNameIndex;
                }
                if (rangeNameIndex < 0 || rangeNameIndex >= this.rangeLimits[i].length - 1) {
                    example.setValue(newAttributes[i], Double.NaN);
                    continue;
                }
                example.setValue(newAttributes[i], (double)rangeNameValueIndices[i][rangeNameIndex]);
            }
            if (z % 500 == 0 && progress != null) {
                progress.setCompleted((int)progressBase + z);
            }
            ++z;
        }
        for (i = 0; i < numberOfAttributes; ++i) {
            if (ignoreAttribute[i]) continue;
            String name = oldAttributes[i].getName();
            attributes.remove(oldAttributes[i]);
            newAttributes[i].setName(name);
            if (attributeRole[i] == null) continue;
            attributes.setSpecialAttribute(newAttributes[i], attributeRole[i]);
        }
        return exampleSet;
    }

    public Attributes getTargetAttributes(ExampleSet parentSet) {
        Attributes attributes = parentSet.getAttributes();
        for (int i = 0; i < this.attributeNames.length; ++i) {
            Attribute oldAttribute = attributes.get(this.attributeNames[i]);
            String oldAttributeRole = attributes.getRole(oldAttribute).getSpecialName();
            if (!oldAttribute.isNumerical()) continue;
            PolynominalMapping mapping = new PolynominalMapping();
            for (int j = 0; j < this.rangeLimits[i].length - 1; ++j) {
                mapping.mapString(this.rangeNameSchema.getRangeName(this.rangeNamePrefix, this.numberFormat, j + 1, this.rangeLimits[i][j], this.rangeLimits[i][j + 1], this.includeUpperLimit));
            }
            attributes.remove(oldAttribute);
            attributes.addRegular((Attribute)new ViewAttribute((ViewModel)this, oldAttribute, oldAttribute.getName(), 7, (NominalMapping)mapping));
            if (oldAttributeRole == null) continue;
            attributes.setSpecialAttribute(oldAttribute, oldAttributeRole);
        }
        return attributes;
    }

    public double getValue(Attribute targetAttribute, double value) {
        int i;
        for (i = 0; i < this.attributeNames.length && !targetAttribute.getName().equals(this.attributeNames[i]); ++i) {
        }
        double rangeNameIndex = Arrays.binarySearch(this.rangeLimits[i], value);
        if (rangeNameIndex < 0.0) {
            if ((rangeNameIndex = -(rangeNameIndex + 1.0)) == 0.0 || rangeNameIndex == (double)this.rangeLimits[i].length) {
                return Double.NaN;
            }
            return rangeNameIndex - 1.0;
        }
        if (this.includeUpperLimit) {
            rangeNameIndex -= 1.0;
        }
        if (rangeNameIndex < 0.0 || rangeNameIndex >= (double)(this.rangeLimits[i].length - 1)) {
            return Double.NaN;
        }
        return rangeNameIndex;
    }

    protected boolean needsRemapping() {
        return false;
    }

    public static enum RangeNameSchema {
        NUMBER(false, true, false),
        NUMBERED(true, true, false),
        INTERVAL(false, false, true),
        NUMBERED_INTERVAL(false, true, true);

        private boolean includeName;
        private boolean includeNumber;
        private boolean includeInterval;

        private RangeNameSchema(boolean includeName, boolean includeNumber, boolean includeInterval) {
            this.includeInterval = includeInterval;
            this.includeName = includeName;
            this.includeNumber = includeNumber;
        }

        public boolean includesInterval() {
            return this.includeInterval;
        }

        public String getRangeName(String name, NumberFormat numberFormat, int number, double lowerLimit, double upperLimit, boolean includeUpperLimit) {
            StringBuilder builder = new StringBuilder();
            if (this.includeName) {
                builder.append(name);
            }
            if (this.includeNumber) {
                builder.append(number);
                if (this.includeInterval) {
                    builder.append(": ");
                }
            }
            if (this.includeInterval) {
                if (includeUpperLimit) {
                    builder.append("]");
                    builder.append(numberFormat.format(lowerLimit));
                    builder.append(";");
                    builder.append(numberFormat.format(upperLimit));
                    if (Double.isInfinite(upperLimit)) {
                        builder.append("[");
                    } else {
                        builder.append("]");
                    }
                } else {
                    if (Double.isInfinite(lowerLimit)) {
                        builder.append("]");
                    } else {
                        builder.append("[");
                    }
                    builder.append(numberFormat.format(lowerLimit));
                    builder.append(";");
                    builder.append(numberFormat.format(upperLimit));
                    builder.append("[");
                }
            }
            return builder.toString();
        }
    }
}

