/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator;

import com.owc.operator.OrderedPortOperatorChain;
import com.owc.tools.ExampleSetMaterializer;
import com.rapidminer.RapidMiner;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.studio.concurrency.internal.ConcurrencyExecutionService;
import com.rapidminer.studio.concurrency.internal.ConcurrencyExecutionServiceProvider;
import com.rapidminer.studio.concurrency.internal.ExecutionExceptionHandling;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class ParallelOperatorChain
extends OrderedPortOperatorChain {
    public static String PARAMETER_ENABLE_PARALLEL_EXECUTION = "enable_parallel_execution";
    public static String PARAMETER_MATERIALIZE_DATA = "force_data_materialization";

    public ParallelOperatorChain(OperatorDescription description, String ... subprocessNames) {
        super(description, subprocessNames);
    }

    protected <T> T getAndCheckForStop(final Future<T> future) throws OperatorException {
        try {
            ConcurrencyExecutionService service = ConcurrencyExecutionServiceProvider.INSTANCE.getService();
            return (T)service.executeBlockingTask(new Callable<T>(){

                @Override
                public T call() throws ExecutionException, ProcessStoppedException {
                    Object t = null;
                    while (t == null) {
                        try {
                            t = future.get();
                        }
                        catch (InterruptedException e) {
                            ParallelOperatorChain.this.checkForStop();
                        }
                    }
                    return t;
                }
            });
        }
        catch (ProcessStoppedException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw ExecutionExceptionHandling.INSTANCE.processExecutionException(e, this.getProcess());
        }
        catch (Exception e) {
            throw new OperatorException("There seems to be a race condition in the parallel execution. Please try again and contact support.", (Throwable)e);
        }
    }

    protected boolean checkParallelizability() {
        boolean executeParallely = this.getParameterAsBoolean(PARAMETER_ENABLE_PARALLEL_EXECUTION);
        if ((executeParallely &= ConcurrencyExecutionServiceProvider.INSTANCE.isInitialized()) && !RapidMiner.getExecutionMode().isHeadless()) {
            for (ExecutionUnit unit : this.getSubprocesses()) {
                for (Operator operator : unit.getAllInnerOperators()) {
                    if (!operator.isEnabled() || !operator.hasBreakpoint()) continue;
                    return false;
                }
            }
        }
        return executeParallely;
    }

    protected List<IOObject> getDataCopy(List<IOObject> inputData) throws UndefinedParameterError {
        ArrayList<IOObject> clonedInputData = new ArrayList<IOObject>(inputData.size());
        for (IOObject object : inputData) {
            clonedInputData.add(this.getDataCopy(object));
        }
        return clonedInputData;
    }

    protected IOObject getDataCopy(IOObject input) throws UndefinedParameterError {
        if (input instanceof ExampleSet) {
            if (this.getParameterAsBoolean(PARAMETER_MATERIALIZE_DATA)) {
                ExampleSet set = (ExampleSet)input;
                return ExampleSetMaterializer.materializeExampleSet(set);
            }
            ExampleSet set = (ExampleSet)((ExampleSet)input).clone();
            set.cleanup();
            return set;
        }
        if (input != null) {
            return input.copy();
        }
        return null;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_ENABLE_PARALLEL_EXECUTION, "This enables parallel execution of the computation of the inner processes. Disable if you either run into memory problems or if you need sequential computing for using side effects like macro variable or Remember and Recall operators within the execution. However, if you only need the side effect of the last iteration, you can stick to parallel execution as the last result will be propagated to the outside process and can be used in the usual way. So only disable if you use side effects from one iteration to the next. Will be automatically disabled with break points in subprocesses or if you use the loop ports of this operator.", true, true));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_MATERIALIZE_DATA, "Some older or buggy operators, especially from extensions, need a materialized copy of data in order to work properly. Strange errors and wrong results can occur otherwise. If you notice such, check this parameter to circumvent this problem in sacrifice for speed.", false, true));
        return types;
    }
}

