/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.cache;

import com.owc.cache.CacheEntry;
import com.owc.cache.CacheEntryKey;
import com.owc.cache.CacheEntryMetaData;
import com.owc.cache.CacheManager;
import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.rapidminer.RapidMiner;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import java.util.Iterator;
import java.util.List;

public class RetrieveCacheOperator
extends LicensedOperator {
    public static final String PARAMETER_CACHE_NAME = "cache_name";
    public static final String PARAMETER_CACHING_PROCESS = "caching_process";
    public static final String PARAMETER_CACHE_DEPENDENCIES = "cache_dependencies";
    public static final String PARAMETER_RESTRICT_VALIDITY = "restrict_validity";
    public static final String PARAMETER_VALIDITY_PERIOD = "validity_period";
    public static final String PARAMETER_THROW_ERROR_ON_MISS = "throw_error_on_miss";
    private OutputPortExtender outputExtender = new OutputPortExtender("output", (Ports)this.getOutputPorts());
    private PortPairExtender extender = new PortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public RetrieveCacheOperator(OperatorDescription description) {
        super(description);
        this.outputExtender.start();
        this.extender.start();
        this.getTransformer().addRule(new MDTransformationRule(){

            private void registerError(String key, Object ... args) {
                Iterator iterator = RetrieveCacheOperator.this.outputExtender.getManagedPorts().iterator();
                if (iterator.hasNext()) {
                    OutputPort port = (OutputPort)iterator.next();
                    SimpleMetaDataError error = new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)RetrieveCacheOperator.this.outputExtender.getManagedPorts().iterator().next(), key, args);
                    port.addError((MetaDataError)error);
                }
            }

            public void transformMD() {
                try {
                    Entry entry;
                    RepositoryLocation parentLocation;
                    String cacheName = RetrieveCacheOperator.this.getParameterAsString(RetrieveCacheOperator.PARAMETER_CACHE_NAME);
                    if (cacheName == null || cacheName.isEmpty()) {
                        this.registerError("cache_name_missing", new Object[0]);
                        return;
                    }
                    String cachingProcessName = RetrieveCacheOperator.this.getParameterAsString(RetrieveCacheOperator.PARAMETER_CACHING_PROCESS);
                    RepositoryLocation location = null;
                    location = cachingProcessName == null ? RetrieveCacheOperator.this.getProcess().getRepositoryLocation() : ((parentLocation = RetrieveCacheOperator.this.getProcess().getRepositoryLocation()) != null ? new RepositoryLocation(parentLocation.parent(), cachingProcessName) : new RepositoryLocation(cachingProcessName));
                    if (location != null && (entry = location.locateEntry()) == null && cachingProcessName != null && cachingProcessName.length() != 0) {
                        if (RetrieveCacheOperator.this.getParameterAsBoolean(RetrieveCacheOperator.PARAMETER_THROW_ERROR_ON_MISS)) {
                            this.registerError("cache_miss", new Object[0]);
                        }
                        return;
                    }
                    CacheEntryKey key = new CacheEntryKey(location, RetrieveCacheOperator.this.getProcess().getMacroHandler(), cacheName, ParameterTypeEnumeration.transformString2Enumeration((String)RetrieveCacheOperator.this.getParameterAsString(RetrieveCacheOperator.PARAMETER_CACHE_DEPENDENCIES)));
                    CacheEntryMetaData cacheEntry = CacheManager.retrieveMetaData(key);
                    if (cacheEntry != null && RetrieveCacheOperator.this.getParameterAsBoolean(RetrieveCacheOperator.PARAMETER_RESTRICT_VALIDITY) && cacheEntry.timestamp + (long)RetrieveCacheOperator.this.getParameterAsInt(RetrieveCacheOperator.PARAMETER_VALIDITY_PERIOD) < System.currentTimeMillis()) {
                        cacheEntry = null;
                    }
                    if (cacheEntry != null) {
                        Iterator portIterator = RetrieveCacheOperator.this.outputExtender.getManagedPorts().iterator();
                        for (MetaData metadata : cacheEntry.payload) {
                            if (!portIterator.hasNext()) continue;
                            ((OutputPort)portIterator.next()).deliverMD(metadata);
                        }
                    } else if (RetrieveCacheOperator.this.getParameterAsBoolean(RetrieveCacheOperator.PARAMETER_THROW_ERROR_ON_MISS)) {
                        this.registerError("cache_miss", new Object[0]);
                    }
                }
                catch (RepositoryException e) {
                    this.registerError("no_user_rights", new Object[0]);
                }
                catch (UndefinedParameterError e) {
                }
                catch (MalformedRepositoryLocationException e) {
                    this.registerError("illegal_repository_location", RetrieveCacheOperator.PARAMETER_CACHING_PROCESS);
                }
            }
        });
        this.getTransformer().addRule(this.extender.makePassThroughRule());
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        String cacheName = this.getParameterAsString(PARAMETER_CACHE_NAME);
        if (cacheName == null || cacheName.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_CACHE_NAME});
        }
        String cachingProcessName = this.getParameterAsString(PARAMETER_CACHING_PROCESS);
        RepositoryLocation location = null;
        location = cachingProcessName == null ? this.getProcess().getRepositoryLocation() : this.getParameterAsRepositoryLocation(PARAMETER_CACHING_PROCESS);
        try {
            CacheEntryKey key;
            CacheEntry cacheEntry;
            if (location != null) {
                Entry entry = location.locateEntry();
                if (entry == null && cachingProcessName != null && cachingProcessName.length() != 0) {
                    if (this.getParameterAsBoolean(PARAMETER_THROW_ERROR_ON_MISS)) {
                        throw new UserError((Operator)this, "toolkit.cache_miss");
                    }
                    return;
                }
            } else if (RapidMiner.getExecutionMode() == RapidMiner.ExecutionMode.APPSERVER) {
                throw new OperatorException("Could not access process in repository. Check Access Rights.");
            }
            if ((cacheEntry = CacheManager.retrieve(key = new CacheEntryKey(location, this.getProcess().getMacroHandler(), cacheName, ParameterTypeEnumeration.transformString2Enumeration((String)this.getParameterAsString(PARAMETER_CACHE_DEPENDENCIES))))) != null && this.getParameterAsBoolean(PARAMETER_RESTRICT_VALIDITY) && cacheEntry.timestamp + (long)this.getParameterAsInt(PARAMETER_VALIDITY_PERIOD) < System.currentTimeMillis()) {
                cacheEntry = null;
            }
            if (cacheEntry != null) {
                int objectsDeliverd = 0;
                Iterator portIterator = this.outputExtender.getManagedPorts().iterator();
                for (IOObject object : cacheEntry.payload) {
                    if (!portIterator.hasNext()) continue;
                    ((OutputPort)portIterator.next()).deliver(object);
                    if (object == null) continue;
                    ++objectsDeliverd;
                }
                if (objectsDeliverd > 1) {
                    throw new UserError((Operator)this, "toolkit.license_exceeded_cache_size");
                }
            } else if (this.getParameterAsBoolean(PARAMETER_THROW_ERROR_ON_MISS)) {
                throw new UserError((Operator)this, "toolkit.cache_miss");
            }
        }
        catch (RepositoryException e) {
            throw new UserError((Operator)this, (Throwable)e, "toolkit.no_user_rights_on_cache_entry", new Object[]{location.getAbsoluteLocation()});
        }
        this.extender.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeRepositoryLocation(PARAMETER_CACHING_PROCESS, "Select the process that generated the cache entry you want to clear. You may select nothing to retrieve from the cache of this process.", true, false, true));
        types.add((ParameterType)new ParameterTypeString(PARAMETER_CACHE_NAME, "The name of this cache. All caches are bound to the process they are created in, but can be shared within a process.", false, false));
        types.add((ParameterType)new ParameterTypeEnumeration(PARAMETER_CACHE_DEPENDENCIES, "If the cache should depend on changing values of macros/process variables, you can add their names to this list. Cache will then be specific to these values. Can be used for making user or query specific caches in Web Apps.", (ParameterType)new ParameterTypeString(PARAMETER_CACHE_DEPENDENCIES, "The name of the macro/process variable that this cache should be sensitive to.")));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_RESTRICT_VALIDITY, "If the cache content may outdate, you can restrict the validity here. This ensures that no outdated data will be delivered, but rather an error will be signaled or nothing returned..", false, false));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_VALIDITY_PERIOD, "The number of miliseconds this cache remains valid after the results have been generated. Can be used to refresh the cache when queried after a given time.", 0, Integer.MAX_VALUE, true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_RESTRICT_VALIDITY, true, true));
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_THROW_ERROR_ON_MISS, "Throw an error rather than return no result if the query results in a cache miss.", true, false));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

