/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.data.generation;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.MacroHandler;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.GenerateNewExampleSetMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class GenerateDataFromMacrosOperator
extends LicensedOperator {
    public static final String[] MODES = new String[]{"1 Example, n Attributes", "n Examples, 2 Attributes"};
    public static final String PARAMETER_MODE = "mode";
    public static final String PARAMETER_EXCLUDE_PREDEFINED_MACROS = "exclude_predefined_macros";
    private OutputPort exampleSetOutputPort = (OutputPort)this.getOutputPorts().createPort("example set output");

    public GenerateDataFromMacrosOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewExampleSetMDRule(this.exampleSetOutputPort){

            public MetaData modifyMetaData(ExampleSetMetaData unmodifiedMetaData) {
                try {
                    int mode = GenerateDataFromMacrosOperator.this.getParameterAsInt(GenerateDataFromMacrosOperator.PARAMETER_MODE);
                    if (mode == 0) {
                        unmodifiedMetaData.attributesAreSuperset();
                    } else {
                        unmodifiedMetaData.addAttribute(new AttributeMetaData("Macro", 7));
                        unmodifiedMetaData.addAttribute(new AttributeMetaData("Value", 7));
                    }
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    // empty catch block
                }
                return unmodifiedMetaData;
            }
        });
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        HashSet<String> predefinedMacrosSet = new HashSet<String>();
        MacroHandler macroHandler = this.getProcess().getMacroHandler();
        if (this.getParameterAsBoolean(PARAMETER_EXCLUDE_PREDEFINED_MACROS)) {
            for (String predefinedMacro : macroHandler.getAllPredefinedMacros()) {
                predefinedMacrosSet.add(predefinedMacro);
            }
        }
        Iterator iterator = macroHandler.getDefinedMacroNames();
        if (this.getParameterAsInt(PARAMETER_MODE) == 0) {
            LinkedHashMap<String, Integer> attributes = new LinkedHashMap<String, Integer>();
            while (iterator.hasNext()) {
                String macro = (String)iterator.next();
                if (predefinedMacrosSet.contains(macro)) continue;
                attributes.put(macro.substring(0, 1).toUpperCase() + macro.substring(1), 7);
            }
            ExampleSetCreator creator = new ExampleSetCreator(attributes);
            iterator = macroHandler.getDefinedMacroNames();
            while (iterator.hasNext()) {
                String macro = (String)iterator.next();
                if (predefinedMacrosSet.contains(macro)) continue;
                creator.setValue(macro.substring(0, 1).toUpperCase() + macro.substring(1), macroHandler.getMacro(macro));
            }
            creator.commit();
            this.exampleSetOutputPort.deliver((IOObject)creator.finish());
        } else {
            ExampleSetCreator creator = new ExampleSetCreator(new String[]{"Macro", "Value"}, new int[]{7, 7});
            while (iterator.hasNext()) {
                String macro = (String)iterator.next();
                if (predefinedMacrosSet.contains(macro)) continue;
                creator.setValue("Macro", macro);
                creator.setValue("Value", macroHandler.getMacro(macro));
                creator.commit();
            }
            this.exampleSetOutputPort.deliver((IOObject)creator.finish());
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeCategory(PARAMETER_MODE, "Select how the macros should be returned.", MODES, 0));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_EXCLUDE_PREDEFINED_MACROS, "If checked, predefined macros will not be part of the result.", true));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

