/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.data.generation;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.GenerateNewExampleSetMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.List;

public class GenerateSequenceDataOperator
extends LicensedOperator {
    public static final String PARAMETER_CREATE_SEQUENCE_ATTRIBUTE = "create_sequence_attribute";
    public static final String PARAMETER_SEQUENCE_ATTRIBUTE_NAME = "new_attribute";
    public static final String PARAMETER_SEQUENCE_INCREMENT = "increment";
    public static final String PARAMETER_SEQUENCE_OFFSET = "offset";
    public static final String PARAMETER_NUMBER_OF_EXAMPLES = "number_of_examples";
    private OutputPort exampleSetOutputPort = (OutputPort)this.getOutputPorts().createPort("example set");

    public GenerateSequenceDataOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewExampleSetMDRule(this.exampleSetOutputPort){

            public MetaData modifyMetaData(ExampleSetMetaData metaData) {
                if (GenerateSequenceDataOperator.this.getParameterAsBoolean(GenerateSequenceDataOperator.PARAMETER_CREATE_SEQUENCE_ATTRIBUTE)) {
                    try {
                        metaData.addAttribute(new AttributeMetaData(GenerateSequenceDataOperator.this.getParameterAsString(GenerateSequenceDataOperator.PARAMETER_SEQUENCE_ATTRIBUTE_NAME), 4));
                    }
                    catch (UndefinedParameterError e) {
                        GenerateSequenceDataOperator.this.exampleSetOutputPort.addError((MetaDataError)new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)GenerateSequenceDataOperator.this.exampleSetOutputPort, "toolkit.sequence_attribute_parameter_missing", new Object[0]));
                    }
                }
                return metaData;
            }
        });
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        boolean createSequenceAttribute = this.getParameterAsBoolean(PARAMETER_CREATE_SEQUENCE_ATTRIBUTE);
        String nameOfAttribute = null;
        double increment = this.getParameterAsDouble(PARAMETER_SEQUENCE_INCREMENT);
        double offset = this.getParameterAsDouble(PARAMETER_SEQUENCE_OFFSET);
        String[] attributeNames = new String[]{};
        int[] attributeTypes = new int[]{};
        if (createSequenceAttribute) {
            nameOfAttribute = this.getParameterAsString(PARAMETER_SEQUENCE_ATTRIBUTE_NAME);
            attributeNames = new String[]{nameOfAttribute};
            attributeTypes = new int[]{4};
        }
        ExampleSetCreator creator = new ExampleSetCreator(attributeNames, attributeTypes);
        for (int i = 0; i < this.getParameterAsInt(PARAMETER_NUMBER_OF_EXAMPLES); ++i) {
            if (createSequenceAttribute) {
                creator.setValue(nameOfAttribute, offset);
                offset += increment;
            }
            creator.commit();
        }
        this.exampleSetOutputPort.deliver((IOObject)creator.finish());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_NUMBER_OF_EXAMPLES, "The number of examples of the newly created example set", 0, Integer.MAX_VALUE, false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_CREATE_SEQUENCE_ATTRIBUTE, "Check to create a sequence attribute in the new data set. Otherwise the dataset will be void of any columns, but will have the desired number of rows.", true));
        ParameterTypeString type = new ParameterTypeString(PARAMETER_SEQUENCE_ATTRIBUTE_NAME, "The name of the newly create sequence attribute. No attribute with the same name may exist already.", "SequenceIndex");
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_CREATE_SEQUENCE_ATTRIBUTE, true, true));
        types.add((ParameterType)type);
        type = new ParameterTypeDouble(PARAMETER_SEQUENCE_INCREMENT, "The increment from example to example.", -1.7976931348623157E308, Double.MAX_VALUE, 1.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_CREATE_SEQUENCE_ATTRIBUTE, true, true));
        types.add((ParameterType)type);
        type = new ParameterTypeDouble(PARAMETER_SEQUENCE_OFFSET, "The start value for the first example in the given example set.", -1.7976931348623157E308, Double.MAX_VALUE, 1.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_CREATE_SEQUENCE_ATTRIBUTE, true, true));
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

