/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.data.transformation;

import com.owc.data.exampleset.ExampleComparator;
import com.owc.data.exampleset.SortedExampleSet;
import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.container.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DifferenceOperator
extends LicensedOperator {
    public static final String PARAMETER_KEEP_ATTRIBUTE_ROLES = "keep_attribute_roles";
    private InputPort inputExample = this.getInputPorts().createPort("example set", ExampleSet.class);
    private InputPortExtender inputExtender = new InputPortExtender("example set", (Ports)this.getInputPorts());
    private OutputPort resultSetPort = (OutputPort)this.getOutputPorts().createPort("result set");
    public AttributeSubsetSelector selector = new AttributeSubsetSelector((ParameterHandler)this, this.inputExample);

    public DifferenceOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                MetaData inputMetaData = DifferenceOperator.this.inputExample.getMetaData();
                if (inputMetaData != null) {
                    if (inputMetaData instanceof ExampleSetMetaData) {
                        ExampleSetMetaData esmd = (ExampleSetMetaData)inputMetaData;
                        esmd.removeAllAttributes();
                        for (AttributeMetaData amd : DifferenceOperator.this.selector.getMetaDataSubset(esmd, false).getAllAttributes()) {
                            esmd.addAttribute(amd);
                        }
                    } else {
                        DifferenceOperator.this.inputExample.addError((MetaDataError)new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)DifferenceOperator.this.inputExample, "wrong_metadata", new Object[0]));
                    }
                }
                for (InputPort port : DifferenceOperator.this.inputExtender.getManagedPorts()) {
                    inputMetaData = port.getMetaData();
                    if (inputMetaData == null || inputMetaData instanceof ExampleSetMetaData) continue;
                    DifferenceOperator.this.inputExample.addError((MetaDataError)new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)DifferenceOperator.this.inputExample, "wrong_metadata", new Object[0]));
                }
            }
        });
        this.inputExtender.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.inputExample.getData(ExampleSet.class);
        List exampleSets = this.inputExtender.getData(ExampleSet.class, true);
        boolean keepRoles = this.getParameterAsBoolean(PARAMETER_KEEP_ATTRIBUTE_ROLES);
        Set selectedAttributes = this.selector.getAttributeSubset(exampleSet, false);
        if (selectedAttributes.isEmpty()) {
            throw new UserError((Operator)this, 111);
        }
        Attribute[] selectedAttributesArray = selectedAttributes.toArray(new Attribute[0]);
        for (ExampleSet set : exampleSets) {
            for (int i = 0; i < selectedAttributes.size(); ++i) {
                Object selectedAttribute;
                boolean attributeFound = false;
                Attributes attributes = set.getAttributes();
                Attribute currentAttribute = attributes.get((selectedAttribute = selectedAttributesArray[i]).getName());
                boolean bl = attributeFound = currentAttribute != null;
                if (!attributeFound) {
                    throw new UserError((Operator)this, 160, new Object[]{selectedAttribute.getName()});
                }
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(currentAttribute.getValueType(), selectedAttribute.getValueType()) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(selectedAttribute.getValueType(), currentAttribute.getValueType())) continue;
                throw new UserError((Operator)this, "toolkit.union_incompatible_attribute_types");
            }
        }
        ArrayList<Iterator<Example>> sortedSetIterators = new ArrayList<Iterator<Example>>();
        String[] attributeNames = new String[selectedAttributes.size()];
        int[] attributeTypes = new int[selectedAttributes.size()];
        ArrayList<SortedExampleSet> sortedSetArray = new ArrayList<SortedExampleSet>();
        int i = 0;
        for (Attribute currentAttribute : selectedAttributes) {
            attributeTypes[i] = currentAttribute.getValueType();
            attributeNames[i++] = currentAttribute.getName();
        }
        SortedExampleSet sortedSet = new SortedExampleSet(exampleSet, 1, true, attributeNames);
        if (keepRoles) {
            sortedSetArray.add(sortedSet);
        }
        sortedSetIterators.add(sortedSet.iterator());
        Attribute[][] attributeArray = new Attribute[exampleSets.size() + 1][selectedAttributes.size()];
        int j = 0;
        for (Attribute attribute : selectedAttributes) {
            attributeArray[0][j++] = attribute;
        }
        i = 1;
        for (ExampleSet set : exampleSets) {
            sortedSet = new SortedExampleSet(set, 1, true, attributeNames);
            if (keepRoles) {
                sortedSetArray.add(sortedSet);
            }
            sortedSetIterators.add(sortedSet.iterator());
            Iterator selectedSetAllAttributes = set.getAttributes().allAttributes();
            while (selectedSetAllAttributes.hasNext()) {
                Attribute currentAttribute = (Attribute)selectedSetAllAttributes.next();
                j = 0;
                for (Attribute attribute : selectedAttributes) {
                    if (attribute.getName().equals(currentAttribute.getName())) {
                        attributeArray[i][j] = currentAttribute;
                    }
                    ++j;
                }
            }
            ++i;
        }
        ExampleSetCreator creator = new ExampleSetCreator(attributeNames, attributeTypes, false);
        Example[] selectedExamples = new Example[sortedSetIterators.size()];
        int[] selectedExamplesCounter = new int[sortedSetIterators.size()];
        Arrays.fill(selectedExamplesCounter, -1);
        i = 0;
        for (Iterator iterator : sortedSetIterators) {
            if (iterator.hasNext()) {
                selectedExamples[i] = (Example)iterator.next();
                int n = i;
                selectedExamplesCounter[n] = selectedExamplesCounter[n] + 1;
            }
            ++i;
        }
        Pair comparingDataIndexes = null;
        i = 0;
        for (int currentExamplesCounter : selectedExamplesCounter) {
            if (currentExamplesCounter >= 0) {
                comparingDataIndexes = new Pair((Object)i, (Object)currentExamplesCounter);
                break;
            }
            ++i;
        }
        while (comparingDataIndexes != null) {
            Integer comparingDataIndex;
            void var19_27;
            boolean addEntry = true;
            for (i = 0; i < selectedExamples.length; ++i) {
                if (i == (Integer)comparingDataIndexes.getFirst() || selectedExamples[i] == null || !ExampleComparator.isSmaller(selectedExamples[i], ((ExampleSet)sortedSetArray.get((Integer)comparingDataIndexes.getFirst())).getExample(((Integer)comparingDataIndexes.getSecond()).intValue()), attributeArray[i], attributeArray[(Integer)comparingDataIndexes.getFirst()])) continue;
                comparingDataIndexes.setFirst((Object)i);
                comparingDataIndexes.setSecond((Object)selectedExamplesCounter[i]);
            }
            boolean bl = false;
            while (var19_27 < selectedExamples.length) {
                if (var19_27 != ((Integer)comparingDataIndexes.getFirst()).intValue() && ExampleComparator.isEqual(selectedExamples[var19_27], ((ExampleSet)sortedSetArray.get((Integer)comparingDataIndexes.getFirst())).getExample(((Integer)comparingDataIndexes.getSecond()).intValue()), attributeArray[var19_27], attributeArray[(Integer)comparingDataIndexes.getFirst()])) {
                    addEntry = false;
                    while (ExampleComparator.isEqual(selectedExamples[var19_27], ((ExampleSet)sortedSetArray.get((Integer)comparingDataIndexes.getFirst())).getExample(((Integer)comparingDataIndexes.getSecond()).intValue()), attributeArray[var19_27], attributeArray[(Integer)comparingDataIndexes.getFirst()])) {
                        if (((Iterator)sortedSetIterators.get((int)var19_27)).hasNext()) {
                            selectedExamples[var19_27] = (Example)((Iterator)sortedSetIterators.get((int)var19_27)).next();
                            void v2 = var19_27;
                            selectedExamplesCounter[v2] = selectedExamplesCounter[v2] + 1;
                            continue;
                        }
                        selectedExamples[var19_27] = null;
                        selectedExamplesCounter[var19_27] = -1;
                    }
                }
                ++var19_27;
            }
            if (addEntry) {
                boolean bl2 = false;
                for (Attribute selectedAttribute : selectedAttributes) {
                    void var19_29;
                    Example comparingExample = ((ExampleSet)sortedSetArray.get((Integer)comparingDataIndexes.getFirst())).getExample(((Integer)comparingDataIndexes.getSecond()).intValue());
                    double comparingExampleValue = comparingExample.getValue(attributeArray[(Integer)comparingDataIndexes.getFirst()][var19_29]);
                    if (Double.isNaN(comparingExampleValue)) {
                        creator.setValue(selectedAttribute.getName(), comparingExampleValue);
                    }
                    if (selectedAttribute.isNominal()) {
                        creator.setValue(selectedAttribute.getName(), comparingExample.getNominalValue(attributeArray[(Integer)comparingDataIndexes.getFirst()][var19_29]));
                    } else {
                        creator.setValue(selectedAttribute.getName(), comparingExampleValue);
                    }
                    ++var19_29;
                }
                creator.commit();
            }
            if (((Iterator)sortedSetIterators.get(comparingDataIndex = (Integer)comparingDataIndexes.getFirst())).hasNext()) {
                selectedExamples[comparingDataIndex.intValue()] = (Example)((Iterator)sortedSetIterators.get(comparingDataIndex)).next();
                int n = comparingDataIndex;
                selectedExamplesCounter[n] = selectedExamplesCounter[n] + 1;
            } else {
                selectedExamples[comparingDataIndex.intValue()] = null;
                selectedExamplesCounter[comparingDataIndex.intValue()] = -1;
            }
            comparingDataIndex = -1;
            i = 0;
            for (int currentCounter : selectedExamplesCounter) {
                if (currentCounter >= 0) {
                    comparingDataIndexes.setFirst((Object)i);
                    comparingDataIndexes.setSecond((Object)currentCounter);
                    comparingDataIndex = currentCounter;
                }
                ++i;
            }
            if (comparingDataIndex >= 0) continue;
            comparingDataIndexes = null;
        }
        ExampleSet resultSet = creator.finish();
        if (keepRoles) {
            Attributes resultSetAttributes = resultSet.getAttributes();
            for (i = attributeArray.length; i > 0; --i) {
                void var19_31;
                Attributes currentSetAttributes = ((ExampleSet)sortedSetArray.get(i - 1)).getAttributes();
                boolean bl = false;
                while (var19_31 < attributeArray[i - 1].length) {
                    Attribute currentAttribute = attributeArray[i - 1][var19_31];
                    AttributeRole targetRole = resultSetAttributes.getRole(currentAttribute.getName());
                    AttributeRole newRole = currentSetAttributes.getRole(currentAttribute.getName());
                    if (newRole != null && newRole.isSpecial()) {
                        targetRole.setSpecial(newRole.getSpecialName());
                    }
                    ++var19_31;
                }
            }
        }
        this.resultSetPort.deliver((IOObject)resultSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_KEEP_ATTRIBUTE_ROLES, "If enabled attributes of the resulting set will inherit the special role of the first matching special attribute that is found in the provided sets.", true, false);
        types.add((ParameterType)type);
        types.addAll(this.selector.getParameterTypes());
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

