/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.data.transformation;

import com.owc.data.exampleset.ExampleComparator;
import com.owc.data.exampleset.SortedExampleSet;
import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.OneToOneExtender;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.Ontology;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class IntersectOperator
extends LicensedOperator {
    public static final String PARAMETER_SHOW_ONLY_SELECTED_ATTRIBUTES = "keep_only_selected_attributes";
    public static final String PARAMETER_KEEP_ATTRIBUTE_ROLES = "keep_attribute_roles";
    private InputPort inputExample = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OneToOneExtender oneToOneExtender = new OneToOneExtender("example set", this.getInputPorts(), this.getOutputPorts(), (MetaData)new ExampleSetMetaData());
    private OutputPort resultSetPort = (OutputPort)this.getOutputPorts().createPort("example set output");
    public AttributeSubsetSelector selector = new AttributeSubsetSelector((ParameterHandler)this, this.inputExample);

    public IntersectOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                MetaData inputMetaData = IntersectOperator.this.inputExample.getMetaData();
                if (inputMetaData != null) {
                    if (inputMetaData instanceof ExampleSetMetaData) {
                        ExampleSetMetaData esmd = (ExampleSetMetaData)inputMetaData;
                        if (IntersectOperator.this.getParameterAsBoolean(IntersectOperator.PARAMETER_SHOW_ONLY_SELECTED_ATTRIBUTES)) {
                            esmd.removeAllAttributes();
                            for (AttributeMetaData amd : IntersectOperator.this.selector.getMetaDataSubset(esmd, false).getAllAttributes()) {
                                esmd.addAttribute(amd);
                            }
                            esmd.getNumberOfExamples().reduceByUnknownAmount();
                        }
                        IntersectOperator.this.resultSetPort.deliverMD((MetaData)esmd);
                    } else {
                        IntersectOperator.this.inputExample.addError((MetaDataError)new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)IntersectOperator.this.inputExample, "wrong_metadata", new Object[0]));
                    }
                }
                for (OneToOneExtender.PortPair pair : IntersectOperator.this.oneToOneExtender.getManagedPairs()) {
                    inputMetaData = pair.getInputPort().getMetaData();
                    if (inputMetaData == null) continue;
                    if (inputMetaData instanceof ExampleSetMetaData) {
                        ExampleSetMetaData esmd = (ExampleSetMetaData)inputMetaData;
                        if (IntersectOperator.this.getParameterAsBoolean(IntersectOperator.PARAMETER_SHOW_ONLY_SELECTED_ATTRIBUTES)) {
                            esmd.removeAllAttributes();
                            for (AttributeMetaData amd : IntersectOperator.this.selector.getMetaDataSubset(esmd, false).getAllAttributes()) {
                                esmd.addAttribute(amd);
                            }
                            esmd.getNumberOfExamples().reduceByUnknownAmount();
                        }
                        pair.getOutputPort().deliverMD((MetaData)esmd);
                        continue;
                    }
                    pair.getInputPort().addError((MetaDataError)new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)pair.getInputPort(), "wrong_metadata", new Object[0]));
                }
            }
        });
        this.oneToOneExtender.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        boolean bl;
        ExampleSet inputSet = (ExampleSet)this.inputExample.getData(ExampleSet.class);
        List<ExampleSet> sets = this.oneToOneExtender.getData(ExampleSet.class);
        boolean[] outputPortIsConnected = new boolean[sets.size() + 1];
        OutputPort[] outputPorts = new OutputPort[sets.size() + 1];
        outputPorts[0] = this.resultSetPort;
        outputPortIsConnected[0] = this.resultSetPort.isConnected();
        Iterator<OneToOneExtender.PortPair> managedPorts = this.oneToOneExtender.getManagedPairs().iterator();
        for (int i = 1; i < outputPorts.length; ++i) {
            OutputPort currentOutputPort;
            if (!managedPorts.hasNext()) continue;
            outputPorts[i] = currentOutputPort = managedPorts.next().getOutputPort();
            outputPortIsConnected[i] = currentOutputPort.isConnected();
        }
        Set includedAttributes = this.selector.getAttributeSubset(inputSet, false);
        if (includedAttributes.isEmpty()) {
            throw new UserError((Operator)this, 111);
        }
        String[] includedAttributeNames = new String[includedAttributes.size()];
        int[] includedAttributeTypes = new int[includedAttributes.size()];
        LinkedList<Object> sortedSets = new LinkedList<Object>();
        Iterator attributesIterator = includedAttributes.iterator();
        for (int i = 0; i < includedAttributeNames.length; ++i) {
            if (!attributesIterator.hasNext()) continue;
            Attribute currentAttribute = (Attribute)attributesIterator.next();
            includedAttributeNames[i] = currentAttribute.getName();
            includedAttributeTypes[i] = currentAttribute.getValueType();
        }
        SortedExampleSet sortedInputSet = new SortedExampleSet(inputSet, 1, true, includedAttributeNames);
        sortedSets.add((Object)sortedInputSet);
        int smallestSortedSetIndex = 0;
        int possibleSmallestSetIndex = 0;
        for (ExampleSet exampleSet : sets) {
            Attributes setAttributes = exampleSet.getAttributes();
            for (Attribute attribute : includedAttributes) {
                Attribute selectedAttribute = setAttributes.get(attribute.getName());
                if (selectedAttribute == null) {
                    throw new UserError((Operator)this, "160", new Object[]{attribute.getName()});
                }
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), selectedAttribute.getValueType()) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(selectedAttribute.getValueType(), attribute.getValueType())) continue;
                throw new UserError((Operator)this, "join.illegal_key_attribute", new Object[]{attribute.getName(), inputSet.getName(), attribute.getName(), exampleSet.getName()});
            }
            SortedExampleSet newSortedSet = new SortedExampleSet(exampleSet, 1, true, includedAttributeNames);
            ++possibleSmallestSetIndex;
            if (((SortedExampleSet)((Object)sortedSets.get(smallestSortedSetIndex))).size() > newSortedSet.size()) {
                smallestSortedSetIndex = possibleSmallestSetIndex;
            }
            sortedSets.add((Object)newSortedSet);
        }
        Example[] selectedExamples = new Example[sortedSets.size()];
        ArrayList sortedSetIterators = new ArrayList();
        int i = 0;
        for (ExampleSet exampleSet : sortedSets) {
            Iterator selectedIterator = exampleSet.iterator();
            sortedSetIterators.add(selectedIterator);
            if (selectedIterator != null && selectedIterator.hasNext()) {
                selectedExamples[i] = (Example)selectedIterator.next();
            }
            ++i;
        }
        ExampleSetCreator[] creators = new ExampleSetCreator[sortedSets.size()];
        boolean bl2 = this.getParameterAsBoolean(PARAMETER_SHOW_ONLY_SELECTED_ATTRIBUTES);
        i = 0;
        for (ExampleSet exampleSet : sortedSets) {
            if (bl2) {
                creators[i++] = new ExampleSetCreator(includedAttributeNames, includedAttributeTypes);
                continue;
            }
            creators[i++] = new ExampleSetCreator(exampleSet);
        }
        Attribute[][] selectedAttributes = new Attribute[sortedSets.size()][includedAttributeNames.length];
        boolean bl3 = false;
        boolean attributeAdded = false;
        for (ExampleSet exampleSet : sortedSets) {
            void var21_30;
            Iterator currentSetAttributesIterator = exampleSet.getAttributes().allAttributes();
            while (currentSetAttributesIterator.hasNext()) {
                Attribute attribute = (Attribute)currentSetAttributesIterator.next();
                attributeAdded = false;
                for (i = 0; i < includedAttributeNames.length && !attributeAdded; ++i) {
                    if (!includedAttributeNames[i].equals(attribute.getName())) continue;
                    selectedAttributes[var21_30][i] = attribute;
                    attributeAdded = true;
                }
            }
            ++var21_30;
        }
        boolean bl4 = false;
        while (selectedExamples[smallestSortedSetIndex] != null && !bl) {
            Example comparingExample = selectedExamples[smallestSortedSetIndex];
            i = 0;
            for (Iterator iterator : sortedSetIterators) {
                if (i < selectedExamples.length && i >= 0 && i != smallestSortedSetIndex) {
                    while (selectedExamples[i] != null && comparingExample != null && ExampleComparator.isSmaller(selectedExamples[i], comparingExample, selectedAttributes[i], selectedAttributes[smallestSortedSetIndex])) {
                        if (iterator.hasNext()) {
                            selectedExamples[i] = (Example)iterator.next();
                            continue;
                        }
                        selectedExamples[i] = null;
                    }
                }
                ++i;
            }
            boolean addExamples = true;
            for (i = 0; i < selectedExamples.length; ++i) {
                if (i == smallestSortedSetIndex) continue;
                if (!ExampleComparator.isEqual(selectedExamples[i], comparingExample, selectedAttributes[i], selectedAttributes[smallestSortedSetIndex])) {
                    addExamples = false;
                }
                if (selectedExamples[i] != null || comparingExample != null) continue;
                addExamples = false;
            }
            if (addExamples) {
                for (int j = 0; j < selectedExamples.length; ++j) {
                    Example example = selectedExamples[j];
                    if (!outputPortIsConnected[j] || example == null) continue;
                    ExampleSetCreator exampleSetCreator = creators[j];
                    while (ExampleComparator.isEqual(example, comparingExample, selectedAttributes[j], selectedAttributes[smallestSortedSetIndex])) {
                        if (this.getParameterAsBoolean(PARAMETER_SHOW_ONLY_SELECTED_ATTRIBUTES)) {
                            for (Attribute currentAttribute : selectedAttributes[j]) {
                                if (currentAttribute.isNominal()) {
                                    exampleSetCreator.setValue(currentAttribute.getName(), example.getValueAsString(currentAttribute));
                                    continue;
                                }
                                exampleSetCreator.setValue(currentAttribute.getName(), example.getValue(currentAttribute));
                            }
                        } else {
                            Iterator attributes = example.getAttributes().allAttributes();
                            while (attributes.hasNext()) {
                                Attribute currentAttribute = (Attribute)attributes.next();
                                if (currentAttribute.isNominal()) {
                                    exampleSetCreator.setValue(currentAttribute.getName(), example.getValueAsString(currentAttribute));
                                    continue;
                                }
                                exampleSetCreator.setValue(currentAttribute.getName(), example.getValue(currentAttribute));
                            }
                        }
                        exampleSetCreator.commit();
                        if (((Iterator)sortedSetIterators.get(j)).hasNext()) {
                            selectedExamples[j] = (Example)((Iterator)sortedSetIterators.get(j)).next();
                            example = selectedExamples[j];
                            continue;
                        }
                        selectedExamples[j] = null;
                        example = null;
                        bl = true;
                    }
                }
                continue;
            }
            if (((Iterator)sortedSetIterators.get(smallestSortedSetIndex)).hasNext()) {
                selectedExamples[smallestSortedSetIndex] = (Example)((Iterator)sortedSetIterators.get(smallestSortedSetIndex)).next();
                continue;
            }
            selectedExamples[smallestSortedSetIndex] = null;
            bl = true;
        }
        if (sets.isEmpty()) {
            this.resultSetPort.deliver((IOObject)inputSet);
        } else {
            void var21_33;
            boolean bl5 = false;
            while (var21_33 < outputPorts.length) {
                if (outputPortIsConnected[var21_33]) {
                    ExampleSet resultSet = creators[var21_33].finish();
                    if (this.getParameterAsBoolean(PARAMETER_KEEP_ATTRIBUTE_ROLES)) {
                        Iterator inputSetAttributeRolesIterator = ((SortedExampleSet)((Object)sortedSets.get((int)var21_33))).getAttributes().allAttributeRoles();
                        Attributes attributes = resultSet.getAttributes();
                        while (inputSetAttributeRolesIterator.hasNext()) {
                            if (attributes == null) continue;
                            AttributeRole inputRole = (AttributeRole)inputSetAttributeRolesIterator.next();
                            Attribute resultSetAttribute = attributes.get(inputRole.getAttribute().getName());
                            if (inputRole == null || resultSetAttribute == null) continue;
                            attributes.getRole(resultSetAttribute).setSpecial(inputRole.getSpecialName());
                        }
                    }
                    outputPorts[var21_33].deliver((IOObject)resultSet);
                }
                ++var21_33;
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_SHOW_ONLY_SELECTED_ATTRIBUTES, "If enabled this Operator will deliver the every result set containing only the selected Attributes. Else the examples that build an intersection will keep their original attributes", false, false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_KEEP_ATTRIBUTE_ROLES, "If enabled the output sets will gain the attrubute roles as their respective input sets", true, false);
        types.add((ParameterType)type);
        types.addAll(this.selector.getParameterTypes());
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

