/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.data.transformation;

import com.owc.data.exampleset.ExampleComparator;
import com.owc.data.exampleset.SortedExampleSet;
import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Ontology;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SetMinusOperator
extends LicensedOperator {
    public static final String PARAMETER_KEEP_ATTRIBUTE_ROLES = "keep_attribute_roles";
    private InputPort inputSetPort = this.getInputPorts().createPort("input set", ExampleSet.class);
    private InputPortExtender subtrahendSetsExtender = new InputPortExtender("subtrahend set", (Ports)this.getInputPorts(), (MetaData)new ExampleSetMetaData(), false);
    private OutputPort resultSetPort = (OutputPort)this.getOutputPorts().createPort("result set");
    private OutputPort originalSetPort = (OutputPort)this.getOutputPorts().createPort("original set");
    public AttributeSubsetSelector selector = new AttributeSubsetSelector((ParameterHandler)this, this.inputSetPort);

    public SetMinusOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new ExampleSetPassThroughRule(this.inputSetPort, this.resultSetPort, SetRelation.EQUAL){

            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                metaData.getNumberOfExamples().reduceByUnknownAmount();
                return metaData;
            }
        });
        this.getTransformer().addPassThroughRule(this.inputSetPort, this.originalSetPort);
        this.subtrahendSetsExtender.start();
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        Object sortedSet;
        ExampleSet inputSet = (ExampleSet)this.inputSetPort.getData(ExampleSet.class);
        List subtrahendSets = this.subtrahendSetsExtender.getData(ExampleSet.class, true);
        boolean keepRoles = this.getParameterAsBoolean(PARAMETER_KEEP_ATTRIBUTE_ROLES);
        Attribute[] selectedKeyAttributes = this.selector.getAttributeSubset(inputSet, false).toArray(new Attribute[0]);
        if (selectedKeyAttributes.length == 0) {
            throw new UserError((Operator)this, 111);
        }
        for (ExampleSet subtrahendSet : subtrahendSets) {
            Attributes currentSubtrahendSetAttributes = subtrahendSet.getAttributes();
            for (Attribute selectedAttribute : selectedKeyAttributes) {
                Attribute hasAttribute = currentSubtrahendSetAttributes.get(selectedAttribute.getName());
                if (hasAttribute == null) {
                    throw new UserError((Operator)this, "160", new Object[]{selectedAttribute.getName()});
                }
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(hasAttribute.getValueType(), selectedAttribute.getValueType()) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(selectedAttribute.getValueType(), hasAttribute.getValueType())) continue;
                throw new UserError((Operator)this, "toolkit.set_minus.different_types", new Object[]{selectedAttribute.getName(), subtrahendSet.getName()});
            }
        }
        SortedExampleSet sortedInputSet = new SortedExampleSet(inputSet, 1, true, selectedKeyAttributes);
        String[] includedAttributeNames = new String[selectedKeyAttributes.length];
        int i = 0;
        for (Attribute includedAttribute : selectedKeyAttributes) {
            includedAttributeNames[i++] = includedAttribute.getName();
        }
        boolean attributeAdded = false;
        Attribute[][] selectedAttributes = new Attribute[subtrahendSets.size()][includedAttributeNames.length];
        int v = 0;
        LinkedList<Iterator<Example>> subtrahendIterators = new LinkedList<Iterator<Example>>();
        try {
            for (ExampleSet selectedSubtrahendSet : subtrahendSets) {
                sortedSet = new SortedExampleSet(selectedSubtrahendSet, 1, true, includedAttributeNames);
                Iterator currentSetAttributesIterator = ((SortedExampleSet)((Object)sortedSet)).getAttributes().allAttributes();
                while (currentSetAttributesIterator.hasNext()) {
                    Attribute attribute = (Attribute)currentSetAttributesIterator.next();
                    attributeAdded = false;
                    for (i = 0; i < includedAttributeNames.length && !attributeAdded; ++i) {
                        if (!includedAttributeNames[i].equals(attribute.getName())) continue;
                        selectedAttributes[v][i] = attribute;
                        attributeAdded = true;
                    }
                }
                ++v;
                subtrahendIterators.add(((SortedExampleSet)((Object)sortedSet)).iterator());
            }
        }
        catch (UserError error) {
            error.setOperator((Operator)this);
            throw error;
        }
        Example[] currentSubtrahendExamples = new Example[subtrahendIterators.size()];
        for (i = 0; i < subtrahendIterators.size(); ++i) {
            Iterator currentIterator = (Iterator)subtrahendIterators.get(i);
            if (currentIterator == null || !currentIterator.hasNext()) continue;
            currentSubtrahendExamples[i] = (Example)currentIterator.next();
        }
        ExampleSetCreator creator = new ExampleSetCreator((ExampleSet)sortedInputSet);
        sortedSet = sortedInputSet.iterator();
        while (sortedSet.hasNext()) {
            Example selectedExample = (Example)sortedSet.next();
            boolean addExample = true;
            v = 0;
            for (Iterator iterator : subtrahendIterators) {
                Example currentSubtrahendExample = currentSubtrahendExamples[v];
                if (currentSubtrahendExample != null) {
                    while (ExampleComparator.isSmaller(currentSubtrahendExample, selectedExample, selectedAttributes[v], selectedKeyAttributes) && iterator.hasNext()) {
                        currentSubtrahendExamples[v] = currentSubtrahendExample = (Example)iterator.next();
                    }
                    if (ExampleComparator.isEqual(currentSubtrahendExample, selectedExample, selectedAttributes[v], selectedKeyAttributes)) {
                        addExample = false;
                    }
                }
                ++v;
            }
            if (!addExample) continue;
            creator.setValuesByExample(selectedExample);
            creator.commit();
        }
        ExampleSet resultSet = creator.finish();
        if (keepRoles) {
            Attributes resultSetAttributes = resultSet.getAttributes();
            Attributes inputSetAttributes = inputSet.getAttributes();
            for (Attribute attribute : resultSetAttributes) {
                AttributeRole currentRole = resultSetAttributes.getRole(attribute.getName());
                AttributeRole newRole = inputSetAttributes.getRole(attribute.getName());
                if (newRole == null || !newRole.isSpecial()) continue;
                currentRole.setSpecial(newRole.getSpecialName());
            }
        }
        this.resultSetPort.deliver((IOObject)resultSet);
        this.originalSetPort.deliver((IOObject)inputSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_KEEP_ATTRIBUTE_ROLES, "If enabled attributes of the resulting set will inherit the special role of the first matching special attribute that is found in the provided sets.", true, false);
        types.add((ParameterType)type);
        types.addAll(this.selector.getParameterTypes());
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

