/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.data.transformation;

import com.owc.license.ProductInformation;
import com.owc.metadata.UnionExampleSetsRule;
import com.owc.operator.LicensedOperator;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.container.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class UnionOperator
extends LicensedOperator {
    public static final String PARAMETER_FAIL_ON_DIFFERENT_TYPES = "fail_on_different_types";
    public static final String PARAMETER_ATTRIBUTE_NAME_SUFFIX = "attribute_name_suffix";
    private OutputPort exampleSetOutputport = (OutputPort)this.getOutputPorts().createPort("result set");
    private InputPortExtender inputPortExtender = new InputPortExtender("example set", (Ports)this.getInputPorts(), (MetaData)new ExampleSetMetaData(), false);

    public UnionOperator(OperatorDescription description) {
        super(description);
        this.inputPortExtender.start();
        this.getTransformer().addRule((MDTransformationRule)new UnionExampleSetsRule(this, PARAMETER_ATTRIBUTE_NAME_SUFFIX, PARAMETER_FAIL_ON_DIFFERENT_TYPES, this.inputPortExtender, this.exampleSetOutputport, new InputPort[0]));
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        int i;
        List sets = this.inputPortExtender.getData(ExampleSet.class, true);
        HashMap<String, LinkedHashSet<String>> renamedNamesMappedToOriginalNames = new HashMap<String, LinkedHashSet<String>>();
        HashMap<String, Pair> mappedAttributes = new HashMap<String, Pair>();
        LinkedList<String> attributeNamesList = new LinkedList<String>();
        LinkedList<Integer> attributeTypesList = new LinkedList<Integer>();
        LinkedList<Boolean> attributeIsNumeric = new LinkedList<Boolean>();
        boolean addAttribute = false;
        for (ExampleSet exampleSet : sets) {
            Attributes setAttributes = exampleSet.getAttributes();
            Iterator setAttributesIterator = setAttributes.allAttributes();
            while (setAttributesIterator.hasNext()) {
                Attribute attribute = (Attribute)setAttributesIterator.next();
                addAttribute = true;
                String selectedAttributeName = attribute.getName();
                if (mappedAttributes.containsKey(attribute.getName())) {
                    addAttribute = false;
                    int mappedType = ((Attribute)((Pair)mappedAttributes.get(attribute.getName())).getFirst()).getValueType();
                    if (mappedType != attribute.getValueType()) {
                        if (this.getParameterAsBoolean(PARAMETER_FAIL_ON_DIFFERENT_TYPES)) {
                            throw new UserError((Operator)this, "toolkit.union_incompatible_attribute_types");
                        }
                        String suffix = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME_SUFFIX);
                        if (suffix == null) {
                            throw new UserError((Operator)this, "toolkit.union_missing_suffix");
                        }
                        int suffixNumber = 1;
                        selectedAttributeName = attribute.getName() + suffix + suffixNumber;
                        ++suffixNumber;
                        addAttribute = true;
                        LinkedHashSet currentRenames = (LinkedHashSet)renamedNamesMappedToOriginalNames.get(attribute.getName());
                        for (String currentRename : currentRenames) {
                            if (((Attribute)((Pair)mappedAttributes.get(currentRename)).getFirst()).getValueType() != attribute.getValueType()) continue;
                            addAttribute = false;
                        }
                        if (addAttribute) {
                            while (mappedAttributes.get(selectedAttributeName) != null) {
                                selectedAttributeName = attribute.getName() + suffix + suffixNumber;
                                ++suffixNumber;
                            }
                        }
                    }
                }
                if (!addAttribute) continue;
                Attribute selectedAttribute = attribute;
                AttributeRole role = setAttributes.getRole(selectedAttribute);
                mappedAttributes.put(selectedAttributeName, new Pair((Object)selectedAttribute, (Object)role));
                LinkedHashSet<String> renamedNames = (LinkedHashSet<String>)renamedNamesMappedToOriginalNames.get(attribute.getName());
                if (renamedNames == null) {
                    renamedNames = new LinkedHashSet<String>();
                }
                renamedNames.add(selectedAttributeName);
                renamedNamesMappedToOriginalNames.put(selectedAttributeName, renamedNames);
                if (attribute.isNominal()) {
                    attributeTypesList.add(attribute.getValueType());
                    attributeNamesList.add(selectedAttributeName);
                    attributeIsNumeric.add(false);
                    continue;
                }
                attributeTypesList.add(attribute.getValueType());
                attributeNamesList.add(selectedAttributeName);
                attributeIsNumeric.add(true);
            }
        }
        String[] attributeNames = attributeNamesList.toArray(new String[0]);
        int[] attributeTypes = new int[attributeTypesList.size()];
        for (i = 0; !attributeTypesList.isEmpty() && i < attributeTypes.length; ++i) {
            attributeTypes[i] = (Integer)attributeTypesList.poll();
        }
        ExampleSetCreator creator = new ExampleSetCreator(attributeNames, attributeTypes, false);
        for (ExampleSet exampleSet : sets) {
            for (Example example : exampleSet) {
                Iterator namesIterator = attributeNamesList.iterator();
                Iterator isNumericIterator = attributeIsNumeric.iterator();
                i = 0;
                while (namesIterator.hasNext()) {
                    String selectedAttributeName = (String)namesIterator.next();
                    boolean isNumeric = (Boolean)isNumericIterator.next();
                    Attribute selectedSetAttribute = exampleSet.getAttributes().get(((Attribute)((Pair)mappedAttributes.get(selectedAttributeName)).getFirst()).getName());
                    if (selectedSetAttribute != null && selectedSetAttribute.getValueType() == attributeTypes[i]) {
                        Double value;
                        if (!isNumeric) {
                            value = example.getValue(selectedSetAttribute);
                            if (!Double.isNaN(value)) {
                                creator.setValue(selectedAttributeName, example.getValueAsString(selectedSetAttribute));
                            }
                        } else {
                            value = example.getValue(selectedSetAttribute);
                            if (!Double.isNaN(value)) {
                                creator.setValue(selectedAttributeName, value);
                            }
                        }
                    }
                    ++i;
                }
                creator.commit();
            }
        }
        ExampleSet resultSet = creator.finish();
        Attributes resultAttributes = resultSet.getAttributes();
        for (Attribute selectedAttribute : resultAttributes) {
            AttributeRole selectedAttributeRole = (AttributeRole)((Pair)mappedAttributes.get(selectedAttribute.getName())).getSecond();
            if (selectedAttributeRole == null) continue;
            resultAttributes.getRole(selectedAttribute).setSpecial(selectedAttributeRole.getSpecialName());
        }
        this.exampleSetOutputport.deliver((IOObject)resultSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_FAIL_ON_DIFFERENT_TYPES, "Duplicate Attributes with diffrent types will create an error message if this Parameter is enabled. If disabled the duplicate attributename will be extended by the provided suffix String and added to the result set.", true, false);
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME_SUFFIX, "If an Attribute occurs multiple times with a diffrent type, a new attribute will be created with the name extended by the provided suffix.", "copy", false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_FAIL_ON_DIFFERENT_TYPES, true, false));
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

