/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.graph;

import com.owc.license.ProductInformation;
import com.owc.objects.TreeGraphObject;
import com.owc.operator.LicensedOperator;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeRegexp;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.repository.BlobEntry;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.OperatorService;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ExtractTreeFromRepositoryOperator
extends LicensedOperator {
    public static final String PARAMETER_DIRECTORY = "repository_folder";
    public static final String PARAMETER_PROCESS_FILES = "include_binary_files";
    public static final String PARAMETER_PROCESS_IO_OBJECTS = "include_objects";
    public static final String PARAMETER_PROCESS_PROCESSES = "include_processes";
    public static final String PARAMETER_PROCESS_EMPTY_FOLDERS = "include_empty_folders";
    public static final String PARAMETER_ENABLE_OBJECT_TYPE_FILTER = "enable_object_type_filter";
    public static final String PARAMETER_LIST_OBJECT_TYPE_FILTER_LIST = "filter_list";
    public static final String PARAMETER_OBJECT_TYPE = "object_type";
    public static final String PARAMETER_OBJECT_TYPE_INCLUDED = "include";
    public static final String PARAMETER_FILTER_ENTRY_NAME = "filter_for_entry_name";
    public static final String PARAMETER_FILTER_ENTRY_PATH = "filter_for_entry_path";
    private OutputPort treeOutputPort = (OutputPort)this.getOutputPorts().createPort("tree_output");

    public ExtractTreeFromRepositoryOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addGenerationRule(this.treeOutputPort, TreeGraphObject.class);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        try {
            TreeGraphObject tree;
            RepositoryLocation startLocation = this.getParameterAsRepositoryLocation(PARAMETER_DIRECTORY);
            Entry startEntry = startLocation.locateEntry();
            if (startEntry instanceof Folder) {
                Folder folder = (Folder)startEntry;
                tree = new TreeGraphObject(folder.getName(), null);
                boolean includeEmptyFolders = this.getParameterAsBoolean(PARAMETER_PROCESS_EMPTY_FOLDERS);
                if (!this.safeRepositoryInTree(tree, tree.getRoot(), folder, includeEmptyFolders)) {
                    throw new UserError((Operator)this, "toolkit.empty_repository", new Object[]{this.getParameterAsString(PARAMETER_DIRECTORY)});
                }
            } else {
                tree = new TreeGraphObject("Extract Tree from Repository", null);
                this.addEntriesToTree(Collections.singleton((DataEntry)startEntry).iterator(), tree, tree.getRoot());
            }
            this.treeOutputPort.deliver((IOObject)tree);
        }
        catch (RepositoryException e) {
            throw new OperatorException("Error while accessing repository.", (Throwable)e);
        }
        catch (UndefinedParameterError e) {
            throw new OperatorException("Undefined Parameter", (Throwable)e);
        }
    }

    private boolean safeRepositoryInTree(TreeGraphObject tree, TreeGraphObject.Node parent, Folder folder, boolean includeEmptyFolder) throws RepositoryException, UndefinedParameterError {
        boolean hasEntries = false;
        boolean hasEntriesSub = false;
        for (Folder nextFolder : folder.getSubfolders()) {
            TreeGraphObject.Node nextFolderNode = new TreeGraphObject.Node(nextFolder.getLocation().getAbsoluteLocation().hashCode(), nextFolder.getName(), null);
            hasEntriesSub = this.safeRepositoryInTree(tree, nextFolderNode, nextFolder, includeEmptyFolder);
            if (!includeEmptyFolder && !hasEntriesSub) continue;
            tree.addNode(nextFolderNode);
            tree.addRelation(parent, nextFolderNode);
            hasEntries = true;
        }
        Iterator<DataEntry> dataIterator = folder.getDataEntries().iterator();
        if (dataIterator != null && dataIterator.hasNext() && this.addEntriesToTree(dataIterator, tree, parent)) {
            hasEntries = true;
        }
        return hasEntries;
    }

    private boolean addEntriesToTree(Iterator<DataEntry> dataIterator, TreeGraphObject tree, TreeGraphObject.Node parent) throws UndefinedParameterError {
        boolean hasEntries = false;
        if (dataIterator != null && tree != null) {
            while (dataIterator.hasNext()) {
                DataEntry nextData = dataIterator.next();
                if (!this.filterNamePattern((Entry)nextData) || !this.filterDataType((Entry)nextData)) continue;
                TreeGraphObject.Node dataNode = new TreeGraphObject.Node(nextData.getLocation().getAbsoluteLocation().hashCode(), nextData.getName(), null);
                tree.addNode(dataNode);
                tree.addRelation(parent, dataNode);
                hasEntries = true;
            }
        }
        return hasEntries;
    }

    private boolean filterDataType(Entry entry) throws UndefinedParameterError {
        if (entry instanceof IOObjectEntry) {
            if (this.getParameterAsBoolean(PARAMETER_PROCESS_IO_OBJECTS)) {
                if (this.getParameterAsBoolean(PARAMETER_ENABLE_OBJECT_TYPE_FILTER)) {
                    String[] parameterList;
                    IOObjectEntry objectEntry = (IOObjectEntry)entry;
                    Class objectClass = objectEntry.getObjectClass();
                    for (String value : parameterList = ParameterTypeEnumeration.transformString2Enumeration((String)this.getParameterAsString(PARAMETER_LIST_OBJECT_TYPE_FILTER_LIST))) {
                        Class selectedClass = OperatorService.getIOObjectClass((String)value);
                        if (selectedClass == null || !selectedClass.isAssignableFrom(objectClass)) continue;
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
        if (entry instanceof BlobEntry) {
            return this.getParameterAsBoolean(PARAMETER_PROCESS_FILES);
        }
        if (entry instanceof ProcessEntry) {
            return this.getParameterAsBoolean(PARAMETER_PROCESS_PROCESSES);
        }
        return false;
    }

    private boolean filterNamePattern(Entry entry) throws UndefinedParameterError {
        String nameRegex = this.getParameterAsString(PARAMETER_FILTER_ENTRY_NAME);
        String pathRegex = this.getParameterAsString(PARAMETER_FILTER_ENTRY_PATH);
        if (nameRegex == null && pathRegex == null) {
            return true;
        }
        if (nameRegex == null) {
            return entry.getLocation().getAbsoluteLocation().matches(pathRegex);
        }
        if (pathRegex == null) {
            return entry.getName().matches(nameRegex);
        }
        return entry.getName().matches(nameRegex) && entry.getLocation().getAbsoluteLocation().matches(pathRegex);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeRepositoryLocation type = new ParameterTypeRepositoryLocation(PARAMETER_DIRECTORY, "Folder in the repository to iterate over", false, true, true, false);
        type.setExpert(false);
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeRegexp(PARAMETER_FILTER_ENTRY_NAME, "The name of each entry is matched against this regular expression. It will be processed only if the regular expression given here matches the name. Leave empty for no filtering.", true));
        types.add((ParameterType)new ParameterTypeRegexp(PARAMETER_FILTER_ENTRY_PATH, "The full path including folder and name of each entry is matched against this regular expression. The entry will only be processed only the regular expression given here matches. Leave empty for no filtering.", true));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_PROCESS_IO_OBJECTS, "If checked the inner process will be executed for every object saved in the folders.", true));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_PROCESS_FILES, "If checked the inner process will be executed for every binary file saved in the folders.", true));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_PROCESS_PROCESSES, "If checked the inner process will be executed for every process saved in the folders.", true));
        String[] ioObjects = OperatorService.getIOObjectsNames().toArray(new String[0]);
        LinkedList<String[]> ioObjectsDefaultList = new LinkedList<String[]>();
        for (String objectClass : ioObjects) {
            ioObjectsDefaultList.add(new String[]{objectClass, "false"});
        }
        type = new ParameterTypeBoolean(PARAMETER_ENABLE_OBJECT_TYPE_FILTER, "If checked, you can select which classes of IO Objects you want to process.", false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_PROCESS_IO_OBJECTS, false, true));
        types.add((ParameterType)type);
        type = new ParameterTypeEnumeration(PARAMETER_LIST_OBJECT_TYPE_FILTER_LIST, "Here you can select whether to process single io object classes.", (ParameterType)new ParameterTypeStringCategory(PARAMETER_OBJECT_TYPE, "The type of the object to which this filtering applies.", ioObjects));
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_OBJECT_TYPE_FILTER, false, true));
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_PROCESS_EMPTY_FOLDERS, "If checked, empty folders will be added to the Tree as a node.", false);
        types.add((ParameterType)type);
        for (ParameterType currentType : types) {
            currentType.setExpert(false);
        }
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

