/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.graph;

import com.owc.license.ProductInformation;
import com.owc.objects.TreeGraphObject;
import com.owc.operator.LicensedOperator;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeRegexp;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.LinkedList;
import java.util.List;

public class SelectDescendantsOperator
extends LicensedOperator {
    public static final String PARAMETER_SELECTED_NODE_ID = "selected_node_id";
    public static final String PARAMETER_SHOW_ONLY_IMMEDIATE_DESCENDANTS = "show_only_immediate_descendants";
    public static final String PARAMETER_USE_NAME_FILTER = "use_name_filter";
    public static final String PARAMETER_FILTER_ENTRY_NAME = "filter_for_entry_name";
    public static final String[] attributeNames = new String[]{"Id", "Name", "Level", "Level diffrence"};
    public static final int[] attributeTypes = new int[]{3, 7, 3, 3};
    private InputPort treeInputPort = this.getInputPorts().createPort("tree_input", TreeGraphObject.class);
    private OutputPort exampleOutputPort = (OutputPort)this.getOutputPorts().createPort("exampleSet");
    private OutputPort treeOutputPort = (OutputPort)this.getOutputPorts().createPort("descendant tree");
    private OutputPort originalTreePort = (OutputPort)this.getOutputPorts().createPort("tree through port");

    public SelectDescendantsOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addGenerationRule(this.exampleOutputPort, ExampleSet.class);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        TreeGraphObject tree = (TreeGraphObject)this.treeInputPort.getData(TreeGraphObject.class);
        TreeGraphObject.Node selectedNode = tree.getNode(this.getParameterAsInt(PARAMETER_SELECTED_NODE_ID));
        if (selectedNode == null) {
            throw new UserError((Operator)this, "No node with the provided id could be found.");
        }
        ExampleSetCreator creator = new ExampleSetCreator(attributeNames, attributeTypes);
        LinkedList<TreeGraphObject.Node> children = new LinkedList<TreeGraphObject.Node>();
        LinkedList<TreeGraphObject.Node> unprocessedChildren = new LinkedList<TreeGraphObject.Node>();
        TreeGraphObject descendantTree = new TreeGraphObject(selectedNode.copy(), null);
        children.add(descendantTree.getRoot());
        unprocessedChildren.addAll(descendantTree.getChildren(descendantTree.getRoot()));
        while (!unprocessedChildren.isEmpty()) {
            TreeGraphObject.Node child = (TreeGraphObject.Node)unprocessedChildren.pollFirst();
            if (!this.getParameterAsBoolean(PARAMETER_SHOW_ONLY_IMMEDIATE_DESCENDANTS)) {
                unprocessedChildren.addAll(descendantTree.getChildren(child));
            } else {
                for (TreeGraphObject.Node rootChild : descendantTree.getChildren(descendantTree.getRoot())) {
                    rootChild.removeAllChildren();
                }
            }
            if (!this.getParameterAsBoolean(PARAMETER_USE_NAME_FILTER)) {
                children.add(child);
                continue;
            }
            if (this.filterNamePattern(child.name)) {
                children.add(child);
                continue;
            }
            TreeGraphObject.Node parent = child.getParent();
            if (parent == null) continue;
            parent.remove(child);
        }
        for (TreeGraphObject.Node child : children) {
            int childId = child.id;
            String childName = child.name;
            int childLevel = child.getLevel();
            int levelDiffrence = childLevel - descendantTree.getRoot().getLevel();
            creator.setValue(attributeNames[0], childId);
            if (childName != null) {
                creator.setValue(attributeNames[1], childName);
            }
            creator.setValue(attributeNames[2], childLevel);
            creator.setValue(attributeNames[3], levelDiffrence);
            creator.commit();
        }
        this.treeOutputPort.deliver((IOObject)descendantTree);
        this.exampleOutputPort.deliver((IOObject)creator.finish());
        this.originalTreePort.deliver((IOObject)tree);
    }

    private boolean filterNamePattern(String name) throws UndefinedParameterError {
        String nameRegex = this.getParameterAsString(PARAMETER_FILTER_ENTRY_NAME);
        if (nameRegex == null) {
            return true;
        }
        if (name == null) {
            return false;
        }
        return name.matches(nameRegex);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_SELECTED_NODE_ID, "The id of the node from which the successors are supposed to be delivered", Integer.MIN_VALUE, Integer.MAX_VALUE, false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_SHOW_ONLY_IMMEDIATE_DESCENDANTS, "If this is enabled, only the immediate descendants, hence the direct children of this node, will be listed.", false, false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_USE_NAME_FILTER, "This allows you to enter a regular expression against which the node names will be matched.", false, true);
        types.add((ParameterType)type);
        type = new ParameterTypeRegexp(PARAMETER_FILTER_ENTRY_NAME, "Every child node name will be matched to this expression.", true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_NAME_FILTER, false, true));
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

