/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.io;

import com.owc.operator.io.MatLabResultSetFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.nio.model.DataResultSet;
import com.rapidminer.operator.nio.model.ParseException;
import com.rapidminer.tools.ProgressListener;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Date;

public class MatLabResultSet
implements DataResultSet {
    private int numberOfRows;
    private int numberOfColumns;
    private int valueType;
    private double[][] matrix;
    private int currentRow = 0;
    String name;

    public MatLabResultSet(MatLabResultSetFactory matLabResultSetFactory, Operator operator) throws IOException {
        this.readVersion4(matLabResultSetFactory.getResourceName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readVersion4(String resourceName) throws IOException {
        try (RandomAccessFile file = new RandomAccessFile(resourceName, "r");){
            byte[] byteBuffer;
            int pFlag;
            int header1 = Integer.reverseBytes(file.readInt());
            int mFlag = header1 / 1000;
            if (mFlag > 1) {
                throw new IOException("Only Little and Big Endian encoded files supported");
            }
            boolean littleEndian = mFlag == 0;
            int dataType = pFlag = header1 % 100 / 10;
            int tFlag = header1 % 10;
            if (tFlag != 0) {
                throw new IOException("Only dense numerical matrices are supported");
            }
            this.numberOfRows = Integer.reverseBytes(file.readInt());
            this.numberOfColumns = Integer.reverseBytes(file.readInt());
            int header4 = Integer.reverseBytes(file.readInt());
            boolean hasImaginaryPart = header4 == 1;
            int nameLength = Integer.reverseBytes(file.readInt());
            byte[] bs = new byte[nameLength];
            file.read(bs);
            this.name = new String(bs, 0, bs.length - 1, Charset.forName("ASCII"));
            this.matrix = new double[this.numberOfColumns][this.numberOfRows];
            switch (dataType) {
                case 0: {
                    byteBuffer = new byte[8];
                    this.valueType = 4;
                    break;
                }
                case 1: {
                    byteBuffer = new byte[4];
                    this.valueType = 4;
                    break;
                }
                case 2: {
                    byteBuffer = new byte[4];
                    this.valueType = 3;
                    break;
                }
                case 3: {
                    byteBuffer = new byte[2];
                    this.valueType = 3;
                    break;
                }
                case 4: {
                    byteBuffer = new byte[2];
                    this.valueType = 3;
                    break;
                }
                default: {
                    byteBuffer = new byte[1];
                    this.valueType = 3;
                }
            }
            for (int x = 0; x < this.numberOfColumns; ++x) {
                block18: for (int y = 0; y < this.numberOfRows; ++y) {
                    file.read(byteBuffer);
                    ByteBuffer buffer = ByteBuffer.wrap(byteBuffer).order(littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                    switch (dataType) {
                        case 0: {
                            this.matrix[x][y] = buffer.getDouble();
                            continue block18;
                        }
                        case 1: {
                            this.matrix[x][y] = buffer.getFloat();
                            continue block18;
                        }
                        case 2: {
                            this.matrix[x][y] = buffer.getInt();
                            continue block18;
                        }
                        case 3: {
                            this.matrix[x][y] = buffer.getShort();
                            continue block18;
                        }
                        case 4: {
                            this.matrix[x][y] = buffer.getShort() & 0xFFFF;
                            continue block18;
                        }
                        default: {
                            this.matrix[x][y] = buffer.get() & 0xFF;
                        }
                    }
                }
            }
        }
    }

    public boolean hasNext() {
        return this.currentRow + 1 < this.numberOfRows;
    }

    public void next(ProgressListener listener) throws OperatorException {
        ++this.currentRow;
        if (listener != null) {
            listener.setCompleted(this.currentRow);
        }
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public String[] getColumnNames() {
        String[] columnNames = new String[this.numberOfColumns];
        for (int i = 0; i < this.numberOfColumns; ++i) {
            columnNames[i] = this.name + "_" + (i + 1);
        }
        return columnNames;
    }

    public boolean isMissing(int columnIndex) {
        return false;
    }

    public Number getNumber(int columnIndex) throws ParseException {
        return this.matrix[columnIndex][this.currentRow];
    }

    public String getString(int columnIndex) throws ParseException {
        return null;
    }

    public Date getDate(int columnIndex) throws ParseException {
        return null;
    }

    public DataResultSet.ValueType getNativeValueType(int columnIndex) throws ParseException {
        return DataResultSet.ValueType.NUMBER;
    }

    public void close() throws OperatorException {
    }

    public void reset(ProgressListener listener) throws OperatorException {
        if (listener != null) {
            listener.setTotal(this.numberOfRows);
        }
        this.currentRow = 0;
    }

    public int[] getValueTypes() {
        int[] valueTypes = new int[this.numberOfColumns];
        for (int i = 0; i < this.numberOfColumns; ++i) {
            valueTypes[i] = this.valueType;
        }
        return valueTypes;
    }

    public int getCurrentRow() {
        return this.currentRow;
    }
}

