/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.io;

import com.owc.license.ProductInformation;
import com.owc.objects.files.RemoteFileObject;
import com.owc.operator.LicensedOperator;
import com.owc.tools.files.remote.RemoteFileSystemOperations;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.owc.tools.files.remote.configuration.RemoteFileConnectionConfigurable;
import com.owc.tools.files.remote.tasks.MoveRemoteFileCheck;
import com.owc.vfs2.impl.AdvancedVFS;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeLong;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.config.ConfigurationException;
import com.rapidminer.tools.config.ConfigurationManager;
import com.rapidminer.tools.config.ParameterTypeConfigurable;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;

public class MoveRemoteFileOperator
extends LicensedOperator {
    public final OutputPort fileOutput = (OutputPort)this.getOutputPorts().createPort("file");
    public final PortPairExtender throughPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());
    public final String PARAMETER_CONNECTION = "connection";
    public final String PARAMETER_FILE_PATH = "file_path";
    public final String PARAMETER_STAY_IN_SAME_FILESYSTEM = "move_within_same_filesystem";
    public final String PARAMETER_DESTINATION_CONNECTION = "connection_of_targeted_remote_filesytem";
    public final String PARAMETER_TARGETED_LOCATION = "destination_path";
    public final String PARAMETER_OVERWRITE_EXISTING_ENTRY = "overwrite_existing_entry";
    public final String PARAMETER_NUMBER_OF_RETRIES = "number_of_retries";
    public static final String PARAMETER_DELAY_BEFORE_RETRIES = "delay";

    public MoveRemoteFileOperator(OperatorDescription description) {
        super(description);
        this.throughPorts.start();
        this.getTransformer().addRule(this.throughPorts.makePassThroughRule());
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        FileSystemOptions options;
        String rootFilePath;
        RemoteFileConnectionConfigurable config = null;
        String configurableName = this.getParameter("connection");
        boolean overWrite = this.getParameterAsBoolean("overwrite_existing_entry");
        boolean stayInFileSystem = this.getParameterAsBoolean("move_within_same_filesystem");
        int numberOfRetries = this.getParameterAsInt("number_of_retries");
        long delay = this.getParameterAsLong(PARAMETER_DELAY_BEFORE_RETRIES);
        if (configurableName == null || configurableName.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{"connection", ""});
        }
        try {
            config = (RemoteFileConnectionConfigurable)ConfigurationManager.getInstance().lookup("RemoteFileConnection", configurableName, this.getProcess().getRepositoryAccessor());
            if (config == null) {
                throw new UserError((Operator)this, "toolkit.remote_files.retrieve_configurable");
            }
        }
        catch (ConfigurationException e) {
            throw new UserError((Operator)this, "toolkit.remote_files.retrieve_configurable");
        }
        String selectedFilePath = this.getParameter("file_path");
        if (selectedFilePath == null || selectedFilePath.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{"file_path"});
        }
        try {
            rootFilePath = config.getVfsUri();
        }
        catch (UserError ue) {
            ue.setOperator((Operator)this);
            throw ue;
        }
        selectedFilePath = rootFilePath + selectedFilePath;
        String tempNewFilePath = this.getParameter("destination_path");
        if (tempNewFilePath == null) {
            tempNewFilePath = "";
        }
        FileSystemManager manager = null;
        try {
            manager = AdvancedVFS.getManager();
        }
        catch (FileSystemException e) {
            throw new UserError((Operator)this, (Throwable)e, "toolkit.remote_files.file_system_manager_fail", new Object[]{e.getMessage()});
        }
        try {
            options = config.getVfsOptions();
        }
        catch (UserError ue) {
            ue.setOperator((Operator)this);
            throw ue;
        }
        FileSystemOptions targetedOptions = null;
        if (stayInFileSystem) {
            tempNewFilePath = rootFilePath + tempNewFilePath;
            targetedOptions = options;
        } else {
            String targetedConfigurableName = this.getParameter("connection_of_targeted_remote_filesytem");
            if (targetedConfigurableName == null || targetedConfigurableName.isEmpty()) {
                throw new UserError((Operator)this, 205, new Object[]{"connection_of_targeted_remote_filesytem", ""});
            }
            RemoteFileConnectionConfigurable targetedConfig = null;
            try {
                targetedConfig = (RemoteFileConnectionConfigurable)ConfigurationManager.getInstance().lookup("RemoteFileConnection", targetedConfigurableName, null);
                if (targetedConfig == null) {
                    throw new UserError((Operator)this, "toolkit.remote_files.retrieve_configurable", new Object[]{targetedConfigurableName});
                }
            }
            catch (ConfigurationException e) {
                throw new UserError((Operator)this, "toolkit.remote_files.retrieve_configurable", new Object[]{targetedConfigurableName});
            }
            try {
                targetedOptions = targetedConfig.getVfsOptions();
                tempNewFilePath = targetedConfig.getVfsUri() + tempNewFilePath;
            }
            catch (UserError ue) {
                ue.setOperator((Operator)this);
                throw ue;
            }
        }
        MoveRemoteFileCheck moveFile = new MoveRemoteFileCheck(manager, selectedFilePath, tempNewFilePath, options, targetedOptions, overWrite);
        try {
            RemoteFileSystemOperations.getInstance().performRemoteFileSystemCheck(this, moveFile, delay, numberOfRetries, null);
        }
        catch (RemoteFileSystemTaskFailedException e1) {
            throw e1.getUserError();
        }
        FileObject file = moveFile.getResultingFile();
        RemoteFileObject remoteFileObject = new RemoteFileObject(file, file.getName().getBaseName(), numberOfRetries, delay);
        this.addAnnotation(remoteFileObject, numberOfRetries);
        this.fileOutput.deliver((IOObject)remoteFileObject);
        this.throughPorts.passDataThrough();
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeConfigurable type = new ParameterTypeConfigurable("connection", "Select the targeted remote Filesystem which contains your file.", "RemoteFileConnection");
        type.setOptional(false);
        types.add((ParameterType)type);
        type = new ParameterTypeString("file_path", "Relative path starting from the root directory.", false, false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean("move_within_same_filesystem", "If this Operator is supposed to move the selected file to a new filesystem, additional Information will be required.", true, false);
        types.add((ParameterType)type);
        type = new ParameterTypeConfigurable("connection_of_targeted_remote_filesytem", "Please select a connection for the targeted Remote Filesystem, where the selected Remote File will be moved to.", "RemoteFileConnection");
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, "move_within_same_filesystem", true, false));
        types.add((ParameterType)type);
        type = new ParameterTypeString("destination_path", "Please provide a new directory into which the targeted file or folder will be copied to.", true, false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean("overwrite_existing_entry", "If in the targeted new location a file or folder with the same name already exists, this Operator will overwrite them if this option is enabled. Otherwise an error will be returned.", true, false);
        types.add((ParameterType)type);
        type = new ParameterTypeInt("number_of_retries", "Defines how many times RemoteFileSystem operations may repeatedly fail before they will be declared as failed operation.", 0, Integer.MAX_VALUE, 5, false);
        type.setOptional(false);
        types.add((ParameterType)type);
        type = new ParameterTypeLong(PARAMETER_DELAY_BEFORE_RETRIES, "Defines the delay in milliseconds before a failed operation on a remote filesystem will be retried.(Takes effect if Parameter for the number of retries is higher than 0).", 0L, Long.MAX_VALUE, 0L);
        type.setOptional(false);
        types.add((ParameterType)type);
        return types;
    }

    private void addAnnotation(RemoteFileObject remoteFileObject, int maxTry) throws OperatorException {
        Annotations annotations = remoteFileObject.getAnnotations();
        annotations.setAnnotation("Filename", remoteFileObject.getFilename());
        annotations.setAnnotation("Source", remoteFileObject.getSource());
    }
}

