/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.io;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryManager;
import java.util.List;

public class StoreResultOperator
extends AbstractWriter<IOObject> {
    public static final String PARAMETER_RESULT_NAME = "result_name";

    public StoreResultOperator(OperatorDescription description) {
        super(description, IOObject.class);
    }

    public IOObject write(IOObject ioobject) throws OperatorException {
        RepositoryLocation repositoryLocation = this.getProcess().getRepositoryLocation();
        if (repositoryLocation == null) {
            throw new UserError((Operator)this, 317, new Object[]{this.getParameterAsString(PARAMETER_RESULT_NAME)});
        }
        if (!repositoryLocation.getPath().contains("/processes/")) {
            throw new UserError((Operator)this, "toolkit.process_not_in_project_layout");
        }
        String path = repositoryLocation.getPath().replaceAll("/processes/", "/results/");
        try {
            RepositoryLocation location = RepositoryLocation.getRepositoryLocation((String)(path + "/" + this.getParameterAsString(PARAMETER_RESULT_NAME)), (Operator)this);
            return RepositoryManager.getInstance(null).store(ioobject, location, (Operator)this);
        }
        catch (RepositoryException e) {
            throw new UserError((Operator)this, (Throwable)e, 315, new Object[]{this.getParameterAsString(PARAMETER_RESULT_NAME), e.getMessage()});
        }
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeString type = new ParameterTypeString(PARAMETER_RESULT_NAME, "The name of the entry. It will be saved in the results directory of this project.", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

