/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.io.batching;

import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.nio.model.DataResultSet;
import com.rapidminer.operator.nio.model.ParseException;
import com.rapidminer.tools.ProgressListener;
import java.util.Date;

public class LimitingDataResultSet
implements DataResultSet {
    private int batchSize;
    private int currentBatchPointer = -2;
    private DataResultSet resultSet;

    public LimitingDataResultSet(DataResultSet resultSet, int batchSize) {
        this.resultSet = resultSet;
        this.batchSize = batchSize;
    }

    public void nextBatch() {
        this.currentBatchPointer = Math.min(-1, this.currentBatchPointer);
    }

    public boolean hasNextBatch() {
        return this.resultSet.hasNext();
    }

    public boolean hasNext() {
        if (this.currentBatchPointer < this.batchSize) {
            return this.resultSet.hasNext();
        }
        return false;
    }

    public void closeFinally() throws OperatorException {
        this.resultSet.close();
    }

    public void next(ProgressListener listener) throws OperatorException {
        if (this.currentBatchPointer < this.batchSize) {
            ++this.currentBatchPointer;
            if (this.currentBatchPointer > 0) {
                this.resultSet.next(listener);
            }
            if (this.currentBatchPointer < 0) {
                this.resultSet.next(listener);
                this.currentBatchPointer = 0;
            }
        }
    }

    public int getNumberOfColumns() {
        return this.resultSet.getNumberOfColumns();
    }

    public String[] getColumnNames() {
        return this.resultSet.getColumnNames();
    }

    public boolean isMissing(int columnIndex) {
        return this.resultSet.isMissing(columnIndex);
    }

    public Number getNumber(int columnIndex) throws ParseException {
        return this.resultSet.getNumber(columnIndex);
    }

    public String getString(int columnIndex) throws ParseException {
        return this.resultSet.getString(columnIndex);
    }

    public Date getDate(int columnIndex) throws ParseException {
        return this.resultSet.getDate(columnIndex);
    }

    public DataResultSet.ValueType getNativeValueType(int columnIndex) throws ParseException {
        return this.resultSet.getNativeValueType(columnIndex);
    }

    public void close() throws OperatorException {
    }

    public void reset(ProgressListener listener) throws OperatorException {
    }

    public int[] getValueTypes() {
        return this.resultSet.getValueTypes();
    }

    public int getCurrentRow() {
        return this.currentBatchPointer;
    }
}

