/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.io.file.encryption;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.BufferedFileObject;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.Charsets;

public class DecryptFileObjectOperator
extends LicensedOperator {
    public static final String PARAMETER_PASSWORD = "password";
    private InputPort fileObjectInputPort = this.getInputPorts().createPort("encrypted file object", FileObject.class);
    private OutputPort decryptedFileObjectOutputPort = (OutputPort)this.getOutputPorts().createPort("decrypted file object");

    public DecryptFileObjectOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addGenerationRule(this.decryptedFileObjectOutputPort, FileObject.class);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        FileObject encryptedInputFile = (FileObject)this.fileObjectInputPort.getData(FileObject.class);
        SecretKeySpec key = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] keyBytes = digest.digest(this.getParameterAsString(PARAMETER_PASSWORD).getBytes(Charsets.UTF_8));
            key = new SecretKeySpec(keyBytes, "AES");
        }
        catch (NoSuchAlgorithmException e1) {
            throw new OperatorException("Algorithm missing.", (Throwable)e1);
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
             InputStream inputStream = encryptedInputFile.openStream();){
            byte[] iv = new byte[12];
            for (int i = 0; i < 12; ++i) {
                int value = inputStream.read();
                if (value < 0) {
                    throw new OperatorException("Invalid File: Must be at least 12 bytes long.");
                }
                iv[i] = (byte)value;
            }
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)key, parameterSpec);
            byte[] buffer = new byte[1024];
            int len = inputStream.read(buffer);
            while (len > -1) {
                outputStream.write(cipher.update(buffer, 0, len));
                len = inputStream.read(buffer);
            }
            outputStream.write(cipher.doFinal());
            this.decryptedFileObjectOutputPort.deliver((IOObject)new BufferedFileObject(outputStream.toByteArray()));
        }
        catch (Exception e) {
            throw new OperatorException("Error during decryption of file: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeString(PARAMETER_PASSWORD, "The password to use for encryption", false, false));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

