/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.learner.meta;

import com.owc.license.ProductInformation;
import com.owc.objects.indexed.IndexedIOObject;
import com.owc.objects.indexed.IndexedModel;
import com.owc.operator.LicensedOperator;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.container.Pair;
import java.util.Iterator;
import java.util.List;

public class CombineIndexedModelsOperator
extends LicensedOperator {
    public InputPortExtender extender = new InputPortExtender("indexed_models", (Ports)this.getInputPorts(), null, true);
    public OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("indexed_model");

    public CombineIndexedModelsOperator(OperatorDescription description) {
        super(description);
        this.extender.start();
        this.getTransformer().addGenerationRule(this.outputPort, IndexedModel.class);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        List indexedModels = this.extender.getData(IndexedModel.class, true);
        if (indexedModels.isEmpty()) {
            throw new UserError((Operator)this, 123, new Object[]{1, "" + IndexedModel.class});
        }
        Iterator iteratorIndexedModels = indexedModels.iterator();
        IndexedModel mainModel = (IndexedModel)iteratorIndexedModels.next();
        mainModel = mainModel.clone();
        String[] selectedGroupNames = mainModel.getIndexColumnNames();
        int[] selectedTypes = mainModel.getIndexColumnTypes();
        while (iteratorIndexedModels.hasNext()) {
            IndexedModel currentModel = (IndexedModel)iteratorIndexedModels.next();
            if (currentModel.getIndexColumnNames().length != selectedGroupNames.length) {
                throw new UserError((Operator)this, "database_extension.incompatible_indexed_models", new Object[]{currentModel.getName() + " - attributessize:" + currentModel.getIndexColumnNames().length, mainModel.getName() + " - attributessize:" + selectedGroupNames.length});
            }
            int[] currentGroupAttributeTypes = currentModel.getIndexColumnTypes();
            for (int i = 0; i < selectedGroupNames.length; ++i) {
                String currentGroupAttributeName = currentModel.getIndexColumnNames()[i];
                if (!currentGroupAttributeName.equals(selectedGroupNames[i])) {
                    throw new UserError((Operator)this, "toolkit.incompatible_indexed_models", new Object[]{currentModel.getName() + " - (Attribute" + i + "):" + currentGroupAttributeName, mainModel.getName() + " - (Attribute" + i + "):" + selectedGroupNames[i]});
                }
                if (currentGroupAttributeTypes[i] != selectedTypes[i]) {
                    throw new UserError((Operator)this, "toolkit.incompatible_indexed_models", new Object[]{currentModel.getName() + " - " + currentGroupAttributeName + " - " + Ontology.VALUE_TYPE_NAMES[currentGroupAttributeTypes[i]], mainModel.getName() + " - " + selectedGroupNames[i] + " -  - " + Ontology.VALUE_TYPE_NAMES[selectedTypes[i]]});
                }
                ++i;
            }
            for (Pair<IndexedIOObject.IndexedIOObjectKey, Model> currentPair : currentModel.getAll()) {
                mainModel.put((IndexedIOObject.IndexedIOObjectKey)currentPair.getFirst(), (Model)currentPair.getSecond());
            }
        }
        this.outputPort.deliver((IOObject)mainModel);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        return super.getParameterTypes();
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

