/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.learner.meta;

import com.owc.data.exampleset.SortedExampleSet;
import com.owc.license.ProductInformation;
import com.owc.objects.indexed.IndexedIOObject;
import com.owc.objects.indexed.IndexedIOObjectsCollection;
import com.owc.objects.indexed.IndexedModel;
import com.owc.operator.loops.ParallelLoopingOperatorChain;
import com.owc.process.ports.OneToOneExtender;
import com.owc.tools.ExampleSetMaterializer;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.studio.concurrency.internal.ConcurrencyExecutionServiceProvider;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.container.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class IndexedModelOperator
extends ParallelLoopingOperatorChain {
    public final String PARAMETER_APPLY_MODEL_PARALLELY = "apply_model_parallely";
    public final String PARAMETER_KEEP_GROUP_ATTRIBUTES = "keep_group_attributes";
    public final String PARAMETER_FAIL_ON_ERROR = "fail_on_error";
    public final String PARAMETER_FAIL_ON_MISSING_INPUT = "fail_on_missing_input";
    private final InputPort modelInnerOutput = this.getSubprocess(0).getInnerSinks().createPort("model", Model.class);
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private final OutputPort exampleSetInnerOutput = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("batch of example set");
    private final OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");
    private AttributeSubsetSelector groupAttributesSubsetSelector = new AttributeSubsetSelector((ParameterHandler)this, this.exampleSetInput);

    public IndexedModelOperator(OperatorDescription description) {
        super(description, "Group Processing");
        this.getTransformer().addRuleAtBeginning((MDTransformationRule)new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetInnerOutput, SetRelation.SUBSET){

            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                if (!IndexedModelOperator.this.getParameterAsBoolean("keep_group_attributes")) {
                    ExampleSetMetaData groupAttributes = IndexedModelOperator.this.groupAttributesSubsetSelector.getMetaDataSubset(metaData, false);
                    if (groupAttributes == null) {
                        return metaData;
                    }
                    for (AttributeMetaData currentAttribute : groupAttributes.getAllAttributes()) {
                        metaData.removeAttribute(currentAttribute);
                    }
                }
                return metaData;
            }
        });
        this.getTransformer().addGenerationRule(this.modelOutput, IndexedModel.class);
    }

    @Override
    public void doWork(boolean isLicensed, boolean isParallizable) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        List<IOObject> inputData = this.inputExtender.getDataOrNull(IOObject.class);
        Object set = (ExampleSet)this.exampleSetInput.getData(ExampleSet.class);
        if (set.size() > 0) {
            int i;
            LinkedList<Attribute> attributeSubset = new LinkedList<Attribute>(this.groupAttributesSubsetSelector.getAttributeSubset(set, false));
            if (attributeSubset.isEmpty()) {
                throw new UserError((Operator)this, 153, new Object[]{1, 0});
            }
            set = new SortedExampleSet((ExampleSet)set, 1, false, attributeSubset.toArray(new Attribute[0]));
            int[] groupLimits = new int[set.size()];
            double[] groupValues = new double[attributeSubset.size()];
            double[] currentValues = new double[attributeSubset.size()];
            int numberOfGroups = 0;
            int exampleIndex = 0;
            for (Example example : set) {
                i = 0;
                for (Attribute attribute : attributeSubset) {
                    currentValues[i] = example.getValue(attribute);
                    ++i;
                }
                if (exampleIndex == 0) {
                    System.arraycopy(currentValues, 0, groupValues, 0, groupValues.length);
                } else if (!Arrays.equals(groupValues, currentValues)) {
                    groupLimits[numberOfGroups++] = exampleIndex;
                    System.arraycopy(currentValues, 0, groupValues, 0, groupValues.length);
                }
                ++exampleIndex;
            }
            groupLimits[numberOfGroups++] = set.size();
            int[] partition = new int[set.size()];
            int batch = 0;
            for (i = 0; i < set.size(); ++i) {
                if (i == groupLimits[batch]) {
                    // empty if block
                }
                partition[i] = ++batch;
            }
            SplittedExampleSet splittedSet = new SplittedExampleSet(set, new Partition(partition, numberOfGroups));
            boolean keepGroupAttributes = this.getParameterAsBoolean("keep_group_attributes");
            boolean executeParallely = this.checkParallelizability();
            int innerResultPorts = 0;
            List<OneToOneExtender.PortPair> resultPorts = this.outputExtender.getManagedPairs();
            for (OneToOneExtender.PortPair portpair : resultPorts) {
                if (!portpair.getInputPort().isConnected()) continue;
                ++innerResultPorts;
            }
            Pair<LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, Model>, List<LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, IOObject>>> resultIndexed = executeParallely ? this.doLoopAsynchronously(numberOfGroups, splittedSet, inputData, attributeSubset, keepGroupAttributes, innerResultPorts) : this.doLoopSynchronously(numberOfGroups, splittedSet, inputData, attributeSubset, keepGroupAttributes, innerResultPorts);
            LinkedHashMap indexedModels = (LinkedHashMap)resultIndexed.getFirst();
            List indexedIOObjects = (List)resultIndexed.getSecond();
            String[] names = new String[attributeSubset.size()];
            int[] types = new int[attributeSubset.size()];
            int i2 = 0;
            for (Attribute attribute : attributeSubset) {
                names[i2] = attribute.getName();
                types[i2] = Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 2) ? 2 : 1;
                ++i2;
            }
            boolean applyModelParallely = this.getParameterAsBoolean("apply_model_parallely");
            this.modelOutput.deliver((IOObject)new IndexedModel((ExampleSet)set, indexedModels, names, types, applyModelParallely));
            for (i2 = 0; i2 < innerResultPorts; ++i2) {
                IndexedIOObjectsCollection currentIndexedIOObjectContainer = new IndexedIOObjectsCollection((LinkedHashMap)indexedIOObjects.get(i2), names, types);
                resultPorts.get(i2).getOutputPort().deliver((IOObject)currentIndexedIOObjectContainer);
            }
        } else {
            this.inputExtender.deliver(this.getDataCopy(inputData));
            this.loopExtender.deliver(this.getDataCopy(inputData));
        }
    }

    private Pair<LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, Model>, List<LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, IOObject>>> doLoopAsynchronously(int numberOfBatches, final SplittedExampleSet splittedSet, final List<IOObject> inputData, final List<Attribute> attributeSubset, final boolean keepGroupAttributes, final int providedIOObjects) throws OperatorException {
        LinkedList<Callable> tasks = new LinkedList<Callable>();
        for (int i = 0; i < numberOfBatches; ++i) {
            final int currentIteration = i;
            final IndexedModelOperator copy = (IndexedModelOperator)this.cloneOperator(this.getName(), true);
            Callable task = ConcurrencyExecutionServiceProvider.INSTANCE.getService().prepareOperatorTask(this.getProcess(), (Operator)copy, currentIteration + 1, currentIteration + 1 == numberOfBatches, (Callable)new Callable<Pair<LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, Model>, List<LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, IOObject>>>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Pair<LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, Model>, List<LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, IOObject>>> call() throws Exception {
                    ExampleSet batchSet;
                    copy.inputExtender.deliver(IndexedModelOperator.this.getDataCopy(inputData));
                    SplittedExampleSet splittedExampleSet = splittedSet;
                    synchronized (splittedExampleSet) {
                        splittedSet.selectSingleSubset(currentIteration);
                        batchSet = (ExampleSet)IndexedModelOperator.this.getDataCopy((IOObject)splittedSet);
                    }
                    return copy.performBatch(batchSet, attributeSubset, keepGroupAttributes, providedIOObjects);
                }
            });
            tasks.add(task);
        }
        List results = ConcurrencyExecutionServiceProvider.INSTANCE.getService().executeOperatorTasks((Operator)this, tasks);
        LinkedHashMap resultingIndexedModel = new LinkedHashMap();
        ArrayList resultingIndexedIOObjects = new ArrayList();
        for (int i = 0; i < providedIOObjects; ++i) {
            LinkedHashMap currentIndexedIOObject = new LinkedHashMap();
            resultingIndexedIOObjects.add(currentIndexedIOObject);
        }
        for (Pair batchResults : results) {
            if (batchResults == null) continue;
            LinkedHashMap currentIndexedModel = (LinkedHashMap)batchResults.getFirst();
            List currentIndexedIOObjects = (List)batchResults.getSecond();
            int i = 0;
            for (LinkedHashMap currentIndexedIOObject : currentIndexedIOObjects) {
                ((LinkedHashMap)resultingIndexedIOObjects.get(i++)).putAll(currentIndexedIOObject);
            }
            resultingIndexedModel.putAll(currentIndexedModel);
        }
        return new Pair(resultingIndexedModel, resultingIndexedIOObjects);
    }

    private Pair<LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, Model>, List<LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, IOObject>>> doLoopSynchronously(int numberOfBatches, SplittedExampleSet splittedSet, List<IOObject> inputData, List<Attribute> attributeSubset, boolean keepGroupAttributes, int providedIOObjects) throws ProcessStoppedException, OperatorException, UserError {
        int i;
        LinkedHashMap resultingIndexedModel = new LinkedHashMap();
        LinkedList resultingIndexedIOObjects = new LinkedList();
        for (i = 0; i < providedIOObjects; ++i) {
            resultingIndexedIOObjects.add(i, new LinkedHashMap());
        }
        this.loopExtender.deliver(this.getDataCopy(inputData));
        for (i = 0; i < numberOfBatches; ++i) {
            this.inApplyLoop();
            splittedSet.selectSingleSubset(i);
            ExampleSet batchSet = (ExampleSet)this.getDataCopy((IOObject)splittedSet);
            this.inputExtender.deliver(this.getDataCopy(inputData));
            Pair<LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, Model>, List<LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, IOObject>>> batchResults = this.performBatch(batchSet, attributeSubset, keepGroupAttributes, providedIOObjects);
            if (batchResults == null) continue;
            LinkedHashMap currentIndexedModel = (LinkedHashMap)batchResults.getFirst();
            List currentIndexedIOObjects = (List)batchResults.getSecond();
            resultingIndexedModel.putAll(currentIndexedModel);
            int v = 0;
            for (LinkedHashMap currentIndexedIOObject : currentIndexedIOObjects) {
                ((LinkedHashMap)resultingIndexedIOObjects.get(v++)).putAll(currentIndexedIOObject);
            }
        }
        return new Pair(resultingIndexedModel, resultingIndexedIOObjects);
    }

    private Pair<LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, Model>, List<LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, IOObject>>> performBatch(ExampleSet batchSet, List<Attribute> attributeSubset, boolean keepGroupAttributes, int providedIOObjects) throws OperatorException, UserError {
        LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, Model> indexedModel = new LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, Model>();
        LinkedList indexedIOObjects = new LinkedList();
        for (int i = 0; i < providedIOObjects; ++i) {
            indexedIOObjects.add(new LinkedHashMap());
        }
        if (batchSet.size() <= 0) {
            return new Pair(indexedModel, indexedIOObjects);
        }
        Example firstExample = batchSet.getExample(0);
        String[] nominalGroupValue = new String[attributeSubset.size()];
        double[] numericalGroupValue = new double[attributeSubset.size()];
        int i = 0;
        for (Attribute currentAttribute : attributeSubset) {
            currentAttribute = batchSet.getAttributes().get(currentAttribute.getName());
            if (currentAttribute.isNominal()) {
                nominalGroupValue[i] = firstExample.getValueAsString(currentAttribute);
            } else if (currentAttribute.isNumerical()) {
                numericalGroupValue[i] = firstExample.getValue(currentAttribute);
            } else if (currentAttribute.isDateTime()) {
                nominalGroupValue[i] = firstExample.getValueAsString(currentAttribute);
            } else {
                throw new UserError((Operator)this, 112, new Object[]{currentAttribute});
            }
            ++i;
        }
        IndexedIOObject.IndexedIOObjectKey data = new IndexedIOObject.IndexedIOObjectKey(nominalGroupValue, numericalGroupValue);
        int groupNumber = 1;
        for (Attribute currentAttribute : attributeSubset) {
            currentAttribute = batchSet.getAttributes().get(currentAttribute.getName());
            if (keepGroupAttributes) {
                batchSet.getAttributes().setSpecialAttribute(currentAttribute, "group_" + groupNumber++);
                continue;
            }
            batchSet.getAttributes().remove(currentAttribute);
        }
        this.exampleSetInnerOutput.deliver((IOObject)ExampleSetMaterializer.materializeExampleSetOnHeap(batchSet));
        boolean failOnError = this.getParameterAsBoolean("fail_on_error");
        try {
            this.getSubprocess(0).execute();
        }
        catch (OperatorException e) {
            if (failOnError) {
                throw e;
            }
            return null;
        }
        if (this.loopExtender.isConnected()) {
            this.loopExtender.deliver(this.loopExtender.getDataOrNull(IOObject.class));
        }
        Model model = (Model)this.modelInnerOutput.getDataOrNull(Model.class);
        List<OneToOneExtender.PortPair> resultPorts = this.outputExtender.getManagedPairs();
        boolean failOnMissingInput = this.getParameterAsBoolean("fail_on_missing_input");
        for (int v = 0; v < indexedIOObjects.size(); ++v) {
            InputPort currentResultInputPort = resultPorts.get(v).getInputPort();
            IOObject ioobject = currentResultInputPort.getDataOrNull(IOObject.class);
            if (ioobject == null) {
                if (!failOnMissingInput) continue;
                throw new UserError((Operator)this, 149, new Object[]{currentResultInputPort.getName()});
            }
            ((LinkedHashMap)indexedIOObjects.get(v)).put(data, ioobject);
            currentResultInputPort.clear(31);
        }
        if (model == null) {
            if (failOnMissingInput) {
                throw new UserError((Operator)this, 149, new Object[]{this.modelInnerOutput.getName()});
            }
        } else {
            indexedModel.put(data, model);
            this.modelInnerOutput.clear(31);
        }
        return new Pair(indexedModel, indexedIOObjects);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        List subsetSelectorTypes = this.groupAttributesSubsetSelector.getParameterTypes();
        types.addAll(subsetSelectorTypes);
        List<ParameterType> superTypes = super.getParameterTypes();
        types.addAll(superTypes);
        ParameterTypeBoolean type = new ParameterTypeBoolean("apply_model_parallely", "If enabled the Model will be applied parallely onto the ExampleSet. This Option can not be changed after a model is created, since it will be safed into the model.", true, true);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean("keep_group_attributes", "The selected group attributes will be set as special attributes if enable, otherwise the selected Group attributes will be removed in the batch.", true, true);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean("fail_on_error", "The process fails if the inner process generates an error.", true, false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean("fail_on_missing_input", "The process fails if no input is provided in the inner loop.", false, false);
        types.add((ParameterType)type);
        type = superTypes.get(0);
        if (types.remove(type)) {
            types.add(0, (ParameterType)type);
        }
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

