/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.loops;

import com.owc.license.ProductInformation;
import com.owc.operator.loops.ParallelLoopingOperatorChain;
import com.owc.operator.loops.control.BreakIterationException;
import com.owc.operator.loops.control.SkipIterationException;
import com.owc.process.ports.OneToOneExtender;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.operator.nio.file.SimpleFileObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeRegexp;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.PortProvider;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.parameter.conditions.PortConnectedCondition;
import com.rapidminer.studio.concurrency.internal.ConcurrencyExecutionServiceProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;

public class LoopFilesOperator
extends ParallelLoopingOperatorChain
implements PortProvider {
    public static final String PARAMETER_PATH_ATTRIBUTE = "path_attribute";
    public static final String PARAMETER_DIRECTORY = "directory";
    public static final String PARAMETER_FILTER_TYPE = "filter_type";
    public static final String PARAMETER_FILTER_REGEXP = "filter_by_regex";
    public static final String PARAMETER_FILTER_GLOBB = "filter_by_glob";
    public static final String PARAMETER_ENABLE_MACROS = "enable_macros";
    public static final String PARAMETER_FILE_NAME_MACRO = "macro_for_file_name";
    public static final String PARAMETER_FILE_TYPE_MACRO = "macro_for_file_type";
    public static final String PARAMETER_FOLDER_NAME_MACRO = "macro_for_folder_name";
    private final InputPort fileSetInputPort = (InputPort)this.getInputPorts().createPort("reference set");
    private final OutputPort fileObjectInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("file object");

    public LoopFilesOperator(OperatorDescription description) {
        super(description, "File Processing");
        this.fileSetInputPort.addPrecondition((Precondition)new AttributeSetPrecondition(this.fileSetInputPort, AttributeSetPrecondition.getAttributesByParameter((ParameterHandler)this, (String[])new String[]{PARAMETER_PATH_ATTRIBUTE}), new String[0]));
        this.getTransformer().addRuleAtBeginning((MDTransformationRule)new GenerateNewMDRule(this.fileObjectInnerSource, FileObject.class));
    }

    @Override
    public void doWork(boolean isLicensed, boolean isParallizable) throws OperatorException {
        List<IOObject> inputData = this.inputExtender.getDataOrNull(IOObject.class);
        ExampleSet set = (ExampleSet)this.fileSetInputPort.getDataOrNull(ExampleSet.class);
        Iterator<File> fileIterator = null;
        if (set != null) {
            String pathAttributeName = this.getParameterAsString(PARAMETER_PATH_ATTRIBUTE);
            Attribute pathAttribute = set.getAttributes().get(pathAttributeName);
            if (pathAttribute == null) {
                throw new UserError((Operator)this, 160, new Object[]{pathAttributeName});
            }
            Iterator setIterator = set.iterator();
            fileIterator = new TableBasedFileIterator(pathAttribute, setIterator);
        } else {
            try {
                ScanningFileIteratorFilterMethod filterType = ScanningFileIteratorFilterMethod.getValueOf(this.getParameterAsString(PARAMETER_FILTER_TYPE));
                fileIterator = filterType == ScanningFileIteratorFilterMethod.GLOB ? new ScanningFileIterator(this.getParameterAsString(PARAMETER_DIRECTORY), this.getParameterAsString(PARAMETER_FILTER_GLOBB), filterType) : new ScanningFileIterator(this.getParameterAsString(PARAMETER_DIRECTORY), this.getParameterAsString(PARAMETER_FILTER_REGEXP), filterType);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, "io.directory_not_found", new Object[]{this.getParameterAsString(PARAMETER_DIRECTORY)});
            }
        }
        if (fileIterator.hasNext()) {
            if (this.checkParallelizability()) {
                this.doLoopAsynchronously(inputData, fileIterator);
            } else {
                this.doLoopSynchronously(inputData, fileIterator);
            }
        } else {
            this.inputExtender.deliver(this.getDataCopy(inputData));
            this.loopExtender.deliver(this.getDataCopy(inputData));
            this.outputExtender.reset();
        }
    }

    private void doLoopSynchronously(List<IOObject> inputData, Iterator<File> iterator) throws UndefinedParameterError, ProcessStoppedException, OperatorException, UserError {
        if (this.loopExtender.isConnected()) {
            this.loopExtender.deliver(this.getDataCopy(inputData));
        }
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (file == null) continue;
            try {
                if (this.fileObjectInnerSource.isConnected()) {
                    IOObject ioObject = this.convertToIOObject(file);
                    this.fileObjectInnerSource.deliver(ioObject);
                }
                this.inputExtender.deliver(this.getDataCopy(inputData));
                this.setMacros(file);
                this.inApplyLoop();
                this.getSubprocess(0).execute();
                if (this.loopExtender.isConnected()) {
                    this.loopExtender.deliver(this.loopExtender.getDataOrNull(IOObject.class));
                }
                this.outputExtender.collect();
            }
            catch (SkipIterationException e) {
                e.finishSkippedOperators((Operator)this);
            }
            catch (BreakIterationException e) {
                e.finishBrokenOperators((Operator)this);
                break;
            }
        }
    }

    private void doLoopAsynchronously(final List<IOObject> inputData, Iterator<File> iterator) throws OperatorException {
        int currentIteration = 0;
        LinkedList<Callable> tasks = new LinkedList<Callable>();
        while (iterator.hasNext()) {
            final File file = iterator.next();
            if (file == null) continue;
            final LoopFilesOperator copy = (LoopFilesOperator)this.cloneOperator(this.getName(), true);
            Callable task = ConcurrencyExecutionServiceProvider.INSTANCE.getService().prepareOperatorTask(this.getProcess(), (Operator)copy, currentIteration++, !iterator.hasNext(), (Callable)new Callable<List<IOObject>>(){

                @Override
                public List<IOObject> call() throws Exception {
                    try {
                        copy.inputExtender.deliver(LoopFilesOperator.this.getDataCopy(inputData));
                        if (copy.fileObjectInnerSource.isConnected()) {
                            IOObject ioObject = LoopFilesOperator.this.convertToIOObject(file);
                            copy.fileObjectInnerSource.deliver(ioObject);
                        }
                        copy.setMacros(file);
                        copy.inApplyLoop();
                        copy.getSubprocess(0).execute();
                        return copy.outputExtender.getDataOrNull(IOObject.class);
                    }
                    catch (SkipIterationException e) {
                        e.finishSkippedOperators((Operator)copy);
                        return new LinkedList<IOObject>();
                    }
                }
            });
            tasks.add(task);
        }
        List results = ConcurrencyExecutionServiceProvider.INSTANCE.getService().executeOperatorTasks((Operator)this, tasks);
        List<OneToOneExtender.PortPair> managedPairs = this.outputExtender.getManagedPairs();
        for (List loopResults : results) {
            int i = 0;
            for (IOObject result : loopResults) {
                managedPairs.get(i++).getInputPort().receive(result);
            }
            this.outputExtender.collect();
        }
    }

    private void setMacros(File file) throws UndefinedParameterError {
        if (this.getParameterAsBoolean(PARAMETER_ENABLE_MACROS)) {
            String nameMacro = this.getParameterAsString(PARAMETER_FILE_NAME_MACRO);
            String typeMacro = this.getParameterAsString(PARAMETER_FILE_TYPE_MACRO);
            String folderMacro = this.getParameterAsString(PARAMETER_FOLDER_NAME_MACRO);
            if (nameMacro != null && !nameMacro.isEmpty()) {
                this.getProcess().getMacroHandler().addMacro(nameMacro, file.getName());
            }
            if (folderMacro != null && !folderMacro.isEmpty()) {
                this.getProcess().getMacroHandler().addMacro(folderMacro, file.getParent());
            }
            if (typeMacro != null && !typeMacro.isEmpty()) {
                String typeValue = file.getName();
                int lastIndex = typeValue.lastIndexOf(".");
                if (lastIndex >= 0) {
                    this.getProcess().getMacroHandler().addMacro(typeMacro, typeValue.substring(lastIndex + 1, typeValue.length()));
                } else {
                    this.getProcess().getMacroHandler().addMacro(typeMacro, "");
                }
            }
        }
    }

    private IOObject convertToIOObject(File file) {
        SimpleFileObject fileObject = new SimpleFileObject(file);
        Annotations annotations = fileObject.getAnnotations();
        annotations.setAnnotation("Filename", file.getName());
        annotations.setAnnotation("Source", file.getAbsolutePath());
        return fileObject;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add((ParameterType)new ParameterTypeDirectory(PARAMETER_DIRECTORY, "Select the directory from where to start scanning for files.", false));
        types.add((ParameterType)new ParameterTypeCategory(PARAMETER_FILTER_TYPE, "Specifies how to filter file names. You can either use standard, command shell like globb filtering or a regular expression.", ScanningFileIteratorFilterMethod.getValuesAsString(), 0, false));
        ParameterTypeString type = new ParameterTypeString(PARAMETER_FILTER_GLOBB, "Specifies a globb expression which is used as filter for the file and directory names. It is more simple than regular expressions. A detailed explanation can be found in the help, but it is as used from operating systems. Ignored if empty.", true, false);
        type.registerDependencyCondition((ParameterCondition)new EqualStringCondition((ParameterHandler)this, PARAMETER_FILTER_TYPE, false, new String[]{ScanningFileIteratorFilterMethod.GLOB.getFilterType()}));
        types.add((ParameterType)type);
        type = new ParameterTypeRegexp(PARAMETER_FILTER_REGEXP, "Specifies a regular expression which is used as filter for the file and directory names, e.g. 'a.*b' for all files starting with 'a' and ending with 'b'. Ignored if empty.", true, false);
        type.registerDependencyCondition((ParameterCondition)new EqualStringCondition((ParameterHandler)this, PARAMETER_FILTER_TYPE, false, new String[]{ScanningFileIteratorFilterMethod.REGEX.getFilterType()}));
        types.add((ParameterType)type);
        for (ParameterType type2 : types) {
            type2.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, (PortProvider)this, false, false));
        }
        type = new ParameterTypeAttribute(PARAMETER_PATH_ATTRIBUTE, "Select the attribute of the given example set that contains the file paths.", this.fileSetInputPort, new int[]{1});
        type.setOptional(true);
        type.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, (PortProvider)this, true, true));
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_ENABLE_MACROS, "If checked, the operator will set macros with file depending values as name, path or type. This allows to get some control in the subprocess.", false));
        type = new ParameterTypeString(PARAMETER_FILE_NAME_MACRO, "If filled, a macro with this name will be set to the name of the current entry. To get access on the full path including the containing directory, combine this with the folder macro. Can be left blank.", true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_MACROS, false, true));
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_FILE_TYPE_MACRO, "Will be set to the file's extension. Can be left blank.", true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_MACROS, false, true));
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_FOLDER_NAME_MACRO, "If filled, a macro with this name will be set to the containing folder of the current file. To get access on the full path you can combine this with the name macro. Can be left blank.", true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_MACROS, false, true));
        types.add((ParameterType)type);
        for (ParameterType currentType : types) {
            currentType.setExpert(false);
        }
        List<ParameterType> superTypes = super.getParameterTypes();
        types.addAll(superTypes);
        type = superTypes.get(0);
        if (types.remove(type)) {
            types.add(0, (ParameterType)type);
        }
        return types;
    }

    public Port getPort() {
        return this.fileSetInputPort;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }

    private final class TableBasedFileIterator
    implements Iterator<File> {
        private final Attribute pathAttribute;
        private final Iterator<Example> setIterator;

        private TableBasedFileIterator(Attribute pathAttribute, Iterator<Example> setIterator) {
            this.pathAttribute = pathAttribute;
            this.setIterator = setIterator;
        }

        @Override
        public File next() {
            Example next = this.setIterator.next();
            if (Double.isNaN(next.getValue(this.pathAttribute))) {
                return null;
            }
            String path = next.getNominalValue(this.pathAttribute);
            File file = new File(path);
            return file;
        }

        @Override
        public boolean hasNext() {
            return this.setIterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ScanningFileIterator
    implements Iterator<File> {
        private Iterator<Path> iterator;

        public ScanningFileIterator(String startDirectory, String filterString, ScanningFileIteratorFilterMethod filterType) throws IOException {
            final boolean ignoreFilter = filterString == null || filterString.isEmpty();
            String modifiedFilterString = filterType.filterType.equals(ScanningFileIteratorFilterMethod.GLOB.filterType) && filterString != null ? filterString.replace('\\', '/') : filterString;
            FileSystem fileSystem = FileSystems.getDefault();
            final PathMatcher pathMatcher = fileSystem.getPathMatcher(filterType.getFilterType() + ":" + modifiedFilterString);
            final LinkedList fileList = new LinkedList();
            Files.walkFileTree(Paths.get(startDirectory, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    FileVisitResult result = super.visitFile(file, attrs);
                    if (pathMatcher.matches(file) || ignoreFilter) {
                        fileList.add(file);
                    }
                    return result;
                }
            });
            this.iterator = fileList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public File next() {
            if (this.hasNext()) {
                return this.iterator.next().toFile();
            }
            throw new NoSuchElementException("IO Error while iterating over FileSystem.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static enum ScanningFileIteratorFilterMethod {
        GLOB("glob"),
        REGEX("regex");

        private String filterType;

        private ScanningFileIteratorFilterMethod(String filterType) {
            this.filterType = filterType;
        }

        public String getFilterType() {
            return this.filterType;
        }

        public static ScanningFileIteratorFilterMethod getValueOf(String value) {
            for (ScanningFileIteratorFilterMethod method : ScanningFileIteratorFilterMethod.values()) {
                if (!method.getFilterType().matches(value)) continue;
                return method;
            }
            return null;
        }

        public static String[] getValuesAsString() {
            return new String[]{GLOB.getFilterType(), REGEX.getFilterType()};
        }
    }
}

