/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.loops;

import com.owc.data.exampleset.SortedExampleSet;
import com.owc.license.ProductInformation;
import com.owc.operator.loops.ParallelLoopingOperatorChain;
import com.owc.operator.loops.control.BreakIterationException;
import com.owc.operator.loops.control.SkipIterationException;
import com.owc.process.ports.OneToOneExtender;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDateFormat;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.studio.concurrency.internal.ConcurrencyExecutionServiceProvider;
import com.rapidminer.tools.Tools;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class LoopGroupsOperator
extends ParallelLoopingOperatorChain {
    public static final String PARAMETER_DEFINE_GROUP_MACROS = "define_group_macros";
    public static final String PARAMETER_DATE_FORMAT = "date_format";
    private final InputPort exampleSetInputPort = this.getInputPorts().createPort("example set", (MetaData)new ExampleSetMetaData());
    private final OutputPort exampleSetInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("batch of example set");
    private AttributeSubsetSelector groupAttributesSubsetSelector = new AttributeSubsetSelector((ParameterHandler)this, this.exampleSetInputPort);

    public LoopGroupsOperator(OperatorDescription description) {
        super(description, "Group Processing");
        this.getTransformer().addRuleAtBeginning((MDTransformationRule)new PassThroughRule(this.exampleSetInputPort, this.exampleSetInnerSource, false));
    }

    @Override
    public void doWork(boolean isLicensed, boolean isParallizable) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        boolean extractMacros = this.getParameterAsBoolean(PARAMETER_DEFINE_GROUP_MACROS);
        String dateFormat = this.getParameterAsString(PARAMETER_DATE_FORMAT);
        List<IOObject> inputData = this.inputExtender.getDataOrNull(IOObject.class);
        Object set = (ExampleSet)this.exampleSetInputPort.getData(ExampleSet.class);
        if (set.size() > 0) {
            int i;
            LinkedList<Attribute> attributeSubset = new LinkedList<Attribute>(this.groupAttributesSubsetSelector.getAttributeSubset(set, false));
            if (attributeSubset.isEmpty()) {
                throw new UserError((Operator)this, 153, new Object[]{1, 0});
            }
            Attribute[] groupAttributes = attributeSubset.toArray(new Attribute[0]);
            LinkedList<String[]> groupMacroValuesList = new LinkedList<String[]>();
            set = new SortedExampleSet((ExampleSet)set, 1, true, groupAttributes);
            int[] groupLimits = new int[set.size()];
            double[] groupValues = new double[attributeSubset.size()];
            double[] currentValues = new double[attributeSubset.size()];
            int numberOfGroups = 0;
            int exampleIndex = 0;
            for (Example example : set) {
                i = 0;
                for (Attribute attribute : attributeSubset) {
                    currentValues[i] = example.getValue(attribute);
                    ++i;
                }
                if (extractMacros && (exampleIndex == 0 || !Arrays.equals(groupValues, currentValues))) {
                    String[] groupMacroValues = new String[groupAttributes.length];
                    i = 0;
                    for (Attribute attribute : attributeSubset) {
                        if (attribute.isNominal()) {
                            groupMacroValues[i] = attribute.getMapping().mapIndex((int)currentValues[i]);
                        } else if (attribute.isNumerical()) {
                            groupMacroValues[i] = Tools.formatIntegerIfPossible((double)currentValues[i], (int)16, (boolean)false);
                        } else if (attribute.isDateTime()) {
                            groupMacroValues[i] = Tools.formatDateTime((Date)new Date((long)currentValues[i]), (String)dateFormat);
                        }
                        ++i;
                    }
                    groupMacroValuesList.add(groupMacroValues);
                }
                if (exampleIndex == 0) {
                    System.arraycopy(currentValues, 0, groupValues, 0, groupValues.length);
                } else if (!Arrays.equals(groupValues, currentValues)) {
                    groupLimits[numberOfGroups++] = exampleIndex;
                    System.arraycopy(currentValues, 0, groupValues, 0, groupValues.length);
                }
                ++exampleIndex;
            }
            groupLimits[numberOfGroups++] = set.size();
            int[] partition = new int[set.size()];
            int batch = 0;
            for (i = 0; i < set.size(); ++i) {
                if (i == groupLimits[batch]) {
                    // empty if block
                }
                partition[i] = ++batch;
            }
            SplittedExampleSet splittedSet = new SplittedExampleSet(set, new Partition(partition, numberOfGroups));
            boolean executeParallely = this.checkParallelizability();
            if (executeParallely) {
                this.doLoopAsynchronously(numberOfGroups, splittedSet, inputData, groupMacroValuesList, attributeSubset);
            } else {
                this.doLoopSynchronously(numberOfGroups, splittedSet, inputData, groupMacroValuesList, attributeSubset);
            }
        } else {
            this.inputExtender.deliver(this.getDataCopy(inputData));
            this.loopExtender.deliver(this.getDataCopy(inputData));
            this.outputExtender.reset();
        }
    }

    private void doLoopAsynchronously(int numberOfBatches, final SplittedExampleSet splittedSet, final List<IOObject> inputData, LinkedList<String[]> groupMacroValuesList, final List<Attribute> groupAttributeSubset) throws OperatorException {
        LinkedList<Callable> tasks = new LinkedList<Callable>();
        Iterator macroValueIterator = groupMacroValuesList.iterator();
        for (int i = 0; i < numberOfBatches; ++i) {
            final int currentIteration = i;
            final String[] macroValues = macroValueIterator.hasNext() ? (String[])macroValueIterator.next() : null;
            final LoopGroupsOperator copy = (LoopGroupsOperator)this.cloneOperator(this.getName(), true);
            Callable task = ConcurrencyExecutionServiceProvider.INSTANCE.getService().prepareOperatorTask(this.getProcess(), (Operator)copy, currentIteration + 1, currentIteration + 1 == numberOfBatches, (Callable)new Callable<List<IOObject>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public List<IOObject> call() throws Exception {
                    ExampleSet batchSet;
                    copy.inputExtender.deliver(LoopGroupsOperator.this.getDataCopy(inputData));
                    if (LoopGroupsOperator.this.getParameterAsBoolean(LoopGroupsOperator.PARAMETER_DEFINE_GROUP_MACROS)) {
                        LoopGroupsOperator.this.setMacrosToGroupValues(groupAttributeSubset, copy, macroValues);
                    }
                    SplittedExampleSet splittedExampleSet = splittedSet;
                    synchronized (splittedExampleSet) {
                        splittedSet.selectSingleSubset(currentIteration);
                        batchSet = (ExampleSet)LoopGroupsOperator.this.getDataCopy((IOObject)splittedSet);
                    }
                    return copy.performBatch(batchSet);
                }
            });
            tasks.add(task);
        }
        List results = ConcurrencyExecutionServiceProvider.INSTANCE.getService().executeOperatorTasks((Operator)this, tasks);
        List<OneToOneExtender.PortPair> managedPairs = this.outputExtender.getManagedPairs();
        for (List loopResults : results) {
            int i = 0;
            for (IOObject result : loopResults) {
                managedPairs.get(i++).getInputPort().receive(result);
            }
            this.outputExtender.collect();
        }
    }

    private void doLoopSynchronously(int numberOfBatches, SplittedExampleSet splittedSet, List<IOObject> inputData, LinkedList<String[]> groupMacroValuesList, List<Attribute> groupAttributeSubset) throws ProcessStoppedException, OperatorException, UserError {
        this.loopExtender.deliver(this.getDataCopy(inputData));
        Iterator macroValueIterator = groupMacroValuesList.iterator();
        for (int i = 0; i < numberOfBatches; ++i) {
            this.inApplyLoop();
            if (this.getParameterAsBoolean(PARAMETER_DEFINE_GROUP_MACROS)) {
                String[] macroValues = (String[])macroValueIterator.next();
                this.setMacrosToGroupValues(groupAttributeSubset, this, macroValues);
            }
            this.inputExtender.deliver(this.getDataCopy(inputData));
            splittedSet.selectSingleSubset(i);
            ExampleSet batchSet = (ExampleSet)this.getDataCopy((IOObject)splittedSet);
            try {
                this.performBatch(batchSet);
            }
            catch (BreakIterationException e) {
                e.finishBrokenOperators((Operator)this);
                break;
            }
            this.outputExtender.collect();
        }
    }

    private List<IOObject> performBatch(ExampleSet batchSet) throws OperatorException, UserError {
        try {
            this.exampleSetInnerSource.deliver((IOObject)batchSet);
            this.getSubprocess(0).execute();
            if (this.loopExtender.isConnected()) {
                this.loopExtender.deliver(this.loopExtender.getDataOrNull(IOObject.class));
            }
            return this.outputExtender.getDataOrNull(IOObject.class);
        }
        catch (SkipIterationException e) {
            e.finishSkippedOperators((Operator)this);
            return new LinkedList<IOObject>();
        }
    }

    private void setMacrosToGroupValues(List<Attribute> groupAttributeSubset, LoopGroupsOperator copy, String[] macroValues) {
        int j = 0;
        for (Attribute attribute : groupAttributeSubset) {
            String macroName = attribute.getName();
            macroName = macroName.substring(0, 1).toLowerCase() + macroName.substring(1);
            copy.getProcess().getMacroHandler().addMacro(macroName, macroValues[j++]);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        List subsetSelectorTypes = this.groupAttributesSubsetSelector.getParameterTypes();
        types.addAll(subsetSelectorTypes);
        List<ParameterType> superTypes = super.getParameterTypes();
        types.addAll(superTypes);
        ParameterType type = superTypes.get(0);
        if (types.remove(type)) {
            types.add(0, type);
        }
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_DEFINE_GROUP_MACROS, "If checked, macros will be created automatically for every grouping attribute. The macro will have the name of the attribute but starting with a lower case character.", true, false));
        type = new ParameterTypeDateFormat(PARAMETER_DATE_FORMAT, "The date format used for filling the macros.", "yyyy-MM-dd HH:mm:ss", false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_DEFINE_GROUP_MACROS, true, true));
        types.add(type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

