/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.loops;

import com.owc.license.ProductInformation;
import com.owc.objects.indexed.IndexedIOObject;
import com.owc.operator.loops.ParallelLoopingOperatorChain;
import com.owc.operator.loops.control.BreakIterationException;
import com.owc.operator.loops.control.SkipIterationException;
import com.owc.process.ports.OneToOneExtender;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDateFormat;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.studio.concurrency.internal.ConcurrencyExecutionServiceProvider;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.container.Pair;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class LoopIndexOperator
extends ParallelLoopingOperatorChain {
    public static final String PARAMETER_DEFINE_INDEX_MACROS = "define_index_macros";
    public static final String PARAMETER_DATE_FORMAT = "date_format";
    private final InputPort indexInputPort = this.getInputPorts().createPort("indexed object", IndexedIOObject.class);
    private final OutputPort indexObjectInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("object");

    public LoopIndexOperator(OperatorDescription description) {
        super(description, "Group Processing");
        this.getTransformer().addGenerationRule(this.indexObjectInnerSource, IOObject.class);
    }

    @Override
    public void doWork(boolean isLicensed, boolean isParallizable) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        boolean extractMacros = this.getParameterAsBoolean(PARAMETER_DEFINE_INDEX_MACROS);
        String dateFormat = this.getParameterAsString(PARAMETER_DATE_FORMAT);
        List<IOObject> inputData = this.inputExtender.getDataOrNull(IOObject.class);
        IndexedIOObject index = (IndexedIOObject)this.indexInputPort.getData(IndexedIOObject.class);
        List<Pair<IndexedIOObject.IndexedIOObjectKey, IOObject>> indexContent = index.getAll();
        LinkedList<String[]> groupMacroValuesList = new LinkedList<String[]>();
        if (indexContent.size() > 0) {
            boolean executeParallely;
            if (extractMacros) {
                String[] indexColumnNames = index.getIndexColumnNames();
                int[] indexColumnTypes = index.getIndexColumnTypes();
                for (Pair pair : indexContent) {
                    String[] groupMacroValues = new String[indexColumnNames.length];
                    for (int i = 0; i < groupMacroValues.length; ++i) {
                        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(indexColumnTypes[i], 1)) {
                            groupMacroValues[i] = ((IndexedIOObject.IndexedIOObjectKey)pair.getFirst()).nominalValues[i];
                            continue;
                        }
                        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(indexColumnTypes[i], 2)) {
                            groupMacroValues[i] = Tools.formatIntegerIfPossible((double)((IndexedIOObject.IndexedIOObjectKey)pair.getFirst()).numericalValues[i], (int)16, (boolean)false);
                            continue;
                        }
                        if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(indexColumnTypes[i], 9)) continue;
                        groupMacroValues[i] = Tools.formatDateTime((Date)new Date((long)((IndexedIOObject.IndexedIOObjectKey)pair.getFirst()).numericalValues[i]), (String)dateFormat);
                    }
                    groupMacroValuesList.add(groupMacroValues);
                }
            }
            if (executeParallely = this.checkParallelizability()) {
                this.doLoopAsynchronously(indexContent, index.getIndexColumnNames(), groupMacroValuesList, inputData);
            } else {
                this.doLoopSynchronously(indexContent, index.getIndexColumnNames(), groupMacroValuesList, inputData);
            }
        } else {
            this.inputExtender.deliver(this.getDataCopy(inputData));
            this.loopExtender.deliver(this.getDataCopy(inputData));
            this.outputExtender.reset();
        }
    }

    private void doLoopAsynchronously(List<Pair<IndexedIOObject.IndexedIOObjectKey, IOObject>> indexContent, final String[] indexColumnNames, LinkedList<String[]> groupMacroValuesList, final List<IOObject> inputData) throws OperatorException {
        LinkedList<Callable> tasks = new LinkedList<Callable>();
        Iterator macroValueIterator = groupMacroValuesList.iterator();
        int i = 0;
        for (final Pair<IndexedIOObject.IndexedIOObjectKey, IOObject> indexEntry : indexContent) {
            int currentIteration = i;
            String[] macroValuesCopy = null;
            if (this.getParameterAsBoolean(PARAMETER_DEFINE_INDEX_MACROS)) {
                macroValuesCopy = (String[])macroValueIterator.next();
            }
            final String[] macroValues = macroValuesCopy;
            final LoopIndexOperator copy = (LoopIndexOperator)this.cloneOperator(this.getName(), true);
            Callable task = ConcurrencyExecutionServiceProvider.INSTANCE.getService().prepareOperatorTask(this.getProcess(), (Operator)copy, currentIteration + 1, currentIteration + 1 == indexContent.size(), (Callable)new Callable<List<IOObject>>(){

                @Override
                public List<IOObject> call() throws Exception {
                    copy.inputExtender.deliver(LoopIndexOperator.this.getDataCopy(inputData));
                    if (LoopIndexOperator.this.getParameterAsBoolean(LoopIndexOperator.PARAMETER_DEFINE_INDEX_MACROS)) {
                        LoopIndexOperator.this.setMacrosToIndexValues(indexColumnNames, copy, macroValues);
                    }
                    return copy.performBatch(LoopIndexOperator.this.getDataCopy((IOObject)indexEntry.getSecond()));
                }
            });
            tasks.add(task);
            ++i;
        }
        List results = ConcurrencyExecutionServiceProvider.INSTANCE.getService().executeOperatorTasks((Operator)this, tasks);
        List<OneToOneExtender.PortPair> managedPairs = this.outputExtender.getManagedPairs();
        for (List loopResults : results) {
            i = 0;
            for (IOObject result : loopResults) {
                managedPairs.get(i++).getInputPort().receive(result);
            }
            this.outputExtender.collect();
        }
    }

    private void doLoopSynchronously(List<Pair<IndexedIOObject.IndexedIOObjectKey, IOObject>> indexContent, String[] indexColumnNames, LinkedList<String[]> groupMacroValuesList, List<IOObject> inputData) throws UserError, OperatorException {
        this.loopExtender.deliver(this.getDataCopy(inputData));
        Iterator macroIndexValueIterator = groupMacroValuesList.iterator();
        for (Pair<IndexedIOObject.IndexedIOObjectKey, IOObject> indexEntry : indexContent) {
            this.inApplyLoop();
            if (this.getParameterAsBoolean(PARAMETER_DEFINE_INDEX_MACROS)) {
                this.setMacrosToIndexValues(indexColumnNames, this, (String[])macroIndexValueIterator.next());
            }
            this.inputExtender.deliver(this.getDataCopy(inputData));
            try {
                this.performBatch((IOObject)indexEntry.getSecond());
            }
            catch (BreakIterationException e) {
                e.finishBrokenOperators((Operator)this);
                break;
            }
            this.outputExtender.collect();
        }
    }

    private List<IOObject> performBatch(IOObject ioObject) throws OperatorException, UserError {
        try {
            this.indexObjectInnerSource.deliver(ioObject);
            this.getSubprocess(0).execute();
            if (this.loopExtender.isConnected()) {
                this.loopExtender.deliver(this.loopExtender.getDataOrNull(IOObject.class));
            }
            return this.outputExtender.getDataOrNull(IOObject.class);
        }
        catch (SkipIterationException e) {
            e.finishSkippedOperators((Operator)this);
            return new LinkedList<IOObject>();
        }
    }

    private void setMacrosToIndexValues(String[] indexColumnNames, LoopIndexOperator copy, String[] indexValues) {
        int j = 0;
        for (String macroName : indexColumnNames) {
            macroName = macroName.substring(0, 1).toLowerCase() + macroName.substring(1);
            copy.getProcess().getMacroHandler().addMacro(macroName, indexValues[j++]);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        List<ParameterType> superTypes = super.getParameterTypes();
        types.addAll(superTypes);
        ParameterType type = superTypes.get(0);
        if (types.remove(type)) {
            types.add(0, type);
        }
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_DEFINE_INDEX_MACROS, "If checked, macros will be created automatically for every index column. The macro will have the name of the index column but starting with a lower case character.", true, false));
        type = new ParameterTypeDateFormat(PARAMETER_DATE_FORMAT, "The date format used for filling the macros.", "yyyy-MM-dd HH:mm:ss", false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_DEFINE_INDEX_MACROS, true, true));
        types.add(type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

