/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.loops;

import com.owc.license.ProductInformation;
import com.owc.objects.ProcessObject;
import com.owc.operator.loops.ParallelLoopingOperatorChain;
import com.owc.operator.loops.control.BreakIterationException;
import com.owc.operator.loops.control.SkipIterationException;
import com.owc.process.ports.OneToOneExtender;
import com.owc.tools.RepositoryIterator;
import com.rapidminer.RapidMiner;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.OperatorVersion;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.operator.nio.file.RepositoryBlobObject;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeRegexp;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.repository.BlobEntry;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.internal.remote.RemoteBlobEntry;
import com.rapidminer.repository.internal.remote.RemoteIOObjectEntry;
import com.rapidminer.repository.internal.remote.RemoteProcessEntry;
import com.rapidminer.studio.concurrency.internal.ConcurrencyExecutionServiceProvider;
import com.rapidminer.tools.OperatorService;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class LoopRepositoryOperator
extends ParallelLoopingOperatorChain {
    private static final OperatorVersion OPERATOR_VERSION_0_0_11 = new OperatorVersion(0, 0, 11);
    public static final String PARAMETER_DIRECTORY = "repository_folder";
    public static final String PARAMETER_PROCESS_FILES = "include_files";
    public static final String PARAMETER_PROCESS_IO_OBJECTS = "include_objects";
    public static final String PARAMETER_PROCESS_PROCESSES = "include_processes";
    public static final String PARAMETER_ENABLE_OBJECT_TYPE_FILTER = "enable_object_type_filter";
    public static final String PARAMETER_LIST_OBJECT_TYPE_FILTER_LIST = "filter_list";
    public static final String PARAMETER_OBJECT_TYPE = "object_type";
    public static final String PARAMETER_OBJECT_TYPE_INCLUDED = "include";
    public static final String PARAMETER_FILTER_ENTRY_NAME = "filter_for_entry_name";
    public static final String PARAMETER_FILTER_ENTRY_PATH = "filter_for_entry_path";
    public static final String PARAMETER_ENABLE_MACROS = "enable_macros";
    public static final String PARAMETER_ENTRY_NAME_MACRO = "macro_for_entry_name";
    public static final String PARAMETER_ENTRY_TYPE_MACRO = "macro_for_entry_type";
    public static final String PARAMETER_FOLDER_NAME_MACRO = "macro_for_folder_name";
    private OutputPort entryInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("repository entry");

    public LoopRepositoryOperator(OperatorDescription description) {
        super(description, "Entry Processing");
        this.getTransformer().addRuleAtBeginning((MDTransformationRule)new GenerateNewMDRule(this.entryInnerSource, IOObject.class){

            public MetaData modifyMetaData(MetaData unmodifiedMetaData) {
                if (LoopRepositoryOperator.this.getParameterAsBoolean(LoopRepositoryOperator.PARAMETER_PROCESS_FILES) && !LoopRepositoryOperator.this.getParameterAsBoolean(LoopRepositoryOperator.PARAMETER_PROCESS_PROCESSES) && !LoopRepositoryOperator.this.getParameterAsBoolean(LoopRepositoryOperator.PARAMETER_PROCESS_IO_OBJECTS)) {
                    return new MetaData(FileObject.class);
                }
                if (!LoopRepositoryOperator.this.getParameterAsBoolean(LoopRepositoryOperator.PARAMETER_PROCESS_FILES) && LoopRepositoryOperator.this.getParameterAsBoolean(LoopRepositoryOperator.PARAMETER_PROCESS_PROCESSES) && !LoopRepositoryOperator.this.getParameterAsBoolean(LoopRepositoryOperator.PARAMETER_PROCESS_IO_OBJECTS)) {
                    return new MetaData(ProcessObject.class);
                }
                if (!LoopRepositoryOperator.this.getParameterAsBoolean(LoopRepositoryOperator.PARAMETER_PROCESS_FILES) && !LoopRepositoryOperator.this.getParameterAsBoolean(LoopRepositoryOperator.PARAMETER_PROCESS_PROCESSES) && LoopRepositoryOperator.this.getParameterAsBoolean(LoopRepositoryOperator.PARAMETER_PROCESS_IO_OBJECTS) && LoopRepositoryOperator.this.getParameterAsBoolean(LoopRepositoryOperator.PARAMETER_ENABLE_OBJECT_TYPE_FILTER)) {
                    try {
                        Class selectedClass;
                        String[] parameterList = ParameterTypeEnumeration.transformString2Enumeration((String)LoopRepositoryOperator.this.getParameterAsString(LoopRepositoryOperator.PARAMETER_LIST_OBJECT_TYPE_FILTER_LIST));
                        int selected = 0;
                        String selectedClassName = null;
                        for (String value : parameterList) {
                            ++selected;
                            selectedClassName = value;
                        }
                        if (selected == 1 && (selectedClass = OperatorService.getIOObjectClass(selectedClassName)) != null) {
                            return new MetaData(selectedClass);
                        }
                    }
                    catch (UndefinedParameterError undefinedParameterError) {
                        // empty catch block
                    }
                }
                return new MetaData(IOObject.class);
            }
        });
    }

    @Override
    public void doWork(boolean isLicensed, boolean isParallizable) throws OperatorException {
        String[] parameterList;
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        List<IOObject> inputData = this.inputExtender.getDataOrNull(IOObject.class);
        if (!(this.getParameterAsBoolean(PARAMETER_PROCESS_IO_OBJECTS) || this.getParameterAsBoolean(PARAMETER_PROCESS_PROCESSES) || this.getParameterAsBoolean(PARAMETER_PROCESS_FILES))) {
            throw new UserError((Operator)this, "toolkit.includes_missing");
        }
        if (this.getParameterAsBoolean(PARAMETER_PROCESS_IO_OBJECTS) && this.getParameterAsBoolean(PARAMETER_ENABLE_OBJECT_TYPE_FILTER) && !this.getParameterAsBoolean(PARAMETER_PROCESS_PROCESSES) && !this.getParameterAsBoolean(PARAMETER_PROCESS_FILES) && (parameterList = ParameterTypeEnumeration.transformString2Enumeration((String)this.getParameterAsString(PARAMETER_LIST_OBJECT_TYPE_FILTER_LIST))).length == 0) {
            throw new UserError((Operator)this, "toolkit.object_filter_is_empty");
        }
        try {
            RepositoryLocation directory = this.getParameterAsRepositoryLocation(PARAMETER_DIRECTORY);
            try {
                if (directory == null || directory.locateEntry() == null) {
                    throw new UserError((Operator)this, 319, new Object[]{directory});
                }
            }
            catch (RepositoryException e) {
                throw new UserError((Operator)this, 319, new Object[]{directory});
            }
            RepositoryIterator iterator = new RepositoryIterator(directory);
            if (iterator.hasNext()) {
                if (this.checkParallelizability()) {
                    this.doLoopAsynchronously(inputData, iterator);
                } else {
                    this.doLoopSynchronously(inputData, iterator);
                }
            } else {
                this.inputExtender.deliver(this.getDataCopy(inputData));
                this.loopExtender.deliver(this.getDataCopy(inputData));
                this.outputExtender.reset();
            }
        }
        catch (RepositoryException e) {
            throw new OperatorException("Error while accessing repository.", (Throwable)e);
        }
    }

    private void doLoopSynchronously(List<IOObject> inputData, RepositoryIterator iterator) throws UndefinedParameterError, ProcessStoppedException, OperatorException, UserError, RepositoryException {
        if (this.loopExtender.isConnected()) {
            this.loopExtender.deliver(this.getDataCopy(inputData));
        }
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (!this.filterNamePattern(entry) || !this.filterDataType(entry)) continue;
            try {
                if (this.entryInnerSource.isConnected()) {
                    IOObject ioObject = this.convertToIOObject(entry);
                    this.entryInnerSource.deliver(ioObject);
                }
                this.setMacros(entry);
                this.inApplyLoop();
                this.inputExtender.deliver(this.getDataCopy(inputData));
                this.getSubprocess(0).execute();
                if (this.loopExtender.isConnected()) {
                    this.loopExtender.deliver(this.loopExtender.getDataOrNull(IOObject.class));
                }
                this.outputExtender.collect();
            }
            catch (SkipIterationException e) {
                e.finishSkippedOperators((Operator)this);
            }
            catch (BreakIterationException e) {
                e.finishBrokenOperators((Operator)this);
                break;
            }
        }
    }

    private void setMacros(Entry entry) throws UndefinedParameterError {
        if (this.getParameterAsBoolean(PARAMETER_ENABLE_MACROS)) {
            String nameMacro = this.getParameterAsString(PARAMETER_ENTRY_NAME_MACRO);
            String typeMacro = this.getParameterAsString(PARAMETER_ENTRY_TYPE_MACRO);
            String folderMacro = this.getParameterAsString(PARAMETER_FOLDER_NAME_MACRO);
            if (nameMacro != null && !nameMacro.isEmpty()) {
                this.getProcess().getMacroHandler().addMacro(nameMacro, entry.getName());
            }
            if (folderMacro != null && !folderMacro.isEmpty()) {
                if (this.getCompatibilityLevel().isAtMost((VersionNumber)OPERATOR_VERSION_0_0_11)) {
                    this.getProcess().getMacroHandler().addMacro(folderMacro, entry.getLocation().getPath());
                } else {
                    this.getProcess().getMacroHandler().addMacro(folderMacro, entry.getLocation().parent().getPath());
                }
            }
            if (typeMacro != null && !typeMacro.isEmpty()) {
                String typeValue = entry instanceof IOObjectEntry ? "object" : (entry instanceof BlobEntry ? "file" : (entry instanceof ProcessEntry ? "process" : "unknown"));
                this.getProcess().getMacroHandler().addMacro(typeMacro, typeValue);
            }
        }
    }

    private void doLoopAsynchronously(final List<IOObject> inputData, RepositoryIterator iterator) throws OperatorException {
        int currentIteration = 0;
        LinkedList<Callable> tasks = new LinkedList<Callable>();
        while (iterator.hasNext()) {
            final Entry entry = iterator.next();
            if (!this.filterNamePattern(entry) || !this.filterDataType(entry)) continue;
            final LoopRepositoryOperator copy = (LoopRepositoryOperator)this.cloneOperator(this.getName(), true);
            Callable task = ConcurrencyExecutionServiceProvider.INSTANCE.getService().prepareOperatorTask(this.getProcess(), (Operator)copy, currentIteration++, !iterator.hasNext(), (Callable)new Callable<List<IOObject>>(){

                @Override
                public List<IOObject> call() throws Exception {
                    try {
                        copy.inputExtender.deliver(LoopRepositoryOperator.this.getDataCopy(inputData));
                        if (LoopRepositoryOperator.this.entryInnerSource.isConnected()) {
                            IOObject ioObject = LoopRepositoryOperator.this.convertToIOObject(entry);
                            copy.entryInnerSource.deliver(ioObject);
                        }
                        copy.setMacros(entry);
                        copy.inApplyLoop();
                        copy.getSubprocess(0).execute();
                        return copy.outputExtender.getDataOrNull(IOObject.class);
                    }
                    catch (SkipIterationException e) {
                        e.finishSkippedOperators((Operator)copy);
                        return new LinkedList<IOObject>();
                    }
                }
            });
            tasks.add(task);
        }
        List results = ConcurrencyExecutionServiceProvider.INSTANCE.getService().executeOperatorTasks((Operator)this, tasks);
        List<OneToOneExtender.PortPair> managedPairs = this.outputExtender.getManagedPairs();
        for (List loopResult : results) {
            int i = 0;
            for (IOObject result : loopResult) {
                managedPairs.get(i++).getInputPort().receive(result);
            }
            this.outputExtender.collect();
        }
    }

    private IOObject convertToIOObject(Entry entry) throws RepositoryException {
        if (entry instanceof IOObjectEntry) {
            IOObjectEntry objectEntry = (IOObjectEntry)entry;
            return objectEntry.retrieveData(null);
        }
        if (entry instanceof BlobEntry) {
            return new RepositoryBlobObject(entry.getLocation());
        }
        if (entry instanceof ProcessEntry) {
            ProcessEntry processEntry = (ProcessEntry)entry;
            return new ProcessObject(entry.getLocation(), processEntry.retrieveXML());
        }
        throw new RuntimeException("Unexpected class of Repository Entry: " + entry.getClass());
    }

    private boolean filterDataType(Entry entry) throws UndefinedParameterError {
        if (entry instanceof IOObjectEntry || entry instanceof RemoteIOObjectEntry) {
            if (this.getParameterAsBoolean(PARAMETER_PROCESS_IO_OBJECTS)) {
                if (this.getParameterAsBoolean(PARAMETER_ENABLE_OBJECT_TYPE_FILTER)) {
                    String[] parameterList;
                    IOObjectEntry objectEntry = (IOObjectEntry)entry;
                    Class objectClass = objectEntry.getObjectClass();
                    for (String value : parameterList = ParameterTypeEnumeration.transformString2Enumeration((String)this.getParameterAsString(PARAMETER_LIST_OBJECT_TYPE_FILTER_LIST))) {
                        Class selectedClass = OperatorService.getIOObjectClass((String)value);
                        if (selectedClass == null || !selectedClass.isAssignableFrom(objectClass)) continue;
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
        if (entry instanceof BlobEntry || entry instanceof RemoteBlobEntry) {
            return this.getParameterAsBoolean(PARAMETER_PROCESS_FILES);
        }
        if (entry instanceof ProcessEntry || entry instanceof RemoteProcessEntry) {
            return this.getParameterAsBoolean(PARAMETER_PROCESS_PROCESSES);
        }
        return false;
    }

    private boolean filterNamePattern(Entry entry) throws UndefinedParameterError {
        String nameRegex = this.getParameterAsString(PARAMETER_FILTER_ENTRY_NAME);
        String pathRegex = this.getParameterAsString(PARAMETER_FILTER_ENTRY_PATH);
        return !(nameRegex != null && !entry.getName().matches(nameRegex) || pathRegex != null && !entry.getLocation().getAbsoluteLocation().matches(pathRegex));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeRepositoryLocation type = new ParameterTypeRepositoryLocation(PARAMETER_DIRECTORY, "Folder in the repository to iterate over", false, true, true, false);
        type.setExpert(false);
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeRegexp(PARAMETER_FILTER_ENTRY_NAME, "The name of each entry is matched against this regular expression. It will be processed only if the regular expression given here matches the name. Leave empty for no filtering.", true));
        types.add((ParameterType)new ParameterTypeRegexp(PARAMETER_FILTER_ENTRY_PATH, "The full path including folder and name of each entry is matched against this regular expression. The entry will only be processed only the regular expression given here matches. Leave empty for no filtering.", true));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_PROCESS_IO_OBJECTS, "If checked the inner process will be executed for every object saved in the folders.", true));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_PROCESS_FILES, "If checked the inner process will be executed for every binary file saved in the folders.", true));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_PROCESS_PROCESSES, "If checked the inner process will be executed for every process saved in the folders.", true));
        String[] ioObjects = OperatorService.getIOObjectsNames().toArray(new String[0]);
        LinkedList<String[]> ioObjectsDefaultList = new LinkedList<String[]>();
        if (!RapidMiner.getVersion().isAtLeast(6, 0, 0)) {
            for (String objectClass : ioObjects) {
                ioObjectsDefaultList.add(new String[]{objectClass, "false"});
            }
        }
        type = new ParameterTypeBoolean(PARAMETER_ENABLE_OBJECT_TYPE_FILTER, "If checked, you can select which classes of IO Objects you want to process.", false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_PROCESS_IO_OBJECTS, false, true));
        types.add((ParameterType)type);
        type = new ParameterTypeEnumeration(PARAMETER_LIST_OBJECT_TYPE_FILTER_LIST, "Here you can select whether to process single io object classes.", (ParameterType)new ParameterTypeCategory(PARAMETER_OBJECT_TYPE, "The type of the object to which this filtering applies.", ioObjects, 0));
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_OBJECT_TYPE_FILTER, false, true));
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_ENABLE_MACROS, "If checked, the operator will set macros with entry depending values as name, path or type. This allows to get some control in the subprocess.", false));
        type = new ParameterTypeString(PARAMETER_ENTRY_NAME_MACRO, "If filled, a macro with this name will be set to the name of the current entry. To get access on the full path including the containing directory, combine this with the folder macro. Can be left blank.", true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_MACROS, false, true));
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_ENTRY_TYPE_MACRO, "Will be set to whether this entry is of type 'process', 'object' or 'file'. Can be left blank.", true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_MACROS, false, true));
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_FOLDER_NAME_MACRO, "If filled, a macro with this name will be set to the containing folder of the current entry. To get access on the full path you can combine this with the name macro. Can be left blank.", true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_MACROS, false, true));
        types.add((ParameterType)type);
        for (ParameterType currentType : types) {
            currentType.setExpert(false);
        }
        List<ParameterType> superTypes = super.getParameterTypes();
        types.addAll(superTypes);
        type = superTypes.get(0);
        if (types.remove(type)) {
            types.add(0, (ParameterType)type);
        }
        return types;
    }

    public OperatorVersion[] getIncompatibleVersionChanges() {
        return new OperatorVersion[]{OPERATOR_VERSION_0_0_11};
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

