/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.loops.time;

import com.owc.data.exampleset.SortedExampleSet;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Iterator;

public class ExampleSetBasedTimepointIterator
implements Iterator<ZonedDateTime> {
    private final Operator loopTimeWindowsOperator;
    private ExampleSet sortedData;
    private int endIndex = -2;
    private int currentIndex = -2;
    private ZoneId zone;
    private Attribute timestampAttribute;
    private double lastTimestamp = Double.NaN;

    public ExampleSetBasedTimepointIterator(Operator loopTimeWindowsOperator, ExampleSet data, String timestampAttributeName, ZonedDateTime windowStartFrom, ZonedDateTime windowStartUntil) throws UserError {
        this.loopTimeWindowsOperator = loopTimeWindowsOperator;
        if (windowStartFrom.compareTo(windowStartUntil) > 0) {
            throw new UserError(this.loopTimeWindowsOperator, "toolkit.start_may_not_exceed_end");
        }
        this.timestampAttribute = data.getAttributes().get(timestampAttributeName);
        if (this.timestampAttribute == null) {
            throw new UserError(this.loopTimeWindowsOperator, "toolkit.attribute_not_found", new Object[]{timestampAttributeName});
        }
        if (!this.timestampAttribute.isDateTime()) {
            throw new UserError(this.loopTimeWindowsOperator, "toolkit.attribute_not_datetime", new Object[]{timestampAttributeName, loopTimeWindowsOperator.getName(), "window_start_attribute"});
        }
        double after = windowStartFrom.toInstant().toEpochMilli();
        double before = windowStartUntil.toInstant().toEpochMilli();
        this.zone = windowStartFrom.getZone();
        this.sortedData = new SortedExampleSet(data, 1, false, this.timestampAttribute);
        int i = 0;
        double oldTimestamp = Double.NEGATIVE_INFINITY;
        for (Example example : this.sortedData) {
            double timestamp = example.getValue(this.timestampAttribute);
            if (timestamp != oldTimestamp) {
                if (!(timestamp < before)) break;
                if (timestamp >= after && this.currentIndex == -2) {
                    this.currentIndex = i - 1;
                }
                this.endIndex = i;
                oldTimestamp = timestamp;
            }
            ++i;
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.endIndex;
    }

    @Override
    public ZonedDateTime next() {
        ++this.currentIndex;
        if (this.currentIndex > this.endIndex) {
            throw new IllegalArgumentException("No next element");
        }
        double timestamp = this.sortedData.getExample(this.currentIndex).getValue(this.timestampAttribute);
        while (timestamp == this.lastTimestamp) {
            ++this.currentIndex;
            timestamp = this.sortedData.getExample(this.currentIndex).getValue(this.timestampAttribute);
        }
        this.lastTimestamp = timestamp;
        return Instant.ofEpochMilli((long)timestamp).atZone(this.zone);
    }
}

