/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.loops.time;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.UndefinedParameterError;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;

public class IntervalbasedTimepointIterator
implements Iterator<ZonedDateTime> {
    private final Operator loopTimeWindowsOperator;
    private int intervalValue;
    private ChronoUnit intervalUnit;
    private ZonedDateTime windowStartUntil;
    private ZonedDateTime nextStart;

    public IntervalbasedTimepointIterator(Operator loopTimeWindowsOperator, ZonedDateTime windowStartFrom, ZonedDateTime windowStartUntil, String intervalTupelAsString) throws OperatorException {
        this.loopTimeWindowsOperator = loopTimeWindowsOperator;
        if (windowStartFrom.compareTo(windowStartUntil) > 0) {
            throw new UserError(this.loopTimeWindowsOperator, "toolkit.start_may_not_exceed_end");
        }
        this.windowStartUntil = windowStartUntil;
        this.nextStart = windowStartFrom;
        String[] intervalTupel = ParameterTypeTupel.transformString2Tupel((String)intervalTupelAsString);
        try {
            if (intervalTupel[0] == null) {
                throw new UndefinedParameterError("window_width", this.loopTimeWindowsOperator);
            }
            this.intervalValue = Integer.parseInt(intervalTupel[0]);
            this.intervalUnit = ChronoUnit.valueOf(intervalTupel[1]);
        }
        catch (NumberFormatException e1) {
            throw new OperatorException("toolkit.illegal_numeric_parameter_value", (Throwable)e1, new Object[]{"window_width", intervalTupel[0]});
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextStart.compareTo(this.windowStartUntil) <= 0;
    }

    @Override
    public ZonedDateTime next() {
        ZonedDateTime value = this.nextStart;
        this.nextStart = this.nextStart.plus(this.intervalValue, this.intervalUnit);
        return value;
    }
}

