/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.preprocessing.transformation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.preprocessing.filter.AbstractDateDataProcessing;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDateFormat;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.Tools;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;

public class NominalToDateOperator
extends AbstractDateDataProcessing {
    private static final String ATTRIBUTE_NAME_POSTFIX = "_nominal";
    private AttributeSubsetSelector selector = new AttributeSubsetSelector(this.getParameterHandler(), this.getExampleSetInputPort(), new int[]{1});
    public static final String PARAMETER_DATE_TYPE = "date_type";
    public static final String PARAMETER_DATE_FORMAT = "date_format";
    public static final String PARAMETER_TIME_ZONE = "time_zone";
    public static final String PARAMETER_LOCALE = "locale";
    public static final String[] VALUE_TYPES = new String[]{"date", "time", "date_time"};
    public static int VALUE_TYPES_DATE_INDEX = 0;
    public static int VALUE_TYPES_TIME_INDEX = 1;
    public static int VALUE_TYPES_DATE_TIME_INDEX = 2;
    public static final String PARAMETER_KEEP_OLD_ATTRIBUTES = "keep_old_attributes";
    public static final String PARAMETER_SUFFIX = "suffix";

    public NominalToDateOperator(OperatorDescription description) {
        super(description);
    }

    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        int localeIndex;
        int timeZone;
        String datePattern;
        ExampleSetMetaData subsetMetaData = this.selector.getMetaDataSubset(metaData, false, true);
        int selectedDateTypeIndex = this.getParameterAsInt(PARAMETER_DATE_TYPE);
        if (selectedDateTypeIndex < 0 || selectedDateTypeIndex >= VALUE_TYPES.length) {
            this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "undefined_parameter", new Object[]{PARAMETER_DATE_TYPE}));
        }
        if ((datePattern = this.getParameterAsString(PARAMETER_DATE_FORMAT)) == null || datePattern.isEmpty()) {
            this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "undefined_parameter", new Object[]{PARAMETER_DATE_FORMAT}));
        }
        if ((timeZone = this.getParameterAsInt(PARAMETER_TIME_ZONE)) < 0 || timeZone >= Tools.getAllTimeZones().length) {
            this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "undefined_parameter", new Object[]{PARAMETER_TIME_ZONE}));
        }
        if ((localeIndex = this.getParameterAsInt(PARAMETER_LOCALE)) < 0 || localeIndex >= availableLocales.size()) {
            this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "undefined_parameter", new Object[]{PARAMETER_LOCALE}));
        }
        SimpleDateFormat formater = null;
        try {
            if (datePattern != null && !datePattern.isEmpty()) {
                formater = new SimpleDateFormat(datePattern, (Locale)availableLocales.get(localeIndex));
            }
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "parameter_invalid_time_format", new Object[]{PARAMETER_DATE_FORMAT}));
        }
        int selectedType = 9;
        if (selectedDateTypeIndex == VALUE_TYPES_DATE_INDEX) {
            selectedType = 10;
        } else if (selectedDateTypeIndex == VALUE_TYPES_TIME_INDEX) {
            selectedType = 11;
        }
        if (formater != null) {
            Collection amds = subsetMetaData.getAllAttributes();
            if (this.getParameterAsBoolean(PARAMETER_KEEP_OLD_ATTRIBUTES)) {
                LinkedList<AttributeMetaData> originalAttributes = new LinkedList<AttributeMetaData>();
                for (AttributeMetaData amd : amds) {
                    AttributeMetaData originalAttribute = amd.clone();
                    originalAttribute.setName(amd.getName() + this.getParameterAsString(PARAMETER_SUFFIX));
                    originalAttributes.add(originalAttribute);
                    metaData.getAttributeByName(amd.getName()).setType(selectedType);
                }
                metaData.addAllAttributes(originalAttributes);
            } else {
                for (AttributeMetaData amd : amds) {
                    metaData.getAttributeByName(amd.getName()).setType(selectedType);
                }
            }
        }
        metaData.numberOfExamplesIsUnkown();
        return metaData;
    }

    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String currentAttributeName;
        SimpleDateFormat formater;
        Set selectedAttributes = this.selector.getAttributeSubset(exampleSet, false, true);
        int selectedDateTypeIndex = this.getParameterAsInt(PARAMETER_DATE_TYPE);
        if (selectedDateTypeIndex < 0 || selectedDateTypeIndex >= VALUE_TYPES.length) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_DATE_TYPE});
        }
        String datePattern = this.getParameterAsString(PARAMETER_DATE_FORMAT);
        if (datePattern == null || datePattern.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_DATE_FORMAT});
        }
        int timeZone = this.getParameterAsInt(PARAMETER_TIME_ZONE);
        if (timeZone < 0 || timeZone >= Tools.getAllTimeZones().length) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_TIME_ZONE});
        }
        int localeIndex = this.getParameterAsInt(PARAMETER_LOCALE);
        if (localeIndex < 0 || localeIndex >= availableLocales.size()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_LOCALE});
        }
        TimeZone selectedTimeZone = Tools.getTimeZone((int)timeZone);
        Locale selectedLocale = (Locale)availableLocales.get(localeIndex);
        int selectedDateType = selectedDateTypeIndex == VALUE_TYPES_DATE_INDEX ? 10 : (selectedDateTypeIndex == VALUE_TYPES_TIME_INDEX ? 11 : 9);
        try {
            formater = new SimpleDateFormat(datePattern, selectedLocale);
        }
        catch (IllegalArgumentException e) {
            throw new UserError((Operator)this, "invalid_date_format", new Object[]{datePattern, e.getMessage()});
        }
        formater.setTimeZone(selectedTimeZone);
        LinkedHashMap<Object, Attribute> mappedAttributes = new LinkedHashMap<Object, Attribute>();
        for (Object oldAttribute : selectedAttributes) {
            Attribute newAttribute = AttributeFactory.createAttribute((int)selectedDateType);
            mappedAttributes.put(oldAttribute, newAttribute);
            exampleSet.getExampleTable().addAttribute(newAttribute);
            exampleSet.getAttributes().addRegular(newAttribute);
        }
        int row = 1;
        for (Example example : exampleSet) {
            for (Attribute nominalAttribute : selectedAttributes) {
                Date date;
                if (Double.isNaN(example.getValue(nominalAttribute))) {
                    example.setValue((Attribute)mappedAttributes.get(nominalAttribute), Double.NaN);
                    continue;
                }
                String nominalDate = example.getValueAsString(nominalAttribute);
                try {
                    date = formater.parse(nominalDate);
                }
                catch (ParseException e) {
                    throw new UserError((Operator)this, 931, new Object[]{datePattern, nominalAttribute.getName(), row, e.getMessage().replaceAll("\"", "'")});
                }
                if (selectedDateTypeIndex == VALUE_TYPES_TIME_INDEX) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    calendar.set(1970, 1, 1);
                    example.setValue((Attribute)mappedAttributes.get(nominalAttribute), (double)calendar.getTimeInMillis());
                    continue;
                }
                example.setValue((Attribute)mappedAttributes.get(nominalAttribute), (double)date.getTime());
            }
            ++row;
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_OLD_ATTRIBUTES)) {
            for (Attribute attribute : selectedAttributes) {
                currentAttributeName = attribute.getName();
                exampleSet.getAttributes().remove(attribute);
                ((Attribute)mappedAttributes.get(attribute)).setName(currentAttributeName);
            }
        } else {
            for (Attribute attribute : selectedAttributes) {
                Attribute newAttribute = (Attribute)mappedAttributes.remove(attribute);
                currentAttributeName = attribute.getName();
                attribute.setName(currentAttributeName + this.getParameterAsString(PARAMETER_SUFFIX));
                newAttribute.setName(currentAttributeName);
            }
        }
        return exampleSet;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.addAll(this.selector.getParameterTypes());
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_DATE_TYPE, "Desired value types for the transformed attributes.", VALUE_TYPES, 0);
        type.setExpert(false);
        type.setOptional(false);
        types.add(type);
        type = new ParameterTypeDateFormat(PARAMETER_DATE_FORMAT, "Defines the given date/time patterns of the selected nominal values.", "", false);
        type.setOptional(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_TIME_ZONE, "Select the timezone to which the selected Attributes should be assigned to.", Tools.getAllTimeZones(), Tools.getPreferredTimeZoneIndex(), false);
        type.setOptional(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_LOCALE, "Is used to translate language specific Information (e.g. \"Wed\" would be shown for the weekday wednesday in an english location and \"Mi\" for a german location).", availableLocaleNames, defaultLocale, false);
        type.setOptional(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KEEP_OLD_ATTRIBUTES, "If enabled, the selected nominal attribute names will be extended with a suffix and otherwise their values will be replaced by the transformed values.", false, false);
        types.add(type);
        ParameterTypeString suffix = new ParameterTypeString(PARAMETER_SUFFIX, "A suffix that will be added to the selected nominal attributes.", ATTRIBUTE_NAME_POSTFIX, false);
        suffix.setOptional(false);
        suffix.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition(this.getParameterHandler(), PARAMETER_KEEP_OLD_ATTRIBUTES, false, true));
        types.add(suffix);
        return types;
    }
}

