/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.process;

import com.owc.operator.process.ExecuteProcessOperator;
import com.owc.process.DebugProcess;
import com.rapidminer.Process;
import com.rapidminer.ProcessLocation;
import com.rapidminer.RepositoryProcessLocation;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.wizards.AbstractConfigurationWizardCreator;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.tools.XMLException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class CreateProcessSpecificationsWizard
extends AbstractConfigurationWizardCreator {
    private static final long serialVersionUID = 4774333804247004553L;

    public String getI18NKey() {
        return "toolkit.create_process_specifications";
    }

    public void createConfigurationWizard(ParameterType type, ConfigurationListener listener) {
        block9: {
            try {
                ExecuteProcessOperator operator = (ExecuteProcessOperator)listener;
                IOContainer debugInputs = operator.getDebugInputs();
                HashMap<String, String> debugMacros = operator.getDebugMacros();
                if (debugInputs == null || debugMacros == null) {
                    SwingTools.showSimpleErrorMessage((String)"no_execution_data", (String)"You can only create specifications if execution data is present. Therefore there needs to be set a breakpoint after or the data is still available.", (Object[])new Object[0]);
                    return;
                }
                RepositoryLocation repositoryLocation = operator.getParameterAsRepositoryLocation("process_location");
                if (repositoryLocation == null || !(repositoryLocation.locateEntry() instanceof ProcessEntry)) break block9;
                RapidMinerGUI.getMainFrame().close();
                Entry entry = repositoryLocation.locateEntry();
                if (!(entry instanceof ProcessEntry)) break block9;
                RepositoryProcessLocation processLocation = new RepositoryProcessLocation(repositoryLocation);
                String rawXML = processLocation.getRawXML();
                try {
                    HashMap<String, String> macroMap = operator.getDebugMacros();
                    IOObject[] ioObjects = operator.getDebugInputs().getIOObjects();
                    DebugProcess process = new DebugProcess(rawXML, macroMap, ioObjects);
                    process.setProcessLocation((ProcessLocation)processLocation);
                    this.ensureSpecificationsArePresent(process, ioObjects, macroMap, operator);
                }
                catch (XMLException ex) {
                    try {
                        RapidMinerGUI.getMainFrame().handleBrokenProxessXML((ProcessLocation)processLocation, processLocation.getRawXML(), (Exception)((Object)ex));
                    }
                    catch (IOException e) {
                        SwingTools.showSimpleErrorMessage((String)"while_loading", (Throwable)e, (Object[])new Object[]{processLocation, e.getMessage()});
                        return;
                    }
                }
            }
            catch (RepositoryException repositoryException) {
            }
            catch (UserError userError) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void ensureSpecificationsArePresent(Process process, IOObject[] ioObjects, HashMap<String, String> macroMap, Operator operator) {
        try {
            RepositoryProcessLocation processLocation = (RepositoryProcessLocation)process.getProcessLocation();
            RepositoryLocation specificationFolder = new RepositoryLocation(processLocation.getRepositoryLocation().parent(), "specifications/" + processLocation.getShortName());
            specificationFolder.createFoldersRecursively();
            for (int i = 0; i < ioObjects.length; ++i) {
                if (ioObjects[i] == null) continue;
                String fragmentName = "in 0" + (i + 1) + " - " + RendererService.getName(ioObjects[i].getClass());
                if (i > 9) {
                    fragmentName = "in " + (i + 1) + " - " + RendererService.getName(ioObjects[i].getClass());
                }
                RepositoryLocation specificationFragmentLocation = new RepositoryLocation(specificationFolder, fragmentName);
                RepositoryManager.getInstance(null).store(ioObjects[i], specificationFragmentLocation, operator);
                process.getContext().setInputRepositoryLocation(i, "specifications/" + processLocation.getShortName() + "/" + fragmentName);
            }
            List contextMacros = process.getContext().getMacros();
            contextMacros.forEach(pair -> {
                String newValue = (String)macroMap.get(pair.getFirst());
                if (newValue != null) {
                    pair.setSecond((Object)newValue);
                }
            });
            process.getContext().setMacros(contextMacros);
            try {
                process.save();
            }
            catch (IOException iOException) {}
        }
        catch (MalformedRepositoryLocationException | RepositoryException e) {
            e.printStackTrace();
        }
    }
}

