/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.process;

import com.owc.license.ProductInformation;
import com.owc.operator.OrderedPortOperator;
import com.owc.operator.process.AnonymousProcess;
import com.owc.operator.process.CreateProcessSpecificationsWizard;
import com.owc.operator.process.DebugProcessWizard;
import com.owc.operator.process.MacroCopyWizard;
import com.owc.operator.process.OpenProcessWizard;
import com.rapidminer.Process;
import com.rapidminer.ProcessLocation;
import com.rapidminer.RapidMiner;
import com.rapidminer.RepositoryProcessLocation;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.XMLException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ExecuteProcessOperator
extends OrderedPortOperator {
    public static final String PARAMETER_PROCESS_ENTRY = "process_location";
    public static final String PARAMETER_OPEN_PROCESS = "open_process";
    public static final String PARAMETER_DEBUG_PROCESS = "debug_process";
    public static final String PARAMETER_CREATE_SPECIFICATIONS = "create_process_specifications";
    public static final String PARAMETER_ALLOW_GRACIOUS_STOP = "allow_gracious_stop";
    public static final String PARAMETER_INHERIT_MACROS = "inherit_macros";
    public static final String PARAMETER_INHERIT_PROCESS_LOCATION = "inherit_location";
    public static final String PARAMETER_COPY_MACROS = "copy_macros";
    public static final String PARAMETER_MACROS = "macros";
    public static final String PARAMETER_MACRO_NAME = "macro_name";
    public static final String PARAMETER_MACRO_VALUE = "macro_value";
    private InputPort inThroughPort = (InputPort)this.getInputPorts().createPort("through");
    private OutputPort outThroughPort = (OutputPort)this.getOutputPorts().createPort("through");
    private InputPortExtender inputPortExtender = new InputPortExtender("input", (Ports)this.getInputPorts());
    private OutputPortExtender outputPortExtender = new OutputPortExtender("output", (Ports)this.getOutputPorts());
    private SoftReference<IOContainer> softDebugInput;
    private SoftReference<HashMap<String, String>> softDebugMacros;
    private IOContainer debugInput;
    private HashMap<String, String> debugMacros;

    public ExecuteProcessOperator(OperatorDescription description) {
        super(description);
        this.inputPortExtender.start();
        this.outputPortExtender.start();
        this.getTransformer().addPassThroughRule(this.inThroughPort, this.outThroughPort);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        block20: {
            if (!isLicensed) {
                throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
            }
            this.clearDebugState();
            RepositoryLocation processLocation = this.getParameterAsRepositoryLocation(PARAMETER_PROCESS_ENTRY);
            try {
                if (processLocation != null) {
                    IOContainer result;
                    HashMap<String, String> macroMap = this.deriveMacros();
                    LinkedList<IOObject> inputs = this.getObjectsFromInputPorts();
                    IOContainer input = new IOContainer(inputs);
                    Entry entry = processLocation.locateEntry();
                    if (entry == null || !(entry instanceof ProcessEntry)) {
                        throw new UserError((Operator)this, "toolkit.no_process", new Object[]{this.getParameterAsString(PARAMETER_PROCESS_ENTRY)});
                    }
                    Process parentProcess = this.getProcess();
                    AnonymousProcess process = new AnonymousProcess(new RepositoryProcessLocation(processLocation).load(null).getRootOperator().getXML(false), input, parentProcess);
                    if (this.getParameterAsBoolean(PARAMETER_INHERIT_PROCESS_LOCATION)) {
                        process.setProcessLocation(this.getProcess().getProcessLocation());
                    } else {
                        process.setProcessLocation((ProcessLocation)new RepositoryProcessLocation(processLocation));
                    }
                    process.setRepositoryAccessor(this.getProcess().getRepositoryAccessor());
                    try {
                        process.setOmitNullResults(false);
                        result = process.runAnonymously(input, 7, macroMap);
                    }
                    catch (ProcessStoppedException e) {
                        if (this.getParameterAsBoolean(PARAMETER_ALLOW_GRACIOUS_STOP)) {
                            this.checkForStop();
                            result = new IOContainer();
                        }
                        throw e;
                    }
                    catch (UserError e) {
                        this.rememberDebugState(input, macroMap);
                        StringBuilder builder = new StringBuilder();
                        Iterator iterator = process.getMacroHandler().getDefinedMacroNames();
                        while (iterator.hasNext()) {
                            String name = (String)iterator.next();
                            builder.append(name);
                            builder.append(":");
                            builder.append(process.getMacroHandler().getMacro(name));
                            builder.append(",\n");
                        }
                        throw new UserError((Operator)this, (Throwable)e, "toolkit.inner_process_error", new Object[]{e.getOperator().getName(), e.getLocalizedMessage(), builder.toString()});
                    }
                    catch (OperatorException e) {
                        this.rememberDebugState(input, macroMap);
                        StringBuilder builder = new StringBuilder();
                        Iterator iterator = process.getMacroHandler().getDefinedMacroNames();
                        while (iterator.hasNext()) {
                            String name = (String)iterator.next();
                            builder.append(name);
                            builder.append(":");
                            builder.append(process.getMacroHandler().getMacro(name));
                            builder.append(",\n");
                        }
                        throw new OperatorException("toolkit.inner_process_error", (Throwable)e, new Object[]{this.getParameterAsString(PARAMETER_PROCESS_ENTRY), e.getMessage(), builder.toString()});
                    }
                    int i = 0;
                    for (OutputPort port : this.outputPortExtender.getManagedPorts()) {
                        if (i >= result.size()) break;
                        port.deliver(result.getElementAt(i));
                        ++i;
                    }
                    if (this.hasBreakpoint(1)) {
                        this.rememberDebugState(input, macroMap);
                    } else {
                        this.tryRememberDebugState(input, macroMap);
                    }
                    break block20;
                }
                throw new UserError((Operator)this, "toolkit.no_process", new Object[]{this.getParameterAsString(PARAMETER_PROCESS_ENTRY)});
            }
            catch (RepositoryException e) {
                throw new OperatorException("toolkit.cannot_access_repository", (Throwable)e, new Object[]{e.getMessage()});
            }
            catch (IOException e) {
                throw new OperatorException("toolkit.cannot_access_repository", (Throwable)e, new Object[]{e.getMessage()});
            }
            catch (XMLException e) {
                throw new OperatorException("toolkit.illegal_process", (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        IOObject object = this.inThroughPort.getDataOrNull(IOObject.class);
        if (object != null) {
            this.outThroughPort.deliver(object);
        }
    }

    protected HashMap<String, String> deriveMacros() throws UndefinedParameterError {
        HashMap<String, String> macroMap = new HashMap<String, String>();
        if (this.getParameterAsBoolean(PARAMETER_INHERIT_MACROS)) {
            Iterator definedMacros = this.getProcess().getMacroHandler().getDefinedMacroNames();
            while (definedMacros.hasNext()) {
                String macroName = (String)definedMacros.next();
                macroMap.put(macroName, this.getProcess().getMacroHandler().getMacro(macroName));
            }
        }
        List macroList = this.getParameterList(PARAMETER_MACROS);
        for (String[] pair : macroList) {
            macroMap.put(pair[0], pair[1]);
        }
        return macroMap;
    }

    private void tryRememberDebugState(IOContainer input, HashMap<String, String> macros) {
        if (!RapidMiner.getExecutionMode().isHeadless()) {
            this.softDebugInput = new SoftReference<IOContainer>(input);
            this.softDebugMacros = new SoftReference<HashMap<String, String>>(macros);
        }
    }

    private void rememberDebugState(IOContainer input, HashMap<String, String> macros) {
        if (!RapidMiner.getExecutionMode().isHeadless()) {
            this.debugInput = input;
            this.debugMacros = macros;
        }
    }

    private void clearDebugState() {
        this.softDebugInput = null;
        this.softDebugMacros = null;
        this.debugInput = null;
        this.debugMacros = null;
    }

    private LinkedList<IOObject> getObjectsFromInputPorts() {
        LinkedList<IOObject> inputs = new LinkedList<IOObject>();
        LinkedList<Boolean> delivered = new LinkedList<Boolean>();
        for (InputPort inputPort : this.inputPortExtender.getManagedPorts()) {
            inputs.add(inputPort.getAnyDataOrNull());
            delivered.add(inputPort.isConnected());
        }
        while (!inputs.isEmpty() && inputs.peekLast() == null && !((Boolean)delivered.pollLast()).booleanValue()) {
            inputs.pollLast();
        }
        return inputs;
    }

    public IOContainer getDebugInputs() {
        if (this.debugInput != null) {
            return this.debugInput;
        }
        if (this.softDebugInput != null) {
            return this.softDebugInput.get();
        }
        return null;
    }

    public HashMap<String, String> getDebugMacros() {
        if (this.debugMacros != null) {
            return this.debugMacros;
        }
        if (this.softDebugMacros != null) {
            return this.softDebugMacros.get();
        }
        return null;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeRepositoryLocation(PARAMETER_PROCESS_ENTRY, "Select the process from the repository, that will be executed asynchronously in the background.", false));
        ParameterTypeConfiguration type = new ParameterTypeConfiguration(OpenProcessWizard.class, (ConfigurationListener)this);
        type.setKey(PARAMETER_OPEN_PROCESS);
        type.setDescription("This button will open the linked processes.");
        types.add((ParameterType)type);
        type = new ParameterTypeConfiguration(DebugProcessWizard.class, (ConfigurationListener)this);
        type.setKey(PARAMETER_DEBUG_PROCESS);
        type.setDescription("This button will open the linked processes with the currently stored input and macro values.");
        types.add((ParameterType)type);
        type = new ParameterTypeConfiguration(CreateProcessSpecificationsWizard.class, (ConfigurationListener)this);
        type.setKey(PARAMETER_CREATE_SPECIFICATIONS);
        type.setDescription("This button will save the input as specifications.");
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_ALLOW_GRACIOUS_STOP, "If checked, the inner process may terminate graciously. This operator will successfully end but not return any results.", true, false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_INHERIT_MACROS, "If checked, all defined macros of this process will be set for the executed process to the same values. Can be used to propagate things as usernames, etc.", true, false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_INHERIT_PROCESS_LOCATION, "If checked, the executed process will get the location of the calling process (hence this current process). This can be used to store results relatively to the calling process' location.", false, true));
        type = new ParameterTypeConfiguration(MacroCopyWizard.class, (ConfigurationListener)this);
        type.setKey(PARAMETER_COPY_MACROS);
        type.setDescription("This button will copy the macros from the context of the linked process.");
        types.add((ParameterType)type);
        type = new ParameterTypeList(PARAMETER_MACROS, "Defines macros the process executed in the background.", (ParameterType)new ParameterTypeString(PARAMETER_MACRO_NAME, "The name of the macro.", false), (ParameterType)new ParameterTypeString(PARAMETER_MACRO_VALUE, "The value of the macro.", false), true);
        type.setExpert(false);
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

