/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.process.collection;

import com.owc.license.ProductInformation;
import com.owc.objects.indexed.IndexedIOObject;
import com.owc.objects.indexed.IndexedIOObjectsCollection;
import com.owc.operator.LicensedOperator;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.tools.Ontology;
import java.util.LinkedList;
import java.util.List;

public class SelectIndexedIOObjectOperator
extends LicensedOperator {
    InputPort indexedIOObjectsInputPort = (InputPort)this.getInputPorts().createPort("indexedIOObject");
    OutputPort ioobjectResultPort = (OutputPort)this.getOutputPorts().createPort("ioobject");
    public static String PARAMETER_GROUP_INFORMATION = "group_information";
    public static String PARAMETER_GROUP_ATTRIBUTE_INFORMATION = "group_attribute_information";
    public static String PARAMETER_GROUP_ATTRIBUTE_NAME = "attribute_name";
    public static String PARAMETER_GROUP_ATTRIBUTE_TYPE = "attribute_type";
    public static String PARAMETER_GROUP_ATTRIBUTE_VALUE = "value";

    public SelectIndexedIOObjectOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addGenerationRule(this.ioobjectResultPort, IOObject.class);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        IndexedIOObject indexedContainer = (IndexedIOObject)this.indexedIOObjectsInputPort.getData(IndexedIOObject.class);
        List groupInfos = this.getParameterList(PARAMETER_GROUP_INFORMATION);
        LinkedList<String> selectedGroupAttributes = new LinkedList<String>();
        int[] selectedGroupAttributeType = new int[groupInfos.size()];
        String[] nominalValues = new String[groupInfos.size()];
        double[] numericalValues = new double[groupInfos.size()];
        if (groupInfos.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_GROUP_INFORMATION, "Please provide the attribute names, types and values for each group."});
        }
        int i = 0;
        for (String[] currentGroupInfo : groupInfos) {
            String attributeInfo = currentGroupInfo[0];
            String currentGroupValue = currentGroupInfo[1];
            String[] attributeInfoPair = ParameterTypeTupel.transformString2Tupel((String)attributeInfo);
            String currentAttributeName = attributeInfoPair[0];
            String currentAttributeType = attributeInfoPair[1];
            if (currentAttributeName == null) {
                throw new UserError((Operator)this, 205, new Object[]{PARAMETER_GROUP_ATTRIBUTE_NAME, "Please provide a name for each group attribute name."});
            }
            if (currentAttributeType.equals(Ontology.VALUE_TYPE_NAMES[1])) {
                nominalValues[i] = currentGroupValue;
                selectedGroupAttributeType[i] = 1;
            } else {
                try {
                    numericalValues[i] = Double.parseDouble(currentGroupValue);
                    selectedGroupAttributeType[i] = 2;
                }
                catch (NumberFormatException e) {
                    throw new UserError((Operator)this, 120, new Object[]{currentAttributeName, Ontology.VALUE_TYPE_NAMES[1], Ontology.VALUE_TYPE_NAMES[2]});
                }
            }
            ++i;
            selectedGroupAttributes.add(currentAttributeName);
        }
        try {
            IndexedIOObjectsCollection.isCompatible(indexedContainer.getIndexColumnNames(), indexedContainer.getIndexColumnTypes(), selectedGroupAttributes.toArray(new String[0]), selectedGroupAttributeType);
        }
        catch (UserError e) {
            e.setOperator((Operator)this);
            throw e;
        }
        Object resultObject = indexedContainer.get(new IndexedIOObject.IndexedIOObjectKey(nominalValues, numericalValues));
        if (resultObject == null) {
            throw new UserError((Operator)this, "toolkit.indexed_ioobject_container.key_not_found");
        }
        this.ioobjectResultPort.deliver(resultObject);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeString parameterAttributeName = new ParameterTypeString(PARAMETER_GROUP_ATTRIBUTE_NAME, "Please provide a name for each attribute that contains group information. If an indexedModel is provided, the selected Group attributes must be using matching names in the same order!", false);
        ParameterTypeCategory parameterAttributeType = new ParameterTypeCategory(PARAMETER_GROUP_ATTRIBUTE_TYPE, "Please select if the group attribute is either nominal or numerical.", new String[]{Ontology.VALUE_TYPE_NAMES[1], Ontology.VALUE_TYPE_NAMES[2]}, 0, false);
        ParameterTypeTupel parameterGroupAttribute = new ParameterTypeTupel(PARAMETER_GROUP_ATTRIBUTE_INFORMATION, "Please provide Information on the respective attribute- name and type.", new ParameterType[]{parameterAttributeName, parameterAttributeType});
        ParameterTypeString parameterValue = new ParameterTypeString(PARAMETER_GROUP_ATTRIBUTE_VALUE, "Please provide a value for the provided Group Attribute.", false, false);
        ParameterTypeList type = new ParameterTypeList(PARAMETER_GROUP_INFORMATION, "", (ParameterType)parameterGroupAttribute, (ParameterType)parameterValue, false);
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

