/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.series;

import com.owc.operator.series.LastKnownValueInterpolator;
import com.owc.operator.series.PolynomialSplineFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.util.MathArrays;

public class LinearInterpolator
implements UnivariateInterpolator {
    @Override
    public UnivariateFunction interpolate(double[] x, double[] y) throws DimensionMismatchException, NonMonotonicSequenceException {
        if (x.length != y.length) {
            throw new DimensionMismatchException(x.length, y.length);
        }
        if (x.length < 2) {
            return new LastKnownValueInterpolator(x, y);
        }
        int n = x.length - 1;
        MathArrays.checkOrder(x, MathArrays.OrderDirection.INCREASING, false);
        double[] m = new double[n];
        for (int i = 0; i < n; ++i) {
            m[i] = (y[i + 1] - y[i]) / (x[i + 1] - x[i]);
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n];
        double[] coefficients = new double[2];
        for (int i = 0; i < n; ++i) {
            coefficients[0] = y[i];
            coefficients[1] = m[i];
            polynomials[i] = new PolynomialFunction(coefficients);
        }
        return new PolynomialSplineFunction(x, polynomials);
    }
}

