/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.series;

import com.owc.data.exampleset.SortedExampleSet;
import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.tools.Ontology;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.function.StepFunction;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;

public class ResampleSeriesOperator
extends LicensedOperator {
    public static String PARAMETER_TIME_INDEX_ATTRIBUTE = "time_index_attribute";
    public static String PARAMETER_SAMPLE_DISTANCE = "sample_distance";
    private InputPort exampleSetInputPort = this.getInputPorts().createPort("exampleset input", ExampleSet.class);
    private OutputPort exampleSetOutputPort = (OutputPort)this.getOutputPorts().createPort("exampleSet output");
    private OutputPort originalOutputPort = (OutputPort)this.getOutputPorts().createPort("original output");
    private AttributeSubsetSelector selector = new AttributeSubsetSelector((ParameterHandler)this, this.exampleSetInputPort);

    public ResampleSeriesOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInputPort.addPrecondition(this.selector.makePrecondition());
        this.getTransformer().addPassThroughRule(this.exampleSetInputPort, this.exampleSetOutputPort);
        this.getTransformer().addPassThroughRule(this.exampleSetInputPort, this.originalOutputPort);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        Object set = (ExampleSet)this.exampleSetInputPort.getData(ExampleSet.class);
        double sampleDistance = this.getParameterAsDouble(PARAMETER_SAMPLE_DISTANCE);
        String indexAttributeName = this.getParameterAsString(PARAMETER_TIME_INDEX_ATTRIBUTE);
        Attribute indexAttribute = set.getAttributes().get(indexAttributeName);
        if (indexAttribute == null) {
            throw new UserError((Operator)this, "toolkit.resample_series_data.attribute_missing", new Object[]{indexAttributeName});
        }
        if (!indexAttribute.isNumerical() && !indexAttribute.isDateTime()) {
            throw new UserError((Operator)this, "toolkit.2", new Object[]{indexAttributeName, this.getName(), "time index attribute"});
        }
        set = new SortedExampleSet((ExampleSet)set, 1, false, new Attribute[]{indexAttribute});
        Set resampleAttributes = this.selector.getAttributeSubset(set, false);
        resampleAttributes.remove(indexAttribute);
        double[] indices = new double[set.size()];
        double lastIndexValue = Double.NaN;
        int i = 0;
        double minIndex = Double.POSITIVE_INFINITY;
        double maxIndex = Double.NEGATIVE_INFINITY;
        double[][] values = new double[resampleAttributes.size()][set.size()];
        for (Example example : set) {
            double indexValue = example.getValue(indexAttribute);
            if (Double.compare(indexValue, lastIndexValue) != 0) {
                indices[i] = indexValue;
                if (Double.isNaN(indexValue)) {
                    throw new UserError((Operator)this, "toolkit.2", new Object[]{indexAttributeName, this.getName(), "time index attribute"});
                }
                minIndex = Math.min(minIndex, indexValue);
                maxIndex = Math.max(maxIndex, indexValue);
                int j = 0;
                for (Object resampleAttribute : resampleAttributes) {
                    values[j++][i] = example.getValue((Attribute)resampleAttribute);
                }
                ++i;
            } else {
                throw new UserError((Operator)this, "toolkit.resample_series_data.duplicates", new Object[]{indexAttributeName});
            }
            lastIndexValue = indexValue;
        }
        minIndex += sampleDistance;
        minIndex -= minIndex % sampleDistance;
        if (i < set.size()) {
            for (int j = 0; j < resampleAttributes.size(); ++j) {
                double[] longValues = values[j];
                values[j] = new double[i];
                System.arraycopy(longValues, 0, values[j], 0, i);
            }
        }
        String[] newAttributeNames = new String[1 + resampleAttributes.size()];
        int[] newAttributeTypes = new int[1 + resampleAttributes.size()];
        newAttributeNames[0] = indexAttribute.getName();
        newAttributeTypes[0] = indexAttribute.getValueType();
        i = 1;
        for (Attribute attribute : resampleAttributes) {
            newAttributeNames[i] = attribute.getName();
            newAttributeTypes[i++] = attribute.getValueType();
        }
        ExampleSetCreator creator = new ExampleSetCreator(newAttributeNames, newAttributeTypes);
        UnivariateFunction[] interpolationFunctions = new UnivariateFunction[resampleAttributes.size()];
        i = 0;
        for (Attribute resampleAttribute : resampleAttributes) {
            interpolationFunctions[i] = resampleAttribute.isDateTime() || Ontology.ATTRIBUTE_VALUE_TYPE.isA(resampleAttribute.getValueType(), 4) ? new LinearInterpolator().interpolate(indices, values[i]) : new StepFunction(indices, values[i]);
            ++i;
        }
        for (double currentIndex = minIndex; currentIndex <= maxIndex; currentIndex += sampleDistance) {
            creator.setValue(indexAttributeName, currentIndex);
            i = 0;
            for (Attribute resampleAttribute : resampleAttributes) {
                if (resampleAttribute.isDateTime() || resampleAttribute.isNumerical()) {
                    creator.setValue(resampleAttribute.getName(), interpolationFunctions[i].value(currentIndex));
                } else {
                    creator.setValue(resampleAttribute.getName(), resampleAttribute.getMapping().mapIndex((int)interpolationFunctions[i].value(currentIndex)));
                }
                ++i;
            }
            creator.commit();
        }
        ExampleSet resultSet = creator.finish();
        Attributes setAttributes = set.getAttributes();
        for (Attribute resampleAttribute : resampleAttributes) {
            AttributeRole newRole = setAttributes.getRole(resampleAttribute);
            AttributeRole role = resultSet.getAttributes().getRole(resampleAttribute.getName());
            role.setSpecial(newRole.getSpecialName());
        }
        this.exampleSetOutputPort.deliver((IOObject)resultSet);
        this.originalOutputPort.deliver((IOObject)set);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeAttribute(PARAMETER_TIME_INDEX_ATTRIBUTE, "Specifies the time index of each example in the series. Needs to be numerical.", this.exampleSetInputPort, new int[]{2}));
        types.addAll(this.selector.getParameterTypes());
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_SAMPLE_DISTANCE, "The time distance between two new sample positions. Is in the original time index attribute's scale and unit.", Double.MIN_VALUE, 2.147483647E9, false));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }

    public static void main(String[] args) {
        int[] bigArray = new int[0x7FFFFFF5];
        bigArray[0x7FFFFFF4] = 55;
    }
}

