/*
 * Decompiled with CFR 0.152.
 */
package com.owc.parameters;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.UndefinedParameterError;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ParameterTools {
    public static final ThreadLocal<SimpleDateFormat> PARAMETER_TYPE_DATE_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy.MM.dd HH:mm:ss Z");
        }
    };

    public static Date getParameterAsDate(String key, Operator operator) throws UndefinedParameterError, UserError {
        String value = operator.getParameter(key);
        if (value == null || value.trim().isEmpty()) {
            throw new UndefinedParameterError(key, operator);
        }
        try {
            return PARAMETER_TYPE_DATE_DATE_FORMAT.get().parse(value);
        }
        catch (ParseException e) {
            throw new UserError(operator, "wrong_date_format", new Object[]{value, key.replace('_', ' ')});
        }
    }
}

