/*
 * Decompiled with CFR 0.152.
 */
package com.owc.repository;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.owc.repository.WebDAVBinaryEntry;
import com.owc.repository.WebDAVEntry;
import com.owc.repository.WebDAVObjectEntry;
import com.owc.repository.WebDAVProcessEntry;
import com.owc.repository.WebDAVRepository;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.repository.BlobEntry;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.tools.ProgressListener;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;

public class WebDAVFolder
extends WebDAVEntry
implements Folder {
    public static final QName QNAME_FOLDER = new QName("DAV:", "collection", "d");
    protected Object entriesLock = new Object();
    protected LinkedList<DataEntry> entries = null;
    protected Object subfoldersLock = new Object();
    protected LinkedList<Folder> subfolders = null;

    public WebDAVFolder(WebDAVRepository repository, Sardine sardine, String name) {
        super(repository, sardine, null, name, "folder", "", "", false);
    }

    public WebDAVFolder(WebDAVRepository repository, Sardine sardine, WebDAVFolder containingFolder, String entryName, String owner, String description, boolean isReadOnly) throws RepositoryException {
        super(repository, sardine, containingFolder, entryName, "folder", owner, description, isReadOnly);
        try {
            sardine.createDirectory(this.getDAVURL());
        }
        catch (IOException e) {
            throw new RepositoryException("Cannot create direcotry.", (Throwable)e);
        }
    }

    public WebDAVFolder(WebDAVRepository repository, Sardine sardine, WebDAVFolder containingFolder, DavResource entryDescription) {
        super(repository, sardine, containingFolder, entryDescription.getName(), "folder", null, entryDescription.getCustomPropsNS().get(QNAME_DESCRIPTION), false);
        try {
            this.owner = sardine.getAcl(this.getDAVURL()).getOwner();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataEntry> getDataEntries() throws RepositoryException {
        Object object = this.entriesLock;
        synchronized (object) {
            if (this.entries == null) {
                this.entries = new LinkedList();
                try {
                    List<DavResource> entryDescriptions = this.sardine.list(this.getDAVURL(), 1, true);
                    entryDescriptions.remove(0);
                    block15: for (DavResource entryDescription : entryDescriptions) {
                        String typeString;
                        if (entryDescription.getResourceTypes().size() == 1 && entryDescription.getResourceTypes().get(0).equals(QNAME_FOLDER) || (typeString = entryDescription.getCustomPropsNS().get(QNAME_TYPE)) == null) continue;
                        switch (typeString) {
                            case "data": {
                                this.addEntry(new WebDAVObjectEntry(this.repository, this.sardine, this, entryDescription));
                                continue block15;
                            }
                            case "blob": {
                                this.addEntry(new WebDAVBinaryEntry(this.repository, this.sardine, this, entryDescription));
                                continue block15;
                            }
                            case "process": {
                                this.addEntry(new WebDAVProcessEntry(this.repository, this.sardine, this, entryDescription));
                                continue block15;
                            }
                        }
                        throw new RepositoryException("Unknown data type");
                    }
                }
                catch (IOException e) {
                    throw new RepositoryException("Cannot connect to repository.", (Throwable)e);
                }
            }
        }
        return Collections.unmodifiableList(this.entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Folder> getSubfolders() throws RepositoryException {
        Object object = this.subfoldersLock;
        synchronized (object) {
            if (this.subfolders == null) {
                this.subfolders = new LinkedList();
                try {
                    List<DavResource> entryDescriptions = this.sardine.list(this.getDAVURL(), 1, true);
                    entryDescriptions.remove(0);
                    for (DavResource entryDescription : entryDescriptions) {
                        if (entryDescription.getResourceTypes().size() != 1 || !entryDescription.getResourceTypes().get(0).equals(QNAME_FOLDER)) continue;
                        this.addEntry(new WebDAVFolder(this.repository, this.sardine, this, entryDescription));
                    }
                }
                catch (IOException e) {
                    throw new RepositoryException("Cannot connect to repository.", (Throwable)e);
                }
            }
        }
        return Collections.unmodifiableList(this.subfolders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws RepositoryException {
        Object object = this.entriesLock;
        synchronized (object) {
            this.entries = null;
        }
        object = this.subfoldersLock;
        synchronized (object) {
            this.subfolders = null;
        }
        this.repository.fireRefreshed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntry(String name) throws RepositoryException {
        Object object = this.entriesLock;
        synchronized (object) {
            for (DataEntry dataEntry : this.entries) {
                if (!dataEntry.getName().equals(name)) continue;
                return true;
            }
        }
        object = this.subfoldersLock;
        synchronized (object) {
            for (Folder folder : this.subfolders) {
                if (!folder.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder createFolder(String name) throws RepositoryException {
        WebDAVFolder folder = new WebDAVFolder(this.repository, this.sardine, this, name, this.repository.getUsername(), null, false);
        Object object = this.subfoldersLock;
        synchronized (object) {
            this.subfolders.add(folder);
        }
        this.repository.fireEntryAdded(folder, this);
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOObjectEntry createIOObjectEntry(String name, IOObject ioobject, Operator callingOperator, ProgressListener progressListener) throws RepositoryException {
        WebDAVObjectEntry entry = new WebDAVObjectEntry(ioobject, callingOperator, progressListener, this.repository, this.sardine, this, name, this.repository.getUsername(), "", System.currentTimeMillis(), false);
        Object object = this.entriesLock;
        synchronized (object) {
            this.entries.add((DataEntry)entry);
        }
        this.repository.fireEntryAdded(entry, this);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessEntry createProcessEntry(String name, String processXML) throws RepositoryException {
        WebDAVProcessEntry entry = new WebDAVProcessEntry(processXML, this.repository, this.sardine, this, name, this.repository.getUsername(), "", System.currentTimeMillis(), false);
        Object object = this.entriesLock;
        synchronized (object) {
            this.entries.add((DataEntry)entry);
        }
        this.repository.fireEntryAdded(entry, this);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobEntry createBlobEntry(String name) throws RepositoryException {
        WebDAVBinaryEntry entry = new WebDAVBinaryEntry(this.repository, this.sardine, this, name, this.repository.getUsername(), "", System.currentTimeMillis(), false);
        Object object = this.entriesLock;
        synchronized (object) {
            this.entries.add((DataEntry)entry);
        }
        this.repository.fireEntryAdded(entry, this);
        return entry;
    }

    public boolean canRefreshChild(String childName) throws RepositoryException {
        return this.containsEntry(childName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(WebDAVEntry webDAVEntry) {
        int subfolderIndex = -1;
        int entriesIndex = -1;
        Object object = this.subfoldersLock;
        synchronized (object) {
            subfolderIndex = this.subfolders.indexOf(webDAVEntry);
            if (subfolderIndex >= 0) {
                this.subfolders.remove(subfolderIndex);
            }
            Object object2 = this.entriesLock;
            synchronized (object2) {
                entriesIndex = this.entries.indexOf(webDAVEntry);
                if (entriesIndex >= 0) {
                    this.entries.remove(entriesIndex);
                }
                entriesIndex += this.subfolders.size();
            }
        }
        if (subfolderIndex >= 0) {
            this.repository.fireEntryRemoved(webDAVEntry, this, subfolderIndex);
        } else if (entriesIndex >= 0) {
            this.repository.fireEntryRemoved(webDAVEntry, this, entriesIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(WebDAVEntry entry) {
        if (entry instanceof WebDAVFolder) {
            Object object = this.subfoldersLock;
            synchronized (object) {
                this.subfolders.add((Folder)entry);
            }
            this.repository.fireEntryAdded(entry, this);
        } else {
            Object object = this.entriesLock;
            synchronized (object) {
                this.entries.add((DataEntry)entry);
            }
            this.repository.fireEntryAdded(entry, this);
        }
    }
}

