/*
 * Decompiled with CFR 0.152.
 */
package com.owc.repository;

import com.gc.iotools.stream.os.OutputStreamToInputStream;
import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.owc.repository.WebDAVEntry;
import com.owc.repository.WebDAVFolder;
import com.owc.repository.WebDAVRepository;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.tools.IOObjectSerializer;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.XMLSerialization;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;

public class WebDAVObjectEntry
extends WebDAVEntry
implements IOObjectEntry {
    private static final String SUFFIX_METADATA = ".metadata";
    private static final String SUFFIX_IOOBJECT = ".ioobject";
    public static final QName QNAME_CLASS = new QName("http://oldworldcomputing.com/namespaces/dav-repository", "class", "dr");
    public static final QName QNAME_METADATA = new QName("http://oldworldcomputing.com/namespaces/dav-repository", "metadata", "dr");
    public static final QName QNAME_REVISION = new QName("http://oldworldcomputing.com/namespaces/dav-repository", "revision", "dr");
    public static final Charset META_DATA_ENCODING = Charset.forName("UTF-8");
    private long date;
    private int revision;
    private long size;
    private Class objectClass = null;

    public WebDAVObjectEntry(IOObject object, Operator operator, ProgressListener listener, WebDAVRepository repository, Sardine sardine, WebDAVFolder containingFolder, String entryName, String owner, String description, long date, boolean isReadOnly) throws RepositoryException {
        super(repository, sardine, containingFolder, entryName, "data", owner, description, isReadOnly);
        this.storeData(object, operator, listener);
    }

    public WebDAVObjectEntry(WebDAVRepository repository, Sardine sardine, WebDAVFolder containingFolder, DavResource resource) {
        super(repository, sardine, containingFolder, resource.getName(), resource.getCustomPropsNS().get(QNAME_TYPE), null, resource.getCustomPropsNS().get(QNAME_DESCRIPTION), false);
        try {
            this.owner = sardine.getAcl(this.getDAVURL()).getOwner();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.size = resource.getContentLength();
        this.date = resource.getCreation().getTime();
    }

    public long getDate() {
        return this.date;
    }

    public int getRevision() {
        return this.revision;
    }

    public long getSize() {
        return this.size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IOObject retrieveData(ProgressListener l) throws RepositoryException {
        try (InputStream in = this.sardine.get(this.getDAVURL() + SUFFIX_IOOBJECT);){
            IOObject iOObject = (IOObject)IOObjectSerializer.getInstance().deserialize(in);
            return iOObject;
        }
        catch (IOException e) {
            throw new RepositoryException("Cannot read from DAV Resource.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetaData retrieveMetaData() throws RepositoryException {
        try (InputStream in = this.sardine.get(this.getDAVURL() + SUFFIX_METADATA);){
            MetaData metaData = (MetaData)XMLSerialization.getXMLSerialization().fromXML(in);
            return metaData;
        }
        catch (IOException e) {
            throw new RepositoryException("Cannot read from DAV Resource.", (Throwable)e);
        }
    }

    public Class<? extends IOObject> getObjectClass() {
        if (this.objectClass == null) {
            try {
                List<DavResource> resource = this.sardine.propfind(this.getDAVURL() + SUFFIX_IOOBJECT, 0, Collections.singleton(QNAME_CLASS));
                if (resource.size() == 1) {
                    DavResource t = resource.get(0);
                    String className = t.getCustomPropsNS().get(QNAME_CLASS);
                    try {
                        this.objectClass = this.getClass().getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.objectClass;
    }

    public void storeData(IOObject data, Operator callingOperator, ProgressListener l) throws RepositoryException {
        try (OutputStreamToInputStream<Void> out = new OutputStreamToInputStream<Void>(){

            @Override
            protected Void doRead(InputStream istream) throws Exception {
                WebDAVObjectEntry.this.sardine.put(WebDAVObjectEntry.this.getDAVURL() + WebDAVObjectEntry.SUFFIX_IOOBJECT, istream);
                return null;
            }
        };){
            IOObjectSerializer.getInstance().serialize((OutputStream)out, (Object)data);
        }
        catch (Exception e) {
            throw new RepositoryException("Couldn't store data in DAV", (Throwable)e);
        }
        HashMap<QName, String> properties = new HashMap<QName, String>();
        MetaData metaData = MetaData.forIOObject((IOObject)data);
        try (OutputStreamToInputStream<Void> out = new OutputStreamToInputStream<Void>(){

            @Override
            protected Void doRead(InputStream istream) throws Exception {
                WebDAVObjectEntry.this.sardine.put(WebDAVObjectEntry.this.getDAVURL() + WebDAVObjectEntry.SUFFIX_METADATA, istream);
                return null;
            }
        };){
            XMLSerialization.getXMLSerialization().writeXML((Object)metaData, (OutputStream)out);
        }
        catch (Exception e) {
            throw new RepositoryException("Couldn't serialize metadata for storage.", (Throwable)e);
        }
        properties.put(QNAME_TYPE, this.type);
        properties.put(QNAME_DESCRIPTION, this.description);
        properties.put(QNAME_REVISION, Integer.toString(this.revision));
        try {
            this.sardine.patch(this.getDAVURL() + SUFFIX_IOOBJECT, properties);
        }
        catch (IOException e) {
            throw new RepositoryException("Couldn't store metadata in DAV.", (Throwable)e);
        }
    }
}

