/*
 * Decompiled with CFR 0.152.
 */
package com.owc.repository;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.owc.repository.WebDAVEntry;
import com.owc.repository.WebDAVFolder;
import com.owc.repository.WebDAVRepository;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;

public class WebDAVProcessEntry
extends WebDAVEntry
implements ProcessEntry {
    public static final Charset PROCESS_ENCODING = Charset.forName("UTF-8");
    private long date;
    private int revision;
    private long size;

    public WebDAVProcessEntry(String processXML, WebDAVRepository repository, Sardine sardine, WebDAVFolder containingFolder, String entryName, String owner, String description, long date, boolean isReadOnly) throws RepositoryException {
        super(repository, sardine, containingFolder, entryName, "data", owner, description, isReadOnly);
        this.storeXML(processXML);
    }

    public WebDAVProcessEntry(WebDAVRepository repository, Sardine sardine, WebDAVFolder containingFolder, DavResource resource) {
        super(repository, sardine, containingFolder, resource.getName(), resource.getCustomPropsNS().get(QNAME_TYPE), null, resource.getCustomPropsNS().get(QNAME_DESCRIPTION), false);
        try {
            this.owner = sardine.getAcl(this.getDAVURL()).getOwner();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.size = resource.getContentLength();
        this.date = resource.getCreation().getTime();
    }

    public long getDate() {
        return this.date;
    }

    public int getRevision() {
        return this.revision;
    }

    public long getSize() {
        return this.size;
    }

    public String retrieveXML() throws RepositoryException {
        try {
            return IOUtils.toString(this.sardine.get(this.getDAVURL()), PROCESS_ENCODING);
        }
        catch (IOException e) {
            throw new RepositoryException("Couldn't read process from DAV", (Throwable)e);
        }
    }

    public void storeXML(String xml) throws RepositoryException {
        try {
            this.sardine.put(this.getDAVURL(), xml.getBytes(PROCESS_ENCODING));
        }
        catch (IOException e) {
            throw new RepositoryException("Couldn't store process in DAV", (Throwable)e);
        }
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(QNAME_TYPE, this.type);
        properties.put(QNAME_DESCRIPTION, this.description);
        try {
            this.sardine.patch(this.getDAVURL(), properties);
        }
        catch (IOException e) {
            throw new RepositoryException("Couldn't store metadata in DAV.", (Throwable)e);
        }
    }
}

