/*
 * Decompiled with CFR 0.152.
 */
package com.owc.repository;

import com.github.sardine.SardineFactory;
import com.owc.repository.WebDAVFolder;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.repository.BlobEntry;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryListener;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.gui.RepositoryConfigurationPanel;
import com.rapidminer.tools.ProgressListener;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebDAVRepository
implements Repository {
    private final EventListenerList listeners = new EventListenerList();
    private String name;
    private String username;
    private String password;
    private String baseURL;
    private WebDAVFolder rootFolder;

    public WebDAVRepository(String name, String baseURL, String username, String password) throws RepositoryException {
        this.username = username;
        this.password = password;
        this.baseURL = baseURL;
        this.rootFolder = new WebDAVFolder(this, SardineFactory.begin(username, password), name);
    }

    public void addRepositoryListener(RepositoryListener l) {
        this.listeners.add(RepositoryListener.class, l);
    }

    public void removeRepositoryListener(RepositoryListener l) {
        this.listeners.remove(RepositoryListener.class, l);
    }

    protected void fireEntryRenamed(Entry entry) {
        for (RepositoryListener l : (RepositoryListener[])this.listeners.getListeners(RepositoryListener.class)) {
            l.entryChanged(entry);
        }
    }

    protected void fireEntryAdded(Entry newEntry, Folder parent) {
        for (RepositoryListener l : (RepositoryListener[])this.listeners.getListeners(RepositoryListener.class)) {
            l.entryAdded(newEntry, parent);
        }
    }

    public void fireRefreshed(Folder folder) {
        for (RepositoryListener l : (RepositoryListener[])this.listeners.getListeners(RepositoryListener.class)) {
            l.folderRefreshed(folder);
        }
    }

    protected void fireEntryRemoved(Entry removedEntry, Folder parent, int index) {
        for (RepositoryListener l : (RepositoryListener[])this.listeners.getListeners(RepositoryListener.class)) {
            l.entryRemoved(removedEntry, parent, index);
        }
    }

    public Entry locate(String entry) throws RepositoryException {
        return RepositoryManager.getInstance(null).locate((Repository)this, entry, false);
    }

    public String getState() {
        return "online";
    }

    public String getIconName() {
        return null;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public Element createXML(Document doc) {
        return null;
    }

    public boolean shouldSave() {
        return true;
    }

    public void postInstall() {
    }

    public void preRemove() {
    }

    public boolean isConfigurable() {
        return true;
    }

    public RepositoryConfigurationPanel makeConfigurationPanel() {
        return null;
    }

    public String getUsername() {
        return this.username;
    }

    public List<DataEntry> getDataEntries() throws RepositoryException {
        return this.rootFolder.getDataEntries();
    }

    public List<Folder> getSubfolders() throws RepositoryException {
        return this.rootFolder.getSubfolders();
    }

    public void refresh() throws RepositoryException {
        this.rootFolder.refresh();
    }

    public boolean containsEntry(String name) throws RepositoryException {
        return this.rootFolder.containsEntry(name);
    }

    public Folder createFolder(String name) throws RepositoryException {
        return this.rootFolder.createFolder(name);
    }

    public IOObjectEntry createIOObjectEntry(String name, IOObject ioobject, Operator callingOperator, ProgressListener progressListener) throws RepositoryException {
        return this.rootFolder.createIOObjectEntry(name, ioobject, callingOperator, progressListener);
    }

    public ProcessEntry createProcessEntry(String name, String processXML) throws RepositoryException {
        return this.rootFolder.createProcessEntry(name, processXML);
    }

    public BlobEntry createBlobEntry(String name) throws RepositoryException {
        return this.rootFolder.createBlobEntry(name);
    }

    public boolean canRefreshChild(String childName) throws RepositoryException {
        return this.rootFolder.canRefreshChild(childName);
    }

    public String getName() {
        return this.rootFolder.getName();
    }

    public String getType() {
        return this.rootFolder.getType();
    }

    public String getOwner() {
        return this.rootFolder.getOwner();
    }

    public String getDescription() {
        return this.rootFolder.getDescription();
    }

    public boolean isReadOnly() {
        return this.rootFolder.isReadOnly();
    }

    public boolean rename(String newName) throws RepositoryException {
        throw new RepositoryException("Root cannot be renamed.");
    }

    public boolean move(Folder newParent) throws RepositoryException {
        throw new RepositoryException("Root cannot be moved.");
    }

    public boolean move(Folder newParent, String newName) throws RepositoryException {
        throw new RepositoryException("Root cannot be moved.");
    }

    public Folder getContainingFolder() {
        return null;
    }

    public boolean willBlock() {
        return this.rootFolder.willBlock();
    }

    public RepositoryLocation getLocation() {
        return this.rootFolder.getLocation();
    }

    public void delete() throws RepositoryException {
        throw new RepositoryException("Root cannot be deleted.");
    }

    public Collection<Action> getCustomActions() {
        return this.rootFolder.getCustomActions();
    }
}

