/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class CSVIterator {
    private static int lineFeed = 10;
    private static int carriageReturn = 13;
    private static int blank = 32;
    private BufferedReader bufferedReader;
    private boolean useQuotes;
    private int quote;
    private int escapeCharacter;
    private int splitCharacter;
    private int commentCharacter;
    private CSVState currentState = CSVState.BeforeLine;
    private StringBuilder buffer = null;
    private boolean isForwardedToNext = false;

    public CSVIterator(InputStream inputStream, boolean useQuotes, char quote, char escapeCharacter, char splitCharacter, char commentCharacter, Charset charset) {
        this.bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));
        this.useQuotes = useQuotes;
        this.quote = quote;
        this.escapeCharacter = escapeCharacter;
        this.splitCharacter = splitCharacter;
        this.commentCharacter = commentCharacter;
    }

    public boolean hasNext() throws IOException {
        if (!this.isForwardedToNext) {
            this.advanceToNextValue();
            this.isForwardedToNext = true;
        }
        return this.buffer != null || this.currentState != CSVState.EndOfFile;
    }

    public String next() throws IOException {
        if (this.hasNext()) {
            String nextValue = null;
            if (this.buffer != null) {
                this.buffer.trimToSize();
                nextValue = this.buffer.toString();
            }
            this.isForwardedToNext = false;
            return nextValue;
        }
        throw new IOException("No next value");
    }

    private void advanceToNextValue() throws IOException {
        if (this.currentState == CSVState.SwitchLine) {
            this.buffer = null;
            this.currentState = CSVState.BeforeLine;
            return;
        }
        block11: while (true) {
            int charCode = this.bufferedReader.read();
            switch (this.currentState) {
                case Comment: {
                    if (charCode == -1) {
                        this.currentState = CSVState.EndOfFile;
                        return;
                    }
                    if (charCode != lineFeed && charCode != carriageReturn) continue block11;
                    this.currentState = CSVState.BeforeLine;
                    break;
                }
                case EndOfFile: {
                    return;
                }
                case EscapeSequence: {
                    if (charCode == -1) {
                        throw new IOException("Unexepcted End Of File");
                    }
                    this.buffer.append((char)charCode);
                    this.currentState = CSVState.InValue;
                    break;
                }
                case EscapeSequenceInQuote: {
                    if (charCode == -1) {
                        throw new IOException("Unexepcted End Of File");
                    }
                    this.buffer.append((char)charCode);
                    this.currentState = CSVState.InQuotedValue;
                    break;
                }
                case InQuotedValue: {
                    if (charCode == -1) {
                        throw new IOException("Unexepcted End Of File");
                    }
                    if (charCode == this.quote) {
                        this.currentState = CSVState.AfterQuotedValue;
                        break;
                    }
                    if (charCode == this.escapeCharacter) {
                        this.currentState = CSVState.EscapeSequenceInQuote;
                        break;
                    }
                    this.buffer.append((char)charCode);
                    break;
                }
                case AfterQuotedValue: {
                    if (charCode == -1) {
                        this.currentState = CSVState.EndOfFile;
                        return;
                    }
                    if (charCode == this.splitCharacter) {
                        this.currentState = CSVState.BeforeValue;
                        return;
                    }
                    if (charCode == lineFeed || charCode == carriageReturn) {
                        this.currentState = CSVState.SwitchLine;
                        return;
                    }
                    throw new IOException("Illegal Character in CSV Sequence: Only separator allowed after quote.");
                }
                case SwitchLine: 
                case BeforeLine: {
                    if (charCode == -1) {
                        this.currentState = CSVState.EndOfFile;
                        return;
                    }
                    if (charCode == this.splitCharacter) {
                        this.buffer = new StringBuilder();
                        this.currentState = CSVState.BeforeValue;
                        return;
                    }
                    if (charCode == this.quote && this.useQuotes) {
                        this.buffer = new StringBuilder();
                        this.currentState = CSVState.InQuotedValue;
                        break;
                    }
                    if (charCode == lineFeed || charCode == carriageReturn) continue block11;
                    if (charCode == this.escapeCharacter) {
                        this.buffer = new StringBuilder();
                        this.currentState = CSVState.EscapeSequence;
                        break;
                    }
                    if (charCode == blank) {
                        this.buffer = new StringBuilder();
                        break;
                    }
                    if (charCode == this.commentCharacter) {
                        this.currentState = CSVState.Comment;
                        break;
                    }
                    this.buffer = new StringBuilder();
                    this.currentState = CSVState.InValue;
                    this.buffer.append((char)charCode);
                    break;
                }
                case BeforeValue: {
                    this.buffer = new StringBuilder();
                    if (charCode == -1) {
                        this.currentState = CSVState.EndOfFile;
                        return;
                    }
                    if (charCode == this.splitCharacter) {
                        this.currentState = CSVState.BeforeValue;
                        return;
                    }
                    if (charCode == this.quote && this.useQuotes) {
                        this.currentState = CSVState.InQuotedValue;
                        break;
                    }
                    if (charCode == lineFeed || charCode == carriageReturn) {
                        this.currentState = CSVState.SwitchLine;
                        return;
                    }
                    if (charCode == this.escapeCharacter) {
                        this.currentState = CSVState.EscapeSequence;
                        break;
                    }
                    if (charCode == blank) continue block11;
                    this.currentState = CSVState.InValue;
                    this.buffer.append((char)charCode);
                    break;
                }
                case InValue: {
                    if (charCode == -1) {
                        this.currentState = CSVState.EndOfFile;
                        return;
                    }
                    if (charCode == this.splitCharacter) {
                        this.currentState = CSVState.BeforeValue;
                        return;
                    }
                    if (charCode == lineFeed || charCode == carriageReturn) {
                        this.currentState = CSVState.SwitchLine;
                        return;
                    }
                    if (charCode == this.escapeCharacter) {
                        this.currentState = CSVState.EscapeSequence;
                        break;
                    }
                    this.buffer.append((char)charCode);
                }
            }
        }
    }

    private static enum CSVState {
        SwitchLine,
        Comment,
        InValue,
        InQuotedValue,
        AfterQuotedValue,
        BeforeValue,
        EscapeSequence,
        EscapeSequenceInQuote,
        EndOfFile,
        BeforeLine;

    }
}

