/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.expressions;

import com.rapidminer.tools.expression.ExpressionEvaluator;
import com.rapidminer.tools.expression.ExpressionParsingException;
import com.rapidminer.tools.expression.ExpressionType;
import com.rapidminer.tools.expression.internal.SimpleExpressionEvaluator;
import com.rapidminer.tools.expression.internal.function.AbstractFunction;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Date;
import java.util.concurrent.Callable;
import org.apache.ws.commons.util.Base64;

public class HashFunction
extends AbstractFunction {
    private static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");

    public HashFunction() {
        super("text_transformation.hash", -1, 7);
    }

    public ExpressionEvaluator compute(final ExpressionEvaluator ... inputEvaluators) throws ExpressionParsingException {
        return new SimpleExpressionEvaluator((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                block7: for (ExpressionEvaluator evaluator : inputEvaluators) {
                    switch (evaluator.getType()) {
                        case BOOLEAN: {
                            digest.update((Boolean)evaluator.getBooleanFunction().call() != false ? (byte)0 : 1);
                            continue block7;
                        }
                        case DATE: {
                            digest.update(HashFunction.longToByteArray(((Date)evaluator.getDateFunction().call()).toInstant().getEpochSecond()));
                            continue block7;
                        }
                        case DOUBLE: {
                            digest.update(HashFunction.longToByteArray(Double.doubleToLongBits(evaluator.getDoubleFunction().call())));
                            continue block7;
                        }
                        case INTEGER: {
                            digest.update(HashFunction.longToByteArray((long)evaluator.getDoubleFunction().call()));
                            continue block7;
                        }
                        case STRING: {
                            digest.update(((String)evaluator.getStringFunction().call()).getBytes(DEFAULT_CHARSET));
                            continue block7;
                        }
                    }
                }
                return Base64.encode((byte[])digest.digest());
            }
        }, ExpressionType.STRING, false);
    }

    protected ExpressionType computeType(ExpressionType ... inputTypes) {
        return ExpressionType.STRING;
    }

    public static byte[] longToByteArray(long value) {
        return new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }
}

