/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.expressions;

import com.rapidminer.tools.expression.DoubleCallable;
import com.rapidminer.tools.expression.ExpressionEvaluator;
import com.rapidminer.tools.expression.ExpressionParsingException;
import com.rapidminer.tools.expression.ExpressionType;
import com.rapidminer.tools.expression.internal.SimpleExpressionEvaluator;
import com.rapidminer.tools.expression.internal.function.AbstractFunction;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Date;

public class HashModuloFunction
extends AbstractFunction {
    private static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");

    public HashModuloFunction() {
        super("text_transformation.hash_modulo", -1, 3);
    }

    public ExpressionEvaluator compute(final ExpressionEvaluator ... inputEvaluators) throws ExpressionParsingException {
        return new SimpleExpressionEvaluator(new DoubleCallable(){

            public double call() throws Exception {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                if (inputEvaluators.length < 2) {
                    throw new ExpressionParsingException((Throwable)new IllegalArgumentException("hash_modulo requires at least two arguments, the first one the integer for calculating the modulo."));
                }
                ExpressionEvaluator moduloEvaluator = inputEvaluators[0];
                if (moduloEvaluator.getType() != ExpressionType.INTEGER) {
                    throw new ExpressionParsingException((Throwable)new IllegalArgumentException("hash_modulo requires at least integer as first argument."));
                }
                long modulo = (long)moduloEvaluator.getDoubleFunction().call();
                block7: for (int i = 1; i < inputEvaluators.length; ++i) {
                    ExpressionEvaluator evaluator = inputEvaluators[i];
                    switch (evaluator.getType()) {
                        case BOOLEAN: {
                            digest.update((Boolean)evaluator.getBooleanFunction().call() != false ? (byte)0 : 1);
                            continue block7;
                        }
                        case DATE: {
                            digest.update(HashModuloFunction.longToByteArray(((Date)evaluator.getDateFunction().call()).toInstant().getEpochSecond()));
                            continue block7;
                        }
                        case DOUBLE: {
                            digest.update(HashModuloFunction.longToByteArray(Double.doubleToLongBits(evaluator.getDoubleFunction().call())));
                            continue block7;
                        }
                        case INTEGER: {
                            digest.update(HashModuloFunction.longToByteArray((long)evaluator.getDoubleFunction().call()));
                            continue block7;
                        }
                        case STRING: {
                            digest.update(((String)evaluator.getStringFunction().call()).getBytes(DEFAULT_CHARSET));
                            continue block7;
                        }
                    }
                }
                return new BigInteger(digest.digest()).mod(BigInteger.valueOf(modulo)).doubleValue();
            }
        }, ExpressionType.DOUBLE, false);
    }

    protected ExpressionType computeType(ExpressionType ... inputTypes) {
        return ExpressionType.STRING;
    }

    public static byte[] longToByteArray(long value) {
        return new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }
}

