/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.files.remote.configuration;

import com.owc.tools.files.remote.configuration.RemoteFileConnectionConfigurable;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.config.AbstractConfigurator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class RemoteFileConnectionConfigurator
extends AbstractConfigurator<RemoteFileConnectionConfigurable> {
    public static final String PARAMETER_CONNECTION_TYPE = "connection_type";
    public static final String PARAMETER_HOST = "host";
    public static final String PARAMETER_USERNAME = "username";
    public static final String PARAMETER_PASSWORD = "password";
    public static final String PARAMETER_ROOT_DIRECTORY = "root_directory";
    public static final String PARAMETER_PORT_FTP = "port_ftp";
    public static final String PARAMETER_PORT_SFTP = "port_sftp";
    public static final String PARAMETER_PORT_FTPS = "port_ftps";
    public static final String[] connection_types = new String[]{"FTP", "SFTP", "FTPS (explicit)"};
    public static final int CONNECTION_TYPE_FTP_INDEX = 0;
    public static final int CONNECTION_TYPE_SFTP_INDEX = 1;
    public static final int CONNECTION_TYPE_FTPS_INDEX = 2;

    public Class<RemoteFileConnectionConfigurable> getConfigurableClass() {
        return RemoteFileConnectionConfigurable.class;
    }

    public String getTypeId() {
        return "RemoteFileConnection";
    }

    public String getI18NBaseKey() {
        return "toolkit.remote_file_connection";
    }

    public List<ParameterType> getParameterTypes(ParameterHandler parameterHandler) {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_CONNECTION_TYPE, "Defines the protocol which will be used to connect to the remote filesystem.", connection_types, 0);
        type.setOptional(false);
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_HOST, "Host address containing a remote filesystem.", "127.0.0.1");
        type.setOptional(false);
        types.add((ParameterType)type);
        ParameterTypeInt port = new ParameterTypeInt(PARAMETER_PORT_FTP, "FTP Port", 0, Integer.MAX_VALUE, 21);
        port.setExpert(false);
        port.registerDependencyCondition((ParameterCondition)new EqualStringCondition(parameterHandler, PARAMETER_CONNECTION_TYPE, false, new String[]{connection_types[0]}));
        types.add((ParameterType)port);
        port = new ParameterTypeInt(PARAMETER_PORT_SFTP, "SFTP Port", 0, Integer.MAX_VALUE, 22);
        port.setExpert(false);
        port.registerDependencyCondition((ParameterCondition)new EqualStringCondition(parameterHandler, PARAMETER_CONNECTION_TYPE, false, new String[]{connection_types[1]}));
        types.add((ParameterType)port);
        port = new ParameterTypeInt(PARAMETER_PORT_FTPS, "FTPS Port", 0, Integer.MAX_VALUE, 21);
        port.setExpert(false);
        port.registerDependencyCondition((ParameterCondition)new EqualStringCondition(parameterHandler, PARAMETER_CONNECTION_TYPE, false, new String[]{connection_types[2]}));
        types.add((ParameterType)port);
        type = new ParameterTypeString(PARAMETER_USERNAME, "This parameter is used to authenticate to the server with the provided username and password.");
        type.setOptional(false);
        types.add((ParameterType)type);
        type = new ParameterTypePassword(PARAMETER_PASSWORD, "This parameter is used to authenticate to the server with the provided username and password.");
        type.setOptional(false);
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_ROOT_DIRECTORY, "OPTIONAL: The provided directory (e.g. \"/directory\" to chose the directory folder in the top layer as the selected root/working directory) will be set as new root directory, make sure that the provided directory is a sub dirctory of the original root directory of the targeted remote filesystem.", File.separator, false);
        type.setOptional(true);
        types.add((ParameterType)type);
        return types;
    }
}

