/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.files.remote.tasks;

import com.owc.tools.files.remote.RemoteFileSystemCheck;
import com.owc.tools.files.remote.RemoteFileSystemOperations;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.owc.tools.files.remote.tasks.RefreshRemoteFileObjectCheck;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;

public class CopyLocalFileToRemoteFileCheck
extends RemoteFileSystemCheck {
    com.rapidminer.operator.nio.file.FileObject localFile;

    public CopyLocalFileToRemoteFileCheck(FileSystemManager manager, com.rapidminer.operator.nio.file.FileObject file, String remoteFileUri) {
        super(manager, "toolkit.writing_file", file.getName(), remoteFileUri);
        this.localFile = file;
    }

    @Override
    public void performRemoteCheck(Operator op, long delayMillis, int numberOfRetries, FileObject remoteFile) throws RemoteFileSystemTaskFailedException, UserError, OperatorException, ProcessStoppedException {
        try (FileObject localVfsFileObject = this.manager.resolveFile(this.localFile.getFile().getParentFile(), this.localFile.getFile().getName());){
            remoteFile.copyFrom(localVfsFileObject, new AllFileSelector());
            RefreshRemoteFileObjectCheck refreshCheck = new RefreshRemoteFileObjectCheck(this.manager);
            try {
                RemoteFileSystemOperations.getInstance().performRemoteFileSystemCheck(op, refreshCheck, delayMillis, numberOfRetries, remoteFile);
            }
            catch (RemoteFileSystemTaskFailedException e) {
                throw e.getUserError();
            }
        }
        catch (FileSystemException e) {
            throw new RemoteFileSystemTaskFailedException(new UserError(op, (Throwable)e, 302, new Object[]{this.localFile.getFile().getAbsolutePath(), e.getMessage()}));
        }
    }
}

